/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiNavigator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinTrySurrounderBase;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtTryExpression;

public class KotlinTryFinallySurrounder
extends KotlinTrySurrounderBase<KtFinallySection> {
    @Override
    protected String getCodeTemplate() {
        return "try { \n} finally {\n\n}";
    }

    @Override
    protected void applyNavigation(@NotNull ActionContext context2, @NotNull ModPsiNavigator navigator, KtFinallySection element) {
        if (context2 == null) {
            KotlinTryFinallySurrounder.$$$reportNull$$$0(0);
        }
        if (navigator == null) {
            KotlinTryFinallySurrounder.$$$reportNull$$$0(1);
        }
        KotlinTryFinallySurrounder.moveCaretToBlockCenter(context2, navigator, (KtElement)element.getFinalExpression());
    }

    public static void moveCaretToBlockCenter(@NotNull ActionContext context2, @NotNull ModPsiNavigator navigator, KtElement expression) {
        if (context2 == null) {
            KotlinTryFinallySurrounder.$$$reportNull$$$0(2);
        }
        if (navigator == null) {
            KotlinTryFinallySurrounder.$$$reportNull$$$0(3);
        }
        Project project = context2.project();
        Document document = expression.getContainingFile().getFileDocument();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        TextRange finallyBlockRange = expression.getTextRange();
        int newLineOffset = finallyBlockRange.getStartOffset() + 2;
        int offset = CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, newLineOffset);
        navigator.select(TextRange.from((int)offset, (int)0));
        psiDocumentManager.commitDocument(document);
    }

    @Override
    protected KtFinallySection getSelectionElement(@NotNull KtTryExpression tryExpression) {
        if (tryExpression == null) {
            KotlinTryFinallySurrounder.$$$reportNull$$$0(4);
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)tryExpression.getProject());
        tryExpression = (KtTryExpression)codeStyleManager.reformat((PsiElement)tryExpression);
        return tryExpression.getFinallyBlock();
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.try.finally.template", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryExpression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTryFinallySurrounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyNavigation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "moveCaretToBlockCenter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectionElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

