/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.SilentChangeVetoer;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.java.analysis.OuterModelsModificationTrackerManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinOptimizeImportsFacility;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCodeInsightWorkspaceSettings;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.KotlinOptimizeImportsQuickFix;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.KotlinUnusedImportInspection;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u001e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0002J \u0010\u0017\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J.\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/KotlinUnusedImportInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "analyzeImports", "Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinOptimizeImportsFacility$ImportData;", "Lorg/jetbrains/kotlin/psi/KtFile;", "scheduleOptimizeImportsOnTheFly", "", "data", "scheduleOptimizeOnDaemonFinished", "action", "Lkotlin/Function0;", "timeToOptimizeImportsOnTheFly", "editor", "Lcom/intellij/openapi/editor/Editor;", "extensionsAllowToChangeFileSilently", "Lcom/intellij/util/ThreeState;", "optimizeImportsOnTheFly", "optimizedImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "project", "Lcom/intellij/openapi/project/Project;", "EnableOptimizeImportsOnTheFlyFix", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nKotlinUnusedImportInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinUnusedImportInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/KotlinUnusedImportInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,182:1\n1557#2:183\n1628#2,2:184\n1630#2:188\n37#3,2:186\n37#3,2:190\n73#4:189\n*S KotlinDebug\n*F\n+ 1 KotlinUnusedImportInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/KotlinUnusedImportInspection\n*L\n47#1:183\n47#1:184,2\n47#1:188\n58#1:186,2\n67#1:190,2\n63#1:189\n*E\n"})
public final class KotlinUnusedImportInspection
extends AbstractKotlinInspection {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!(file instanceof KtFile)) {
            return null;
        }
        KotlinOptimizeImportsFacility.ImportData importData = this.analyzeImports((KtFile)file);
        if (importData == null) {
            return null;
        }
        KotlinOptimizeImportsFacility.ImportData data = importData;
        Iterable $this$map$iv = data.getUnusedImports();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtImportDirective ktImportDirective = (KtImportDirective)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ArrayList<LocalQuickFixOnPsiElement> fixes = new ArrayList<LocalQuickFixOnPsiElement>();
            fixes.add(new KotlinOptimizeImportsQuickFix((KtFile)file));
            Project project = ((KtFile)file).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!KotlinCodeInsightWorkspaceSettings.Companion.getInstance((Project)project).optimizeImportsOnTheFly) {
                fixes.add(new EnableOptimizeImportsOnTheFlyFix((KtFile)file));
            }
            Collection $this$toTypedArray$iv = fixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            collection.add(manager.createProblemDescriptor((PsiElement)it, KotlinBundle.message((String)"unused.import.directive", (Object[])new Object[0]), isOnTheFly, thisCollection$iv.toArray(new LocalQuickFix[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
        List problems = (List)destination$iv$iv;
        if (isOnTheFly) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                this.scheduleOptimizeImportsOnTheFly((KtFile)file, data);
            }
        }
        Collection $this$toTypedArray$iv = problems;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ProblemDescriptor[0]);
    }

    private final KotlinOptimizeImportsFacility.ImportData analyzeImports(KtFile file) {
        if (file instanceof KtCodeFragment) {
            return null;
        }
        if (!SourceKindFilterUtils.matches(RootKindFilter.copy$default(RootKindFilter.projectSources, false, false, false, false, true, false, 47, null), (PsiElement)file)) {
            return null;
        }
        return KotlinOptimizeImportsFacility.Companion.getInstance().analyzeImports(file);
    }

    private final void scheduleOptimizeImportsOnTheFly(KtFile file, KotlinOptimizeImportsFacility.ImportData data) {
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!KotlinCodeInsightWorkspaceSettings.Companion.getInstance((Project)project).optimizeImportsOnTheFly) {
            return;
        }
        List<ImportPath> list2 = KotlinOptimizeImportsFacility.Companion.getInstance().prepareOptimizedImports(file, data);
        if (list2 == null) {
            return;
        }
        List<ImportPath> optimizedImports = list2;
        Project project2 = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        ModificationTracker modificationTracker = OuterModelsModificationTrackerManager.getTracker((Project)project3);
        long modificationCount = modificationTracker.getModificationCount();
        ThreeState threeState = SilentChangeVetoer.extensionsAllowToChangeFileSilently((Project)project3, (VirtualFile)file.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)threeState, (String)"extensionsAllowToChangeFileSilently(...)");
        ThreeState extensionsAllowToChangeFileSilently = threeState;
        this.scheduleOptimizeOnDaemonFinished(file, (Function0<Unit>)((Function0)() -> KotlinUnusedImportInspection.scheduleOptimizeImportsOnTheFly$lambda$1(file, modificationTracker, modificationCount, this, extensionsAllowToChangeFileSilently, optimizedImports, project3)));
    }

    private final void scheduleOptimizeOnDaemonFinished(KtFile file, Function0<Unit> action) {
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable daemonDisposable = disposable;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project myProject = project;
        MessageBusConnection messageBusConnection = myProject.getMessageBus().connect(daemonDisposable);
        Topic topic = DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DAEMON_EVENT_TOPIC");
        messageBusConnection.subscribe(topic, (Object)new DaemonCodeAnalyzer.DaemonListener(daemonDisposable, myProject, file, this, action){
            final /* synthetic */ Disposable $daemonDisposable;
            final /* synthetic */ Project $myProject;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ KotlinUnusedImportInspection this$0;
            final /* synthetic */ Function0<Unit> $action;
            {
                this.$daemonDisposable = $daemonDisposable;
                this.$myProject = $myProject;
                this.$file = $file;
                this.this$0 = $receiver;
                this.$action = $action;
            }

            public void daemonCancelEventOccurred(String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                Disposer.dispose((Disposable)this.$daemonDisposable);
            }

            public void daemonFinished(Collection<? extends FileEditor> incomingFileEditors) {
                Intrinsics.checkNotNullParameter(incomingFileEditors, (String)"incomingFileEditors");
                Disposer.dispose((Disposable)this.$daemonDisposable);
                DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.$myProject);
                Intrinsics.checkNotNull((Object)daemonCodeAnalyzer, (String)"null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx");
                if (((DaemonCodeAnalyzerEx)daemonCodeAnalyzer).isErrorAnalyzingFinished((PsiFile)this.$file)) {
                    ((AppUIExecutor)AppUIExecutor.onUiThread().later().expireWith((Disposable)this.$myProject)).withDocumentsCommitted(this.$myProject).execute(() -> scheduleOptimizeOnDaemonFinished.1.daemonFinished$lambda$0(this.$file, this.$action));
                } else {
                    KotlinUnusedImportInspection.access$scheduleOptimizeOnDaemonFinished(this.this$0, this.$file, this.$action);
                }
            }

            private static final void daemonFinished$lambda$0(KtFile $file, Function0 $action) {
                if ($file.isValid() && $file.isWritable()) {
                    $action.invoke();
                }
            }
        });
    }

    private final boolean timeToOptimizeImportsOnTheFly(KtFile file, Editor editor, ThreeState extensionsAllowToChangeFileSilently) {
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (project2.isDisposed() || !file.isValid() || editor.isDisposed() || !file.isWritable()) {
            return false;
        }
        UndoManager undoManager = UndoManager.getInstance((Project)project2);
        if (undoManager.isUndoInProgress() || undoManager.isRedoInProgress()) {
            return false;
        }
        KtImportList ktImportList = file.getImportList();
        if (ktImportList == null) {
            return false;
        }
        KtImportList importList = ktImportList;
        Object object = SequencesKt.firstOrNull((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)importList), (boolean)false, (boolean)false));
        PsiWhiteSpace leftSpace = object instanceof PsiWhiteSpace ? (PsiWhiteSpace)object : null;
        Object object2 = SequencesKt.firstOrNull((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)importList), (boolean)true, (boolean)false));
        PsiWhiteSpace rightSpace = object2 instanceof PsiWhiteSpace ? (PsiWhiteSpace)object2 : null;
        PsiWhiteSpace psiWhiteSpace = leftSpace;
        PsiElement left = psiWhiteSpace != null ? (PsiElement)psiWhiteSpace : (PsiElement)importList;
        PsiWhiteSpace psiWhiteSpace2 = rightSpace;
        PsiElement right = psiWhiteSpace2 != null ? (PsiElement)psiWhiteSpace2 : (PsiElement)importList;
        TextRange importsRange = new TextRange(left.getTextRange().getStartOffset(), right.getTextRange().getEndOffset());
        if (importsRange.containsOffset(editor.getCaretModel().getOffset())) {
            return false;
        }
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx((Project)project2);
        if (!codeAnalyzer.isHighlightingAvailable((PsiFile)file)) {
            return false;
        }
        if (!codeAnalyzer.isErrorAnalyzingFinished((PsiFile)file)) {
            return false;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Ref.BooleanRef hasErrors = new Ref.BooleanRef();
        DaemonCodeAnalyzerEx.processHighlights((Document)document2, (Project)project2, (HighlightSeverity)HighlightSeverity.ERROR, (int)0, (int)document2.getTextLength(), arg_0 -> KotlinUnusedImportInspection.timeToOptimizeImportsOnTheFly$lambda$3(arg_0 -> KotlinUnusedImportInspection.timeToOptimizeImportsOnTheFly$lambda$2(importsRange, hasErrors, arg_0), arg_0));
        if (hasErrors.element) {
            return false;
        }
        return DaemonListeners.canChangeFileSilently((PsiFileSystemItem)((PsiFileSystemItem)file), (boolean)true, (ThreeState)extensionsAllowToChangeFileSilently);
    }

    private final void optimizeImportsOnTheFly(KtFile file, List<ImportPath> optimizedImports, Editor editor, Project project) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        Document document = documentManager.getDocument((PsiFile)file);
        if (document == null) {
            Document document2 = editor.getDocument();
            document = document2;
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        }
        Document doc = document;
        documentManager.commitDocument(doc);
        DocumentUtil.writeInRunUndoTransparentAction(() -> KotlinUnusedImportInspection.optimizeImportsOnTheFly$lambda$4(file, optimizedImports, project, doc));
    }

    private static final Unit scheduleOptimizeImportsOnTheFly$lambda$1(KtFile $file, ModificationTracker $modificationTracker, long $modificationCount, KotlinUnusedImportInspection this$0, ThreeState $extensionsAllowToChangeFileSilently, List $optimizedImports, Project $project) {
        Editor editor = PsiEditorUtil.findEditor((PsiElement)((PsiElement)$file));
        long currentModificationCount = $modificationTracker.getModificationCount();
        if (editor != null && currentModificationCount == $modificationCount && this$0.timeToOptimizeImportsOnTheFly($file, editor, $extensionsAllowToChangeFileSilently)) {
            this$0.optimizeImportsOnTheFly($file, $optimizedImports, editor, $project);
        }
        return Unit.INSTANCE;
    }

    private static final boolean timeToOptimizeImportsOnTheFly$lambda$2(TextRange $importsRange, Ref.BooleanRef $hasErrors, HighlightInfo highlightInfo) {
        boolean bl;
        if (!$importsRange.containsRange(highlightInfo.startOffset, highlightInfo.endOffset)) {
            $hasErrors.element = true;
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean timeToOptimizeImportsOnTheFly$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void optimizeImportsOnTheFly$lambda$4(KtFile $file, List $optimizedImports, Project $project, Document $doc) {
        KotlinOptimizeImportsFacility.Companion.getInstance().replaceImports($file, $optimizedImports);
        PsiDocumentManager.getInstance((Project)$project).doPostponedOperationsAndUnblockDocument($doc);
    }

    public static final /* synthetic */ void access$scheduleOptimizeOnDaemonFinished(KotlinUnusedImportInspection $this, KtFile file, Function0 action) {
        $this.scheduleOptimizeOnDaemonFinished(file, (Function0<Unit>)action);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\r\u0010\t\u001a\u00070\b\u00a2\u0006\u0002\b\nH\u0016J)\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/KotlinUnusedImportInspection$EnableOptimizeImportsOnTheFlyFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "getText", "", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "kotlin.code-insight.inspections.shared"})
    private static final class EnableOptimizeImportsOnTheFlyFix
    extends LocalQuickFixOnPsiElement
    implements LowPriorityAction {
        public EnableOptimizeImportsOnTheFlyFix(@NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super((PsiElement)file);
        }

        @NotNull
        public String getText() {
            String string = QuickFixBundle.message((String)"enable.optimize.imports.on.the.fly", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            SideEffectGuard.Companion.checkSideEffectAllowed(SideEffectGuard.EffectType.SETTINGS);
            KotlinCodeInsightWorkspaceSettings.Companion.getInstance((Project)project).optimizeImportsOnTheFly = true;
            new OptimizeImportsProcessor(project, file).run();
        }
    }
}

