/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.codevision;

import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.codeInsight.codevision.ClassInheritors;
import org.jetbrains.kotlin.idea.codeInsight.codevision.FunctionImplementations;
import org.jetbrains.kotlin.idea.codeInsight.codevision.FunctionOverrides;
import org.jetbrains.kotlin.idea.codeInsight.codevision.InterfaceImplementations;
import org.jetbrains.kotlin.idea.codeInsight.codevision.KotlinCodeVisionHint;
import org.jetbrains.kotlin.idea.codeInsight.codevision.KotlinCodeVisionLimitedHint;
import org.jetbrains.kotlin.idea.codeInsight.codevision.PropertyOverrides;
import org.jetbrains.kotlin.idea.codeInsight.codevision.SettingsHint;
import org.jetbrains.kotlin.idea.codeInsight.codevision.Usages;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinDefinitionsSearcher;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0004$%&'B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J2\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u001dH\u0002J \u0010#\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionHintsCollector;", "Lcom/intellij/codeInsight/hints/FactoryInlayHintsCollector;", "editor", "Lcom/intellij/openapi/editor/Editor;", "showUsages", "", "showInheritors", "usagesLimit", "", "inheritorsLimit", "<init>", "(Lcom/intellij/openapi/editor/Editor;ZZII)V", "collect", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "retrieveHints", "", "Lorg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionLimitedHint;", "project", "Lcom/intellij/openapi/project/Project;", "isStale", "cachedValue", "Lorg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionHintsCollector$CachedHints;", "prepareBlockElements", "Lkotlin/Pair;", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "hints", "Lorg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionHint;", "isElementOfInterest", "createPresentation", "factory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "result", "createSettings", "Companion", "CachedHintsProvider", "CountingUpToLimitProcessor", "CachedHints", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinCodeVisionHintsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCodeVisionHintsCollector.kt\norg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionHintsCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,246:1\n1#2:247\n1863#3,2:248\n*S KotlinDebug\n*F\n+ 1 KotlinCodeVisionHintsCollector.kt\norg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionHintsCollector\n*L\n107#1:248,2\n*E\n"})
public final class KotlinCodeVisionHintsCollector
extends FactoryInlayHintsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean showUsages;
    private final boolean showInheritors;
    private final int usagesLimit;
    private final int inheritorsLimit;
    @NotNull
    private static final Key<CachedValue<CachedHints>> hintsKey;

    public KotlinCodeVisionHintsCollector(@NotNull Editor editor, boolean showUsages, boolean showInheritors, int usagesLimit, int inheritorsLimit) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(editor);
        this.showUsages = showUsages;
        this.showInheritors = showInheritors;
        this.usagesLimit = usagesLimit;
        this.inheritorsLimit = inheritorsLimit;
    }

    public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
        List list2;
        block8: {
            block7: {
                List hints;
                List list3;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                if (!this.showUsages && !this.showInheritors) {
                    return false;
                }
                if (!this.isElementOfInterest(element)) {
                    return true;
                }
                if (editor.getProject() == null) {
                    return false;
                }
                Project project = editor.getProject();
                Intrinsics.checkNotNull((Object)project);
                List it = list3 = (hints = this.retrieveHints(project, element));
                boolean bl = false;
                list2 = !((Collection)it).isEmpty() ? list3 : null;
                if (list2 == null) break block7;
                List it2 = list2;
                boolean bl2 = false;
                List list4 = CollectionsKt.listOf(this.prepareBlockElements(element, editor, hints));
                list2 = list4;
                if (list4 != null) break block8;
            }
            list2 = CollectionsKt.emptyList();
        }
        List inlayPresentations = list2;
        Iterable $this$forEach$iv = inlayPresentations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair hintPair = (Pair)element$iv;
            boolean bl = false;
            sink.addBlockElement(((Number)hintPair.getFirst()).intValue(), true, true, 0, (InlayPresentation)hintPair.getSecond());
        }
        return true;
    }

    private final List<KotlinCodeVisionLimitedHint> retrieveHints(Project project, PsiElement element) {
        CachedHintsProvider cachedValueProvider = new CachedHintsProvider(element, this.showUsages, this.showInheritors, this.usagesLimit, this.inheritorsLimit);
        CachedValuesManager $this$retrieveHints_u24lambda_u246 = CachedValuesManager.getManager((Project)project);
        boolean bl = false;
        Object object = $this$retrieveHints_u24lambda_u246.getCachedValue((UserDataHolder)element, hintsKey, (CachedValueProvider)cachedValueProvider, false);
        CachedHints it = (CachedHints)object;
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it);
        CachedHints cachedHints = (CachedHints)(!this.isStale(it) ? object : null);
        if (cachedHints == null) {
            CachedValue cachedValue2;
            CachedValuesManager $this$retrieveHints_u24lambda_u246_u24lambda_u245 = $this$retrieveHints_u24lambda_u246;
            boolean bl3 = false;
            CachedValue it2 = cachedValue2 = $this$retrieveHints_u24lambda_u246_u24lambda_u245.createCachedValue((CachedValueProvider)cachedValueProvider);
            boolean bl4 = false;
            element.putUserData(hintsKey, (Object)it2);
            cachedHints = (CachedHints)cachedValue2.getValue();
        }
        return cachedHints.getHints();
    }

    private final boolean isStale(CachedHints cachedValue2) {
        return cachedValue2.getShowUsages() != this.showUsages || cachedValue2.getShowInheritors() != this.showInheritors;
    }

    private final Pair<Integer, InlayPresentation> prepareBlockElements(PsiElement element, Editor editor, List<? extends KotlinCodeVisionHint> hints) {
        boolean bl;
        boolean bl2 = bl = !((Collection)hints).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KotlinCodeVisionHintsCollector$prepareBlockElements$32 = false;
            String $i$a$-assert-KotlinCodeVisionHintsCollector$prepareBlockElements$32 = "Attempt to build block elements whereas hints don't exist";
            throw new AssertionError((Object)$i$a$-assert-KotlinCodeVisionHintsCollector$prepareBlockElements$32);
        }
        boolean bl3 = bl = hints.size() <= 2;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KotlinCodeVisionHintsCollector$prepareBlockElements$42 = false;
            String $i$a$-assert-KotlinCodeVisionHintsCollector$prepareBlockElements$42 = "Hints other than usages-implementations are not expected";
            throw new AssertionError((Object)$i$a$-assert-KotlinCodeVisionHintsCollector$prepareBlockElements$42);
        }
        int offset = element.getTextRange().getStartOffset();
        int line = editor.getDocument().getLineNumber(offset);
        int lineStart = editor.getDocument().getLineStartOffset(line);
        int indent = offset - lineStart;
        Object[] presentations = new InlayPresentation[hints.size() * 2];
        PresentationFactory presentationFactory = this.getFactory();
        String string = StringUtil.repeat((String)" ", (int)indent);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repeat(...)");
        presentations[0] = presentationFactory.text(string);
        int pInd = 1;
        int n = ((Collection)hints).size();
        for (int hInd = 0; hInd < n; ++hInd) {
            KotlinCodeVisionHint hint2 = hints.get(hInd);
            if (hInd != 0) {
                presentations[pInd++] = this.getFactory().text(" ");
            }
            presentations[pInd++] = this.createPresentation(this.getFactory(), element, editor, hint2);
        }
        InlayPresentation[] filledPresentations = (InlayPresentation[])ArraysKt.requireNoNulls((Object[])presentations);
        InlayPresentation seq = this.getFactory().seq(Arrays.copyOf(filledPresentations, filledPresentations.length));
        InlayPresentation withAppearingSettings = this.getFactory().changeOnHover(seq, () -> KotlinCodeVisionHintsCollector.prepareBlockElements$lambda$9(this, element, editor, filledPresentations), KotlinCodeVisionHintsCollector::prepareBlockElements$lambda$10);
        return new Pair((Object)lineStart, (Object)withAppearingSettings);
    }

    private final boolean isElementOfInterest(PsiElement element) {
        return element instanceof KtClass || element instanceof KtFunction && !(element instanceof KtFunctionLiteral) || element instanceof KtProperty && !((KtProperty)element).isLocal();
    }

    private final InlayPresentation createPresentation(PresentationFactory factory2, PsiElement element, Editor editor, KotlinCodeVisionHint result2) {
        InlayPresentation text = factory2.smallText(result2.getRegularText());
        return factory2.changeOnHover(text, () -> KotlinCodeVisionHintsCollector.createPresentation$lambda$12(factory2, text, result2, editor, element), KotlinCodeVisionHintsCollector::createPresentation$lambda$13);
    }

    private final InlayPresentation createSettings(PresentationFactory factory2, PsiElement element, Editor editor) {
        return this.createPresentation(factory2, element, editor, new SettingsHint());
    }

    private static final InlayPresentation prepareBlockElements$lambda$9(KotlinCodeVisionHintsCollector this$0, PsiElement $element, Editor $editor, InlayPresentation[] $filledPresentations) {
        Object[] objectArray = new InlayPresentation[]{this$0.getFactory().text(" "), this$0.createSettings(this$0.getFactory(), $element, $editor)};
        Object[] spaceAndSettings = objectArray;
        Object[] objectArray2 = ArrayUtil.mergeArrays((Object[])$filledPresentations, (Object[])spaceAndSettings);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"mergeArrays(...)");
        InlayPresentation[] withSettings = (InlayPresentation[])objectArray2;
        return this$0.getFactory().seq(Arrays.copyOf(withSettings, withSettings.length));
    }

    private static final boolean prepareBlockElements$lambda$10(MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Unit createPresentation$lambda$12$lambda$11(KotlinCodeVisionHint $result, Editor $editor, PsiElement $element, MouseEvent event, Point point) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)point, (String)"<unused var>");
        $result.onClick($editor, $element, event);
        return Unit.INSTANCE;
    }

    private static final InlayPresentation createPresentation$lambda$12(PresentationFactory $factory, InlayPresentation $text, KotlinCodeVisionHint $result, Editor $editor, PsiElement $element) {
        InlayPresentation onClick = $factory.onClick($text, MouseButton.Left, (arg_0, arg_1) -> KotlinCodeVisionHintsCollector.createPresentation$lambda$12$lambda$11($result, $editor, $element, arg_0, arg_1));
        return (InlayPresentation)$factory.withReferenceAttributes(onClick);
    }

    private static final boolean createPresentation$lambda$13(MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    static {
        Key key = Key.create((String)"CodeVisionHints");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        hintsKey = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionHintsCollector$CachedHints;", "", "hints", "", "Lorg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionLimitedHint;", "showUsages", "", "showInheritors", "<init>", "(Ljava/util/List;ZZ)V", "getHints", "()Ljava/util/List;", "getShowUsages", "()Z", "getShowInheritors", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "kotlin.idea"})
    public static final class CachedHints {
        @NotNull
        private final List<KotlinCodeVisionLimitedHint> hints;
        private final boolean showUsages;
        private final boolean showInheritors;

        public CachedHints(@NotNull List<? extends KotlinCodeVisionLimitedHint> hints, boolean showUsages, boolean showInheritors) {
            Intrinsics.checkNotNullParameter(hints, (String)"hints");
            this.hints = hints;
            this.showUsages = showUsages;
            this.showInheritors = showInheritors;
        }

        @NotNull
        public final List<KotlinCodeVisionLimitedHint> getHints() {
            return this.hints;
        }

        public final boolean getShowUsages() {
            return this.showUsages;
        }

        public final boolean getShowInheritors() {
            return this.showInheritors;
        }

        @NotNull
        public final List<KotlinCodeVisionLimitedHint> component1() {
            return this.hints;
        }

        public final boolean component2() {
            return this.showUsages;
        }

        public final boolean component3() {
            return this.showInheritors;
        }

        @NotNull
        public final CachedHints copy(@NotNull List<? extends KotlinCodeVisionLimitedHint> hints, boolean showUsages, boolean showInheritors) {
            Intrinsics.checkNotNullParameter(hints, (String)"hints");
            return new CachedHints(hints, showUsages, showInheritors);
        }

        public static /* synthetic */ CachedHints copy$default(CachedHints cachedHints, List list2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = cachedHints.hints;
            }
            if ((n & 2) != 0) {
                bl = cachedHints.showUsages;
            }
            if ((n & 4) != 0) {
                bl2 = cachedHints.showInheritors;
            }
            return cachedHints.copy(list2, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "CachedHints(hints=" + this.hints + ", showUsages=" + this.showUsages + ", showInheritors=" + this.showInheritors + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.hints).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.showUsages);
            result2 = result2 * 31 + Boolean.hashCode(this.showInheritors);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CachedHints)) {
                return false;
            }
            CachedHints cachedHints = (CachedHints)other;
            if (!Intrinsics.areEqual(this.hints, cachedHints.hints)) {
                return false;
            }
            if (this.showUsages != cachedHints.showUsages) {
                return false;
            }
            return this.showInheritors == cachedHints.showInheritors;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionHintsCollector$CachedHintsProvider;", "Lcom/intellij/psi/util/CachedValueProvider;", "Lorg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionHintsCollector$CachedHints;", "element", "Lcom/intellij/psi/PsiElement;", "showUsages", "", "showInheritors", "usagesLimit", "", "inheritorsLimit", "<init>", "(Lcom/intellij/psi/PsiElement;ZZII)V", "compute", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinCodeVisionHintsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCodeVisionHintsCollector.kt\norg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionHintsCollector$CachedHintsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n1#2:247\n*E\n"})
    public static final class CachedHintsProvider
    implements CachedValueProvider<CachedHints> {
        @NotNull
        private final PsiElement element;
        private final boolean showUsages;
        private final boolean showInheritors;
        private final int usagesLimit;
        private final int inheritorsLimit;

        public CachedHintsProvider(@NotNull PsiElement element, boolean showUsages, boolean showInheritors, int usagesLimit, int inheritorsLimit) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.element = element;
            this.showUsages = showUsages;
            this.showInheritors = showInheritors;
            this.usagesLimit = usagesLimit;
            this.inheritorsLimit = inheritorsLimit;
        }

        @NotNull
        public CachedValueProvider.Result<CachedHints> compute() {
            Object[] objectArray;
            List hints = (List)new SmartList();
            if (this.showUsages) {
                Usages usages = Companion.searchUsages(this.element, this.usagesLimit);
                if (usages != null) {
                    Usages it = usages;
                    boolean bl = false;
                    ((Collection)hints).add(it);
                }
            }
            if (this.showInheritors) {
                objectArray = this.element;
                if (objectArray instanceof KtFunction) {
                    KotlinCodeVisionLimitedHint kotlinCodeVisionLimitedHint = Companion.searchFunctionOverrides((KtFunction)this.element, this.inheritorsLimit);
                    if (kotlinCodeVisionLimitedHint != null) {
                        KotlinCodeVisionLimitedHint it = kotlinCodeVisionLimitedHint;
                        boolean bl = false;
                        ((Collection)hints).add(it);
                    }
                } else if (objectArray instanceof KtClass) {
                    KotlinCodeVisionLimitedHint kotlinCodeVisionLimitedHint = Companion.searchClassInheritors((KtClass)this.element, this.inheritorsLimit);
                    if (kotlinCodeVisionLimitedHint != null) {
                        KotlinCodeVisionLimitedHint it = kotlinCodeVisionLimitedHint;
                        boolean bl = false;
                        ((Collection)hints).add(it);
                    }
                } else if (objectArray instanceof KtProperty) {
                    KotlinCodeVisionLimitedHint kotlinCodeVisionLimitedHint = Companion.searchPropertyOverriding((KtProperty)this.element, this.inheritorsLimit);
                    if (kotlinCodeVisionLimitedHint != null) {
                        KotlinCodeVisionLimitedHint it = kotlinCodeVisionLimitedHint;
                        boolean bl = false;
                        ((Collection)hints).add(it);
                    }
                }
            }
            objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootModificationTracker.getInstance((Project)this.element.getProject())};
            return new CachedValueProvider.Result((Object)new CachedHints(hints, this.showUsages, this.showInheritors), objectArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002R-\u0010\u0004\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionHintsCollector$Companion;", "", "<init>", "()V", "hintsKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lorg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionHintsCollector$CachedHints;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "searchUsages", "Lorg/jetbrains/kotlin/idea/codeInsight/codevision/Usages;", "element", "Lcom/intellij/psi/PsiElement;", "usagesLimit", "", "searchFunctionOverrides", "Lorg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionLimitedHint;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "inheritorsLimit", "searchClassInheritors", "clazz", "Lorg/jetbrains/kotlin/psi/KtClass;", "searchPropertyOverriding", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinCodeVisionHintsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCodeVisionHintsCollector.kt\norg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionHintsCollector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n1#2:247\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Usages searchUsages(@NotNull PsiElement element, int usagesLimit) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            CountingUpToLimitProcessor countingProcessor = new CountingUpToLimitProcessor(usagesLimit);
            if (element instanceof KtClass) {
                ReferencesSearch.search((PsiElement)element).forEach((Processor)countingProcessor);
            } else {
                PsiMethod psiMethod = (PsiMethod)CollectionsKt.firstOrNull(OverridersSearchKt.toPossiblyFakeLightMethods(element));
                if (psiMethod != null) {
                    PsiMethod it = psiMethod;
                    boolean bl = false;
                    MethodReferencesSearch.search((PsiMethod)it).forEach((Processor)countingProcessor);
                }
            }
            int usagesNum = countingProcessor.component1();
            boolean limitReached = countingProcessor.component2();
            return usagesNum > 0 ? new Usages(usagesNum, limitReached) : null;
        }

        private final KotlinCodeVisionLimitedHint searchFunctionOverrides(KtFunction function, int inheritorsLimit) {
            KotlinCodeVisionLimitedHint kotlinCodeVisionLimitedHint;
            PsiMethod psiMethod = LightClassUtil.INSTANCE.getLightClassMethod(function);
            if (psiMethod != null) {
                PsiMethod it = psiMethod;
                boolean bl = false;
                CountingUpToLimitProcessor countingProcessor = new CountingUpToLimitProcessor(inheritorsLimit);
                OverridingMethodsSearch.search((PsiMethod)it, (boolean)true).forEach((Processor)countingProcessor);
                int overridingNum = countingProcessor.component1();
                boolean limitReached = countingProcessor.component2();
                kotlinCodeVisionLimitedHint = overridingNum > 0 ? (KotlinRefactoringUtilKt.isAbstract((KtNamedDeclaration)function) ? (KotlinCodeVisionLimitedHint)new FunctionImplementations(overridingNum, limitReached) : (KotlinCodeVisionLimitedHint)new FunctionOverrides(overridingNum, limitReached)) : null;
            } else {
                kotlinCodeVisionLimitedHint = null;
            }
            return kotlinCodeVisionLimitedHint;
        }

        private final KotlinCodeVisionLimitedHint searchClassInheritors(KtClass clazz, int inheritorsLimit) {
            KotlinCodeVisionLimitedHint kotlinCodeVisionLimitedHint;
            KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)clazz));
            if (ktLightClass != null) {
                KtLightClass it = ktLightClass;
                boolean bl = false;
                CountingUpToLimitProcessor countingProcessor = new CountingUpToLimitProcessor(inheritorsLimit);
                DirectClassInheritorsSearch.search((PsiClass)((PsiClass)it), (SearchScope)clazz.getUseScope(), (boolean)true).forEach((Processor)countingProcessor);
                int inheritorsNum = countingProcessor.component1();
                boolean limitReached = countingProcessor.component2();
                kotlinCodeVisionLimitedHint = inheritorsNum > 0 ? (clazz.isInterface() ? (KotlinCodeVisionLimitedHint)new InterfaceImplementations(inheritorsNum, limitReached) : (KotlinCodeVisionLimitedHint)new ClassInheritors(inheritorsNum, limitReached)) : null;
            } else {
                kotlinCodeVisionLimitedHint = null;
            }
            return kotlinCodeVisionLimitedHint;
        }

        private final KotlinCodeVisionLimitedHint searchPropertyOverriding(KtProperty property, int inheritorsLimit) {
            CountingUpToLimitProcessor countingProcessor = new CountingUpToLimitProcessor(inheritorsLimit);
            Iterable iterable = OverridersSearchKt.toPossiblyFakeLightMethods((PsiElement)property);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)property.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
            KotlinDefinitionsSearcher.Companion.processPropertyImplementationsMethods(iterable, (SearchScope)globalSearchScope, countingProcessor);
            int overridesNum = countingProcessor.component1();
            boolean limitReached = countingProcessor.component2();
            return overridesNum > 0 ? (KotlinCodeVisionLimitedHint)new PropertyOverrides(overridesNum, limitReached) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\t\u0010\r\u001a\u00020\u0004H\u0086\u0002J\t\u0010\u000e\u001a\u00020\nH\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionHintsCollector$CountingUpToLimitProcessor;", "T", "Lcom/intellij/util/Processor;", "limit", "", "<init>", "(I)V", "findings", "", "process", "", "t", "(Ljava/lang/Object;)Z", "component1", "component2", "kotlin.idea"})
    public static final class CountingUpToLimitProcessor<T>
    implements Processor<T> {
        private final int limit;
        @NotNull
        private final Set<T> findings;

        public CountingUpToLimitProcessor(int limit) {
            this.limit = limit;
            this.findings = new LinkedHashSet();
        }

        public boolean process(T t) {
            this.findings.add(t);
            return this.findings.size() < this.limit;
        }

        public final int component1() {
            return this.findings.size();
        }

        public final boolean component2() {
            return this.findings.size() >= this.limit;
        }
    }
}

