/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.scripting;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinBinaryExtensionKt;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderExtension;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderKt;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptDependenciesInfo;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptDependenciesSourceInfo;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptModuleInfoKt;
import org.jetbrains.kotlin.idea.base.util.SeqScope;
import org.jetbrains.kotlin.idea.core.script.ScriptDependencyAware;
import org.jetbrains.kotlin.idea.core.script.ScriptRelatedModuleNameFile;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u0005*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J8\u0010\u000f\u001a\u00020\u0005*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00170\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/base/scripting/ScriptingModuleInfoProviderExtension;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProviderExtension;", "<init>", "()V", "collectByElement", "", "Lorg/jetbrains/kotlin/idea/base/util/SeqScope;", "Lkotlin/Result;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "element", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "collectByFile", "project", "Lcom/intellij/openapi/project/Project;", "isLibrarySource", "", "config", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "findContainingModules", "Lcom/intellij/openapi/module/Module;", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptingModuleInfoProviderExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingModuleInfoProviderExtension.kt\norg/jetbrains/kotlin/idea/base/scripting/ScriptingModuleInfoProviderExtension\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,105:1\n1317#2,2:106\n*S KotlinDebug\n*F\n+ 1 ScriptingModuleInfoProviderExtension.kt\norg/jetbrains/kotlin/idea/base/scripting/ScriptingModuleInfoProviderExtension\n*L\n58#1:106,2\n*E\n"})
public final class ScriptingModuleInfoProviderExtension
implements ModuleInfoProviderExtension {
    @Override
    public void collectByElement(@NotNull SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByElement, @NotNull PsiElement element, @NotNull PsiFile file, @NotNull VirtualFile virtualFile) {
        ScriptDefinition scriptDefinition;
        Intrinsics.checkNotNullParameter($this$collectByElement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        KtFile ktFile2 = file instanceof KtFile ? (KtFile)file : null;
        if (ktFile2 == null) {
            return;
        }
        KtFile ktFile3 = ktFile2;
        boolean isScript = (Boolean)ActionsKt.runReadAction(() -> ScriptingModuleInfoProviderExtension.collectByElement$lambda$0(ktFile3));
        if (isScript && (scriptDefinition = DefinitionsKt.findScriptDefinition((PsiFile)ktFile3)) != null) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ModuleInfoProviderKt.register($this$collectByElement, new ScriptModuleInfo(project, virtualFile, scriptDefinition));
        }
    }

    @Override
    public void collectByFile(@NotNull SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByFile, @NotNull Project project, @NotNull VirtualFile virtualFile, boolean isLibrarySource, @NotNull ModuleInfoProvider.Configuration config2) {
        Intrinsics.checkNotNullParameter($this$collectByFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        FileType fileType = virtualFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        boolean isBinary = KotlinBinaryExtensionKt.isKotlinBinary(fileType);
        if (isBinary) {
            if (KotlinPluginModeProvider.Companion.isK2Mode()) {
                IdeaModuleInfo ideaModuleInfo = config2.getContextualModuleInfo();
                ScriptModuleInfo scriptModuleInfo = ideaModuleInfo instanceof ScriptModuleInfo ? (ScriptModuleInfo)ideaModuleInfo : null;
                Object scriptFile = scriptModuleInfo != null ? scriptModuleInfo.getScriptFile() : null;
                Sequence sequence = scriptFile;
                if (sequence != null && (sequence = ScriptModuleInfoKt.scriptLibraryDependencies((VirtualFile)sequence, project)) != null && (sequence = SequencesKt.filter(sequence, arg_0 -> ScriptingModuleInfoProviderExtension.collectByFile$lambda$1(virtualFile, arg_0))) != null) {
                    Sequence $this$forEach$iv = sequence;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IdeaModuleInfo p0 = (IdeaModuleInfo)element$iv;
                        boolean $i$f$collectByFile$stub_for_inlining = false;
                        boolean bl = false;
                        ModuleInfoProviderKt.register($this$collectByFile, p0);
                    }
                }
            } else if (ScriptDependencyAware.Companion.getInstance(project).getAllScriptsDependenciesClassFilesScope().contains(virtualFile)) {
                if (isLibrarySource) {
                    ModuleInfoProviderKt.register($this$collectByFile, new ScriptDependenciesSourceInfo.ForProject(project));
                } else {
                    VirtualFile scriptFile;
                    IdeaModuleInfo scriptModuleInfo = config2.getContextualModuleInfo();
                    Object object = scriptModuleInfo instanceof ScriptModuleInfo ? ((ScriptModuleInfo)scriptModuleInfo).getScriptFile() : (scriptFile = scriptModuleInfo instanceof ScriptDependenciesInfo.ForFile ? ((ScriptDependenciesInfo.ForFile)scriptModuleInfo).getScriptFile() : null);
                    if (scriptFile != null) {
                        ModuleInfoProviderKt.register($this$collectByFile, (Function0<? extends IdeaModuleInfo>)((Function0)() -> ScriptingModuleInfoProviderExtension.collectByFile$lambda$2(project, scriptFile)));
                    } else {
                        ModuleInfoProviderKt.register($this$collectByFile, new ScriptDependenciesInfo.ForProject(project));
                    }
                }
            }
        } else {
            ModuleInfoProviderKt.register($this$collectByFile, (Function0<? extends IdeaModuleInfo>)((Function0)() -> ScriptingModuleInfoProviderExtension.collectByFile$lambda$3(project, virtualFile)));
        }
    }

    @Override
    public void findContainingModules(@NotNull SeqScope<? super Module> $this$findContainingModules, @NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter($this$findContainingModules, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        $this$findContainingModules.yield((Function0<? super Module>)((Function0)() -> ScriptingModuleInfoProviderExtension.findContainingModules$lambda$5(virtualFile, project)));
    }

    private static final boolean collectByElement$lambda$0(KtFile $ktFile) {
        return $ktFile.isValid() && $ktFile.isScript();
    }

    private static final boolean collectByFile$lambda$1(VirtualFile $virtualFile, LibraryInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContentScope().contains($virtualFile);
    }

    private static final IdeaModuleInfo collectByFile$lambda$2(Project $project, VirtualFile $scriptFile) {
        return new ScriptDependenciesInfo.ForFile($project, $scriptFile, DefinitionsKt.findScriptDefinition($project, new VirtualFileScriptSource($scriptFile, null, 2, null)));
    }

    private static final IdeaModuleInfo collectByFile$lambda$3(Project $project, VirtualFile $virtualFile) {
        return ScriptDependencyAware.Companion.getInstance($project).getAllScriptDependenciesSourcesScope().contains($virtualFile) ? (IdeaModuleInfo)new ScriptDependenciesSourceInfo.ForProject($project) : null;
    }

    private static final Module findContainingModules$lambda$5(VirtualFile $virtualFile, Project $project) {
        Module module;
        if (ScratchFileService.getInstance().getRootType($virtualFile) instanceof ScratchRootType) {
            String string = ScriptRelatedModuleNameFile.Companion.get($project, $virtualFile);
            if (string != null) {
                String scratchModuleName = string;
                boolean bl = false;
                ModuleManager moduleManager = ModuleManager.Companion.getInstance($project);
                module = moduleManager.findModuleByName(scratchModuleName);
            } else {
                module = null;
            }
        } else {
            module = null;
        }
        return module;
    }
}

