/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysisApiPlatform;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalModuleStateModificationListener;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleStateModificationKind;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleStateModificationListener;
import org.jetbrains.kotlin.analysis.api.platform.utils.NullValue;
import org.jetbrains.kotlin.analysis.api.platform.utils.NullableConcurrentCache;
import org.jetbrains.kotlin.analysis.api.platform.utils.NullableConcurrentCacheKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaBuiltinsModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.idea.base.analysisApiPlatform.IdeKotlinModulePackageNamesProvider;
import org.jetbrains.kotlin.idea.base.indices.names.KotlinBinaryRootToPackageIndex;
import org.jetbrains.kotlin.idea.base.indices.names.KotlinBinaryRootToPackageIndexKt;
import org.jetbrains.kotlin.idea.base.projectStructure.KtLibraryModuleByModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KtSdkLibraryModuleByModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KtSourceModuleByModuleInfo;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t*\u0001\u0017\b\u0001\u0018\u0000 $2\u00020\u0001:\u0003\"#$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\bJ\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u0010H\u0002J#\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010!\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\"\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R \u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lorg/jetbrains/kotlin/analysis/api/platform/utils/NullableConcurrentCache;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "", "", "Ljava/util/concurrent/ConcurrentMap;", "binaryRootsCache", "computePackageNames", "module", "computeSourceModulePackageSet", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KtSourceModuleByModuleInfo;", "computePackageSetFromBinaryRoots", "binaryRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/Set;", "binaryRootSearchScope", "org/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider$binaryRootSearchScope$1", "Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider$binaryRootSearchScope$1;", "computePackageSetFromBinaryRoot", "binaryRoot", "invalidate", "", "invalidateAll", "binaryRootFiles", "getBinaryRootFiles", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)[Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "ModuleStateModificationListener", "GlobalModuleStateModificationListener", "Companion", "kotlin.base.analysis-api-platform"})
@SourceDebugExtension(value={"SMAP\nIdeKotlinModulePackageNamesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeKotlinModulePackageNamesProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider\n+ 2 NullableConcurrentCache.kt\norg/jetbrains/kotlin/analysis/api/platform/utils/NullableConcurrentCache\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,156:1\n19#2:157\n20#2:162\n19#2:172\n20#2:176\n72#3,2:158\n72#3,2:173\n1#4:160\n1#4:161\n1#4:175\n1628#5,3:163\n12574#6,2:166\n11165#6:168\n11500#6,3:169\n13409#6,2:177\n*S KotlinDebug\n*F\n+ 1 IdeKotlinModulePackageNamesProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider\n*L\n75#1:157\n75#1:162\n116#1:172\n116#1:176\n75#1:158,2\n116#1:173,2\n75#1:161\n116#1:175\n81#1:163,3\n88#1:166,2\n92#1:168\n92#1:169,3\n134#1:177,2\n*E\n"})
public final class IdeKotlinModulePackageNamesProvider
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<K, Object> cache;
    @NotNull
    private final ConcurrentMap<K, Object> binaryRootsCache;
    @NotNull
    private final binaryRootSearchScope.1 binaryRootSearchScope;

    public IdeKotlinModulePackageNamesProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cache = NullableConcurrentCache.constructor-impl$default(null, 1, null);
        this.binaryRootsCache = NullableConcurrentCache.constructor-impl$default(null, 1, null);
        LowMemoryWatcher.register(this::invalidateAll, (Disposable)this);
        Project project2 = this.project;
        this.binaryRootSearchScope = new GlobalSearchScope(project2){

            public boolean contains(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return true;
            }

            public boolean isSearchInModuleContent(Module aModule) {
                Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
                return true;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Set<String> computePackageNames(@NotNull KaModule module) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        KaModule kaModule = module;
        if (kaModule instanceof KtSourceModuleByModuleInfo) {
            set = this.computeSourceModulePackageSet((KtSourceModuleByModuleInfo)module);
        } else if (kaModule instanceof KtSdkLibraryModuleByModuleInfo || kaModule instanceof KtLibraryModuleByModuleInfo) {
            void arg0$iv;
            ConcurrentMap concurrentMap = this.cache;
            KaModule key$iv = module;
            boolean bl = false;
            void $this$getOrPut$iv$iv = arg0$iv;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv$iv.get(key$iv);
            if (object == null) {
                Object object2;
                Object object3;
                boolean bl2 = false;
                KaModule module2 = key$iv;
                boolean bl3 = false;
                VirtualFile[] virtualFileArray = this.getBinaryRootFiles(module2);
                if (virtualFileArray != null) {
                    VirtualFile[] it = virtualFileArray;
                    boolean bl4 = false;
                    object3 = this.computePackageSetFromBinaryRoots(it);
                } else {
                    object3 = object2 = null;
                }
                if (object3 == null) {
                    object2 = NullValue.INSTANCE;
                }
                Set default$iv$iv = object2;
                boolean bl5 = false;
                object = $this$getOrPut$iv$iv.putIfAbsent(key$iv, default$iv$iv);
                if (object == null) {
                    object = default$iv$iv;
                }
            }
            Object value$iv = object;
            set = (Set)NullableConcurrentCacheKt.nullValueToNull(value$iv);
        } else if (kaModule instanceof KaLibrarySourceModule) {
            set = this.computePackageNames(((KaLibrarySourceModule)module).getBinaryLibrary());
        } else if (kaModule instanceof KaBuiltinsModule) {
            void destination$iv;
            void $this$mapTo$iv;
            Iterable arg0$iv = StandardClassIds.INSTANCE.getBuiltInsPackages();
            Collection key$iv = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                FqName bl2 = (FqName)item$iv;
                void var16_23 = destination$iv;
                boolean bl = false;
                var16_23.add(it.asString());
            }
            set = (Set)destination$iv;
        } else {
            set = null;
        }
        return set;
    }

    private final Set<String> computeSourceModulePackageSet(KtSourceModuleByModuleInfo module) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> computePackageSetFromBinaryRoots(VirtualFile[] binaryRoots) {
        void $this$mapTo$iv$iv;
        boolean bl;
        block7: {
            VirtualFile[] $this$any$iv = binaryRoots;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!(!KotlinBinaryRootToPackageIndexKt.isSupportedByBinaryRootToPackageIndex(it))) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            return null;
        }
        VirtualFile[] $this$map$iv = binaryRoots;
        boolean $i$f$map = false;
        VirtualFile[] virtualFileArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void p0;
            void item$iv$iv;
            void var11_14 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean $i$f$computePackageSetFromBinaryRoots$stub_for_inlining = false;
            boolean bl3 = false;
            collection.add(this.computePackageSetFromBinaryRoot((VirtualFile)p0));
        }
        List packageNameSets = (List)destination$iv$iv;
        return switch (packageNameSets.size()) {
            case 0 -> SetsKt.emptySet();
            case 1 -> (Set)CollectionsKt.single((List)packageNameSets);
            default -> (Set)AddToStdlibKt.flattenTo((Iterable)packageNameSets, (Collection)new LinkedHashSet());
        };
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> computePackageSetFromBinaryRoot(VirtualFile binaryRoot) {
        void arg0$iv;
        ConcurrentMap concurrentMap = this.binaryRootsCache;
        String string = binaryRoot.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String key$iv = string;
        boolean bl = false;
        void $this$getOrPut$iv$iv = arg0$iv;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv$iv.get(key$iv);
        if (object == null) {
            Set set;
            boolean bl2 = false;
            String binaryRootName = key$iv;
            boolean bl3 = false;
            Set $this$computePackageSetFromBinaryRoot_u24lambda_u245_u24lambda_u244 = set = SetsKt.createSetBuilder();
            boolean bl4 = false;
            FileBasedIndex.getInstance().processValues(KotlinBinaryRootToPackageIndex.Companion.getNAME(), (Object)binaryRootName, null, new FileBasedIndex.ValueProcessor($this$computePackageSetFromBinaryRoot_u24lambda_u245_u24lambda_u244){
                final /* synthetic */ Set<String> $this_buildSet;
                {
                    this.$this_buildSet = $receiver;
                }

                public final boolean process(VirtualFile virtualFile, String packageName) {
                    Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
                    ProgressManager.checkCanceled();
                    Intrinsics.checkNotNull((Object)packageName);
                    this.$this_buildSet.add(packageName);
                    return true;
                }
            }, (GlobalSearchScope)this.binaryRootSearchScope);
            Set set2 = SetsKt.build((Set)set);
            Object object2 = set2;
            if (set2 == null) {
                object2 = NullValue.INSTANCE;
            }
            Set default$iv$iv = object2;
            boolean bl5 = false;
            object = $this$getOrPut$iv$iv.putIfAbsent(key$iv, default$iv$iv);
            if (object == null) {
                object = default$iv$iv;
            }
        }
        Object value$iv = object;
        return (Set)NullableConcurrentCacheKt.nullValueToNull(value$iv);
    }

    private final void invalidate(KaModule module) {
        block1: {
            this.cache.remove(module);
            VirtualFile[] virtualFileArray = this.getBinaryRootFiles(module);
            if (virtualFileArray == null) break block1;
            VirtualFile[] $this$forEach$iv = virtualFileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                VirtualFile element$iv;
                VirtualFile binaryRoot = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                this.binaryRootsCache.remove(binaryRoot.getName());
            }
        }
    }

    private final void invalidateAll() {
        this.cache.clear();
        this.binaryRootsCache.clear();
    }

    private final VirtualFile[] getBinaryRootFiles(KaModule $this$binaryRootFiles) {
        KaModule kaModule = $this$binaryRootFiles;
        return kaModule instanceof KtSdkLibraryModuleByModuleInfo ? ((KtSdkLibraryModuleByModuleInfo)$this$binaryRootFiles).getModuleInfo().getSdk().getRootProvider().getFiles(OrderRootType.CLASSES) : (kaModule instanceof KtLibraryModuleByModuleInfo ? ((KtLibraryModuleByModuleInfo)$this$binaryRootFiles).getLibraryInfo().getLibrary().getFiles(OrderRootType.CLASSES) : null);
    }

    public void dispose() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.analysis-api-platform"})
    @SourceDebugExtension(value={"SMAP\nIdeKotlinModulePackageNamesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeKotlinModulePackageNamesProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,156:1\n31#2,2:157\n*S KotlinDebug\n*F\n+ 1 IdeKotlinModulePackageNamesProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider$Companion\n*L\n153#1:157,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IdeKotlinModulePackageNamesProvider getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<IdeKotlinModulePackageNamesProvider> serviceClass$iv = IdeKotlinModulePackageNamesProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (IdeKotlinModulePackageNamesProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider$GlobalModuleStateModificationListener;", "Lorg/jetbrains/kotlin/analysis/api/platform/modification/KotlinGlobalModuleStateModificationListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "onModification", "", "kotlin.base.analysis-api-platform"})
    public static final class GlobalModuleStateModificationListener
    implements KotlinGlobalModuleStateModificationListener {
        @NotNull
        private final Project project;

        public GlobalModuleStateModificationListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Override
        public void onModification() {
            Companion.getInstance(this.project).invalidateAll();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider$ModuleStateModificationListener;", "Lorg/jetbrains/kotlin/analysis/api/platform/modification/KotlinModuleStateModificationListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "onModification", "", "module", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "modificationKind", "Lorg/jetbrains/kotlin/analysis/api/platform/modification/KotlinModuleStateModificationKind;", "kotlin.base.analysis-api-platform"})
    public static final class ModuleStateModificationListener
    implements KotlinModuleStateModificationListener {
        @NotNull
        private final Project project;

        public ModuleStateModificationListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Override
        public void onModification(@NotNull KaModule module, @NotNull KotlinModuleStateModificationKind modificationKind) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)modificationKind), (String)"modificationKind");
            Companion.getInstance(this.project).invalidate(module);
        }
    }
}

