/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ListPopup;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/actions/ConfigureKotlinInProjectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getApplicableConfigurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "project", "Lcom/intellij/openapi/project/Project;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nConfigureKotlinInProjectAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureKotlinInProjectAction.kt\norg/jetbrains/kotlin/idea/actions/ConfigureKotlinInProjectAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1734#2,3:60\n1734#2,3:63\n*S KotlinDebug\n*F\n+ 1 ConfigureKotlinInProjectAction.kt\norg/jetbrains/kotlin/idea/actions/ConfigureKotlinInProjectAction\n*L\n35#1:60,3\n28#1:63,3\n*E\n"})
public abstract class ConfigureKotlinInProjectAction
extends AnAction {
    @NotNull
    public abstract Collection<KotlinProjectConfigurator> getApplicableConfigurators(@NotNull Project var1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean bl;
        Collection configurators;
        Project project;
        block9: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            project = project2;
            String progressTitle = KotlinJvmBundle.message("lookup.project.configurators.progress.text", new Object[0]);
            Pair pair = (Pair)ActionUtil.underModalProgress((Project)project, (String)progressTitle, () -> ConfigureKotlinInProjectAction.actionPerformed$lambda$0(project, this));
            List modules2 = (List)pair.component1();
            configurators = (Collection)pair.component2();
            Iterable $this$all$iv = modules2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ModuleSourceRootGroup p0 = (ModuleSourceRootGroup)element$iv;
                    boolean $i$f$actionPerformed$stub_for_inlining$1 = false;
                    boolean bl2 = false;
                    if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(p0)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl) {
            String string = KotlinJvmBundle.message("all.modules.with.kotlin.files.are.configured", new Object[0]);
            String string2 = e.getPresentation().getText();
            Intrinsics.checkNotNull((Object)string2);
            Messages.showInfoMessage((String)string, (String)string2);
            return;
        }
        if (configurators.size() == 1) {
            ((KotlinProjectConfigurator)CollectionsKt.first((Iterable)configurators)).configure(project, CollectionsKt.emptyList());
        } else if (configurators.isEmpty()) {
            String string = KotlinJvmBundle.message("there.aren.t.configurators.available", new Object[0]);
            String string3 = e.getPresentation().getText();
            Intrinsics.checkNotNull((Object)string3);
            Messages.showErrorDialog((String)string, (String)string3);
        } else {
            ListPopup configuratorsPopup = KotlinSetupEnvironmentNotificationProvider.Companion.createConfiguratorsPopup$default(KotlinSetupEnvironmentNotificationProvider.Companion, project, CollectionsKt.toList((Iterable)configurators), null, 4, null);
            configuratorsPopup.showInBestPositionFor(e.getDataContext());
        }
    }

    private static final Pair actionPerformed$lambda$0(Project $project, ConfigureKotlinInProjectAction this$0) {
        boolean bl;
        List<ModuleSourceRootGroup> modules2;
        block4: {
            modules2 = ConfigureKotlinInProjectUtilsKt.getConfigurableModules($project);
            Iterable $this$all$iv = modules2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ModuleSourceRootGroup p0 = (ModuleSourceRootGroup)element$iv;
                    boolean bl2 = false;
                    boolean $i$f$actionPerformed$lambda$0$stub_for_inlining = false;
                    if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(p0)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return TuplesKt.to(modules2, (Object)CollectionsKt.emptyList());
        }
        Collection<KotlinProjectConfigurator> configurators = this$0.getApplicableConfigurators($project);
        return TuplesKt.to(modules2, configurators);
    }
}

