/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.toplevel.scopes;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntheticElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.plugins.groovy.dsl.toplevel.ClassContextFilter;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;
import org.jetbrains.plugins.groovy.dsl.toplevel.FileContextFilter;
import org.jetbrains.plugins.groovy.dsl.toplevel.scopes.Scope;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatterns;

public class ScriptScope
extends Scope {
    private final String namePattern;
    private final String extension;

    public ScriptScope(Map args) {
        this.namePattern = args == null ? null : (String)args.get("name");
        this.extension = args == null ? null : (String)args.get("extension");
    }

    @Override
    public List<ContextFilter> createFilters(Map args) {
        String ctype;
        ArrayList<ContextFilter> result2 = new ArrayList<ContextFilter>();
        PsiFilePattern.Capture scriptPattern = GroovyPatterns.groovyScript();
        if (this.extension != null && !this.extension.isEmpty()) {
            scriptPattern = (PsiFilePattern.Capture)scriptPattern.withVirtualFile((ElementPattern)PlatformPatterns.virtualFile().withExtension(this.extension));
        }
        result2.add(new FileContextFilter((ElementPattern<? extends PsiFile>)scriptPattern));
        if (this.namePattern != null && !this.namePattern.isEmpty()) {
            result2.add(new FileContextFilter((ElementPattern<? extends PsiFile>)PlatformPatterns.psiFile().withName((ElementPattern)StandardPatterns.string().matches(this.namePattern))));
        }
        if ((ctype = (String)args.get("ctype")) == null || ctype.isEmpty()) {
            ObjectPattern.Capture synt = StandardPatterns.instanceOf(SyntheticElement.class);
            PsiClassPattern psiClass = PsiJavaPatterns.psiClass();
            PsiClassPattern pattern = ScriptScope.doAnd(psiClass, (ElementPattern)synt);
            result2.add(ClassContextFilter.fromClassPattern((ElementPattern)pattern));
        }
        return result2;
    }

    private static PsiClassPattern doAnd(PsiClassPattern psiClass, ElementPattern synt) {
        return (PsiClassPattern)psiClass.and(synt);
    }

    public final String getNamePattern() {
        return this.namePattern;
    }

    public final String getExtension() {
        return this.extension;
    }
}

