/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentMapBuilder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.OneToManyPathMapping;
import org.jetbrains.jps.incremental.storage.PathStringDescriptors;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingCursor;

public final class OneToManyPathsMapping
extends AbstractStateStorage<String, Collection<String>>
implements OneToManyPathMapping {
    private final PathRelativizerService relativizer;

    public OneToManyPathsMapping(@NotNull Path storePath, PathRelativizerService relativizer) throws IOException {
        if (storePath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(0);
        }
        super(PersistentMapBuilder.newBuilder((Path)storePath, PathStringDescriptors.createPathStringDescriptor(), (DataExternalizer)new PathCollectionExternalizer()));
        this.relativizer = relativizer;
    }

    @Override
    public void setOutputs(@NotNull String keyPath, @NotNull List<String> boundPaths) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(1);
        }
        if (boundPaths == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(2);
        }
        super.update(this.normalizePath(keyPath), this.normalizePaths(boundPaths));
    }

    void setOutput(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(3);
        }
        if (boundPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(4);
        }
        super.update(this.normalizePath(keyPath), List.of(this.normalizePath(boundPath)));
    }

    @Override
    public void appendData(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(5);
        }
        if (boundPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(6);
        }
        super.appendData(this.normalizePath(keyPath), List.of(this.normalizePath(boundPath)));
    }

    @Override
    public void appendData(@NotNull String keyPath, @NotNull Collection<String> boundPaths) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(7);
        }
        if (boundPaths == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(8);
        }
        super.appendData(this.normalizePath(keyPath), this.normalizePaths((List)boundPaths));
    }

    @Override
    @Deprecated(forRemoval=true)
    @Nullable
    public Collection<String> getState(@NotNull String keyPath) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(9);
        }
        return this.getOutputs(keyPath);
    }

    @Nullable
    public List<String> getOutputs(@NotNull String keyPath) throws IOException {
        List collection;
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(10);
        }
        if ((collection = (List)super.getState(this.relativizer.toRelative(keyPath))) == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        String[] result = new String[collection.size()];
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            result[i] = this.relativizer.toFull((String)collection.get(i));
        }
        return Arrays.asList(result);
    }

    public String @Nullable [] getOutputArray(@NotNull String keyPath) throws IOException {
        List collection;
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(11);
        }
        if ((collection = (List)super.getState(this.relativizer.toRelative(keyPath))) == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[collection.size()];
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            result[i] = this.relativizer.toFull((String)collection.get(i));
        }
        return result;
    }

    @Override
    public void remove(@NotNull String keyPath) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(12);
        }
        super.remove(this.relativizer.toRelative(keyPath));
    }

    @Override
    @NotNull
    public Iterator<String> getKeysIterator() throws IOException {
        Iterator<String> iterator = super.getKeyIterator(this.relativizer::toFull);
        if (iterator == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(13);
        }
        return iterator;
    }

    @ApiStatus.Internal
    @NotNull
    public SourceToOutputMappingCursor cursor() throws IOException {
        return new SourceToOutputMappingCursorImpl(this.getKeysIterator());
    }

    public void removeData(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        String relativeKeyPath;
        List oldList;
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(14);
        }
        if (boundPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(15);
        }
        if ((oldList = (List)super.getState(relativeKeyPath = this.relativizer.toRelative(keyPath))) == null || oldList.isEmpty()) {
            return;
        }
        String relativePath = this.relativizer.toRelative(boundPath);
        int index = oldList.indexOf(relativePath);
        if (index < 0) {
            return;
        }
        if (oldList.size() == 1) {
            super.remove(relativeKeyPath);
            return;
        }
        ArrayList<String> newState = new ArrayList<String>(oldList.size() - 1);
        for (int i = 0; i < oldList.size(); ++i) {
            if (index == i) continue;
            newState.add((String)oldList.get(i));
        }
        super.update(relativeKeyPath, newState);
    }

    private String normalizePath(@NotNull String path) {
        if (path == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(16);
        }
        return this.relativizer.toRelative(path);
    }

    @NotNull
    private @Unmodifiable List<String> normalizePaths(@NotNull List<String> outputs) {
        if (outputs == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(17);
        }
        String[] normalized = new String[outputs.size()];
        for (int i = 0; i < normalized.length; ++i) {
            normalized[i] = this.relativizer.toRelative(outputs.get(i));
        }
        List<String> list = Arrays.asList(normalized);
        if (list == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storePath";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPath";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boundPaths";
                break;
            }
            case 4: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boundPath";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/OneToManyPathsMapping";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/OneToManyPathsMapping";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysIterator";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setOutputs";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setOutput";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOutputs";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOutputArray";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 13: 
            case 18: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "normalizePath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "normalizePaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PathCollectionExternalizer
    implements DataExternalizer<Collection<String>> {
        private PathCollectionExternalizer() {
        }

        public void save(@NotNull DataOutput out, Collection<String> value) throws IOException {
            if (out == null) {
                PathCollectionExternalizer.$$$reportNull$$$0(0);
            }
            for (String str : value) {
                IOUtil.writeUTF((DataOutput)out, (String)str);
            }
        }

        public List<String> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                PathCollectionExternalizer.$$$reportNull$$$0(1);
            }
            ArrayList<String> result = new ArrayList<String>();
            DataInputStream stream = (DataInputStream)in;
            HashSet<String> guard = new HashSet<String>();
            while (stream.available() > 0) {
                String s = IOUtil.readUTF((DataInput)stream);
                if (!guard.add(s)) continue;
                result.add(s);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/storage/OneToManyPathsMapping$PathCollectionExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class SourceToOutputMappingCursorImpl
    implements SourceToOutputMappingCursor {
        private final Iterator<String> mySourceIterator;
        private String sourcePath;

        private SourceToOutputMappingCursorImpl(Iterator<String> sourceIterator) {
            this.mySourceIterator = sourceIterator;
        }

        @Override
        public boolean hasNext() {
            return this.mySourceIterator.hasNext();
        }

        @Override
        @NotNull
        public String next() {
            String string = this.sourcePath = this.mySourceIterator.next();
            if (string == null) {
                SourceToOutputMappingCursorImpl.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public String @NotNull [] getOutputPaths() {
            String[] stringArray;
            try {
                stringArray = Objects.requireNonNullElse(OneToManyPathsMapping.this.getOutputArray(this.sourcePath), ArrayUtilRt.EMPTY_STRING_ARRAY);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (stringArray == null) {
                SourceToOutputMappingCursorImpl.$$$reportNull$$$0(1);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/jps/incremental/storage/OneToManyPathsMapping$SourceToOutputMappingCursorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "next";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutputPaths";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

