/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JComboBox;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;

final class JComboBoxItemIndexPreconditions {
    @RunsInCurrentThread
    static void checkItemIndexInBounds(@Nonnull JComboBox<?> comboBox, int index) {
        if (index < 0) {
            String msg = String.format("%s should not be less than zero", JComboBoxItemIndexPreconditions.itemIndex(index));
            throw new IndexOutOfBoundsException(msg);
        }
        int itemCount = comboBox.getItemCount();
        if (itemCount == 0) {
            throw new IndexOutOfBoundsException("JComboBox is empty");
        }
        if (index >= 0 && index < itemCount) {
            return;
        }
        String msg = String.format("%s should be between [0] and [%d] (inclusive)", JComboBoxItemIndexPreconditions.itemIndex(index), itemCount - 1);
        throw new IndexOutOfBoundsException(msg);
    }

    private static String itemIndex(int index) {
        return Strings.concat("Item index (", String.valueOf(index), ")");
    }

    private JComboBoxItemIndexPreconditions() {
    }
}

