/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.plugins.groovy;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"collectGroovyFolders", "", "", "plugin", "Lorg/jetbrains/idea/maven/model/MavenPlugin;", "isForMain", "", "collectIgnoredFolders", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "intellij.maven"})
public final class GroovyPluginConfiguratorKt {
    @ApiStatus.Internal
    @NotNull
    public static final Collection<String> collectGroovyFolders(@NotNull MavenPlugin plugin, boolean isForMain) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        String goal = isForMain ? "compile" : "testCompile";
        String defaultDir = isForMain ? "src/main/groovy" : "src/test/groovy";
        List<String> dirs = MavenJDOMUtil.findChildrenValuesByPath(plugin.getGoalConfiguration(goal), "sources", "fileset.directory");
        return dirs.isEmpty() ? (Collection)CollectionsKt.listOf((Object)defaultDir) : (Collection)dirs;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Collection<String> collectIgnoredFolders(@NotNull MavenProject mavenProject, @NotNull MavenPlugin plugin) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        String stubsDir = MavenJDOMUtil.findChildValueByPath$default(plugin.getGoalConfiguration("generateStubs"), "outputDirectory", null, 4, null);
        String testStubsDir = MavenJDOMUtil.findChildValueByPath$default(plugin.getGoalConfiguration("generateTestStubs"), "outputDirectory", null, 4, null);
        String defaultStubsDir = mavenProject.getGeneratedSourcesDirectory(false) + "/groovy-stubs";
        Object[] objectArray = new String[2];
        Object object2 = stubsDir;
        if (object2 == null) {
            object2 = objectArray[0] = defaultStubsDir;
        }
        if ((object = testStubsDir) == null) {
            object = defaultStubsDir;
        }
        objectArray[1] = object;
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

