/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.workspaceModel;

import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.diagnostic.dto.JsonConverterKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.statistics.MavenImportCollector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J<\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u0002H\u000f0\u0013\u00a2\u0006\u0002\u0010\u0017J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eJ/\u0010\u001f\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\"\u00a2\u0006\u0002\u0010#J\u0015\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/WorkspaceImportStats;", "", "project", "Lcom/intellij/openapi/project/Project;", "activity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/internal/statistic/StructuredIdeActivity;)V", "configuratorsData", "", "Ljava/lang/Class;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "", "recordPhase", "T", "phase", "Lcom/intellij/internal/statistic/IdeActivityDefinition;", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "phaseActivity", "(Lcom/intellij/internal/statistic/IdeActivityDefinition;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "recordCommitPhaseStats", "", "durationInBackgroundNano", "durationInWriteActionNano", "durationOfWorkspaceUpdateCallNano", "attempts", "", "recordConfigurator", "configurator", "key", "Lkotlin/Function0;", "(Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;Lcom/intellij/internal/statistic/eventLog/events/LongEventField;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "finish", "numberOfModules", "finish$intellij_maven", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nWorkspaceImportStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceImportStats.kt\norg/jetbrains/idea/maven/importing/workspaceModel/WorkspaceImportStats\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,81:1\n216#2,2:82\n*S KotlinDebug\n*F\n+ 1 WorkspaceImportStats.kt\norg/jetbrains/idea/maven/importing/workspaceModel/WorkspaceImportStats\n*L\n67#1:82,2\n*E\n"})
public final class WorkspaceImportStats {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final StructuredIdeActivity activity;
    @NotNull
    private final Map<Class<MavenWorkspaceConfigurator>, Map<LongEventField, Long>> configuratorsData;

    private WorkspaceImportStats(Project project, StructuredIdeActivity activity) {
        this.project = project;
        this.activity = activity;
        this.configuratorsData = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T recordPhase(@NotNull IdeActivityDefinition phase, @NotNull Function1<? super StructuredIdeActivity, ? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        StructuredIdeActivity phaseActivity = IdeActivityDefinition.startedWithParent$default((IdeActivityDefinition)phase, (Project)this.project, (StructuredIdeActivity)this.activity, null, (int)4, null);
        try {
            Object object = block.invoke((Object)phaseActivity);
            return (T)object;
        }
        finally {
            StructuredIdeActivity.finished$default((StructuredIdeActivity)phaseActivity, null, (int)1, null);
        }
    }

    public final void recordCommitPhaseStats(long durationInBackgroundNano, long durationInWriteActionNano, long durationOfWorkspaceUpdateCallNano, int attempts) {
        Object[] objectArray = new EventPair[]{MavenImportCollector.ACTIVITY_ID.with((Object)this.activity), MavenImportCollector.DURATION_BACKGROUND_MS.with((Object)JsonConverterKt.toMillis((long)durationInBackgroundNano)), MavenImportCollector.DURATION_WRITE_ACTION_MS.with((Object)JsonConverterKt.toMillis((long)durationInWriteActionNano)), MavenImportCollector.DURATION_OF_WORKSPACE_UPDATE_CALL_MS.with((Object)JsonConverterKt.toMillis((long)durationOfWorkspaceUpdateCallNano)), MavenImportCollector.ATTEMPTS.with((Object)attempts)};
        MavenImportCollector.WORKSPACE_COMMIT_STATS.log(CollectionsKt.listOf((Object[])objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T recordConfigurator(@NotNull MavenWorkspaceConfigurator configurator, @NotNull LongEventField key, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)configurator, (String)"configurator");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        long start = System.nanoTime();
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            long durationNano = System.nanoTime() - start;
            this.configuratorsData.computeIfAbsent(configurator.getClass(), arg_0 -> WorkspaceImportStats.recordConfigurator$lambda$1(WorkspaceImportStats::recordConfigurator$lambda$0, arg_0)).compute(key, (arg_0, arg_1) -> WorkspaceImportStats.recordConfigurator$lambda$3((arg_0, arg_1) -> WorkspaceImportStats.recordConfigurator$lambda$2(durationNano, arg_0, arg_1), arg_0, arg_1));
        }
    }

    public final void finish$intellij_maven(int numberOfModules) {
        for (Map.Entry<Class<MavenWorkspaceConfigurator>, Map<LongEventField, Long>> entry : this.configuratorsData.entrySet()) {
            Class<MavenWorkspaceConfigurator> clazz = entry.getKey();
            Map<LongEventField, Long> timings = entry.getValue();
            List logPairs = new ArrayList();
            long totalNano = 0L;
            Map<LongEventField, Long> $this$forEach$iv = timings;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<LongEventField, Long>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<LongEventField, Long> element$iv;
                Map.Entry<LongEventField, Long> entry2 = element$iv = iterator.next();
                boolean bl = false;
                LongEventField key = entry2.getKey();
                long nano = ((Number)entry2.getValue()).longValue();
                logPairs.add(key.with((Object)JsonConverterKt.toMillis((long)nano)));
                totalNano += nano;
            }
            logPairs.add(MavenImportCollector.TOTAL_DURATION_MS.with((Object)JsonConverterKt.toMillis((long)totalNano)));
            logPairs.add(MavenImportCollector.CONFIGURATOR_CLASS.with(clazz));
            logPairs.add(MavenImportCollector.NUMBER_OF_MODULES.with((Object)numberOfModules));
            logPairs.add(MavenImportCollector.ACTIVITY_ID.with((Object)this.activity));
            MavenImportCollector.CONFIGURATOR_RUN.log(this.project, logPairs);
        }
        this.activity.finished(() -> WorkspaceImportStats.finish$lambda$5(numberOfModules));
    }

    private static final Map recordConfigurator$lambda$0(Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashMap();
    }

    private static final Map recordConfigurator$lambda$1(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final Long recordConfigurator$lambda$2(long $durationNano, LongEventField longEventField, Long value) {
        Intrinsics.checkNotNullParameter((Object)longEventField, (String)"<unused var>");
        Long l = value;
        return (l != null ? l : 0L) + $durationNano;
    }

    private static final Long recordConfigurator$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return (Long)$tmp0.invoke(p0, p1);
    }

    private static final List finish$lambda$5(int $numberOfModules) {
        return CollectionsKt.listOf((Object)MavenImportCollector.NUMBER_OF_MODULES.with((Object)$numberOfModules));
    }

    public /* synthetic */ WorkspaceImportStats(Project project, StructuredIdeActivity activity, DefaultConstructorMarker $constructor_marker) {
        this(project, activity);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/WorkspaceImportStats$Companion;", "", "<init>", "()V", "start", "Lorg/jetbrains/idea/maven/importing/workspaceModel/WorkspaceImportStats;", "project", "Lcom/intellij/openapi/project/Project;", "startFoldersUpdate", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WorkspaceImportStats start(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new WorkspaceImportStats(project, IdeActivityDefinition.started$default((IdeActivityDefinition)MavenImportCollector.WORKSPACE_IMPORT, (Project)project, null, (int)2, null), null);
        }

        @NotNull
        public final WorkspaceImportStats startFoldersUpdate(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new WorkspaceImportStats(project, IdeActivityDefinition.started$default((IdeActivityDefinition)MavenImportCollector.WORKSPACE_FOLDERS_UPDATE, (Project)project, null, (int)2, null), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

