/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.HeaderUI;
import org.jdesktop.swingx.plaf.PainterUIResource;
import org.jdesktop.swingx.plaf.UIManagerExt;

public class BasicHeaderUI
extends HeaderUI {
    private static final Logger LOG = Logger.getLogger(BasicHeaderUI.class.getName());
    protected JLabel titleLabel;
    protected DescriptionPane descriptionPane;
    protected JLabel imagePanel;
    private PropertyChangeListener propListener;
    private HierarchyBoundsListener boundsListener;
    private Color gradientLightColor;
    private Color gradientDarkColor;

    public static ComponentUI createUI(JComponent c) {
        return new BasicHeaderUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        assert (c instanceof JXHeader);
        JXHeader header = (JXHeader)c;
        this.installDefaults(header);
        this.installComponents(header);
        this.installListeners(header);
    }

    public void uninstallUI(JComponent c) {
        assert (c instanceof JXHeader);
        JXHeader header = (JXHeader)c;
        this.uninstallListeners(header);
        this.uninstallComponents(header);
        this.uninstallDefaults(header);
    }

    protected void installDefaults(JXHeader h) {
        this.gradientLightColor = UIManagerExt.getColor("JXHeader.startBackground");
        if (this.gradientLightColor == null) {
            this.gradientLightColor = Color.WHITE;
        }
        this.gradientDarkColor = UIManagerExt.getColor("JXHeader.background");
        if (this.gradientDarkColor == null) {
            this.gradientDarkColor = UIManagerExt.getColor("control");
        }
        if (this.isUIInstallable(h.getBackgroundPainter())) {
            h.setBackgroundPainter(this.createBackgroundPainter());
        }
        if (this.isUIInstallable(h.getTitleFont())) {
            Font titleFont = UIManager.getFont("JXHeader.titleFont");
            h.setTitleFont(titleFont != null ? titleFont : UIManager.getFont("Label.font"));
        }
        if (this.isUIInstallable(h.getTitleForeground())) {
            Color titleForeground = UIManagerExt.getColor("JXHeader.titleForeground");
            h.setTitleForeground(titleForeground != null ? titleForeground : UIManagerExt.getColor("Label.foreground"));
        }
        if (this.isUIInstallable(h.getDescriptionFont())) {
            Font descFont = UIManager.getFont("JXHeader.descriptionFont");
            h.setDescriptionFont(descFont != null ? descFont : UIManager.getFont("Label.font"));
        }
        if (this.isUIInstallable(h.getDescriptionForeground())) {
            Color descForeground = UIManagerExt.getColor("JXHeader.descriptionForeground");
            h.setDescriptionForeground(descForeground != null ? descForeground : UIManagerExt.getColor("Label.foreground"));
        }
        if (this.isUIInstallable(h.getIcon())) {
            h.setIcon(UIManager.getIcon("Header.defaultIcon"));
        }
    }

    protected void uninstallDefaults(JXHeader h) {
    }

    protected void installComponents(JXHeader h) {
        this.titleLabel = new JLabel();
        this.descriptionPane = new DescriptionPane();
        this.imagePanel = new JLabel();
        this.installComponentDefaults(h);
        h.setLayout(new GridBagLayout());
        this.resetLayout(h);
    }

    protected void uninstallComponents(JXHeader h) {
        this.uninstallComponentDefaults(h);
        h.remove(this.titleLabel);
        h.remove(this.descriptionPane);
        h.remove(this.imagePanel);
        this.titleLabel = null;
        this.descriptionPane = null;
        this.imagePanel = null;
    }

    protected void installComponentDefaults(JXHeader h) {
        this.titleLabel.setFont(this.getAsNotUIResource(h.getTitleFont()));
        this.titleLabel.setForeground(this.getAsNotUIResource(h.getTitleForeground()));
        this.titleLabel.setText(h.getTitle());
        this.descriptionPane.setFont(this.getAsNotUIResource(h.getDescriptionFont()));
        this.descriptionPane.setForeground(this.getAsNotUIResource(h.getDescriptionForeground()));
        this.descriptionPane.setOpaque(false);
        this.descriptionPane.setText(h.getDescription());
        this.descriptionPane.setLineWrap(true);
        this.imagePanel.setIcon(h.getIcon());
    }

    private Font getAsNotUIResource(Font font) {
        if (!(font instanceof UIResource)) {
            return font;
        }
        return font.deriveFont(font.getAttributes());
    }

    private Color getAsNotUIResource(Color color) {
        if (!(color instanceof UIResource)) {
            return color;
        }
        float[] rgb = color.getRGBComponents(null);
        return new Color(rgb[0], rgb[1], rgb[2], rgb[3]);
    }

    private boolean isUIInstallable(Object property) {
        return property == null || property instanceof UIResource;
    }

    protected void uninstallComponentDefaults(JXHeader h) {
    }

    protected void installListeners(final JXHeader header) {
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                BasicHeaderUI.this.onPropertyChange(header, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
        this.boundsListener = new HierarchyBoundsAdapter(){

            public void ancestorResized(HierarchyEvent e) {
                if (header == e.getComponent()) {
                    View v = (View)BasicHeaderUI.this.descriptionPane.getClientProperty("html");
                    if (v == null) {
                        DescriptionPane descriptionPane = BasicHeaderUI.this.descriptionPane;
                        BasicHeaderUI.this.descriptionPane.getMultiLineSupport();
                        descriptionPane.putClientProperty("html", JXLabel.MultiLineSupport.createView(BasicHeaderUI.this.descriptionPane));
                        v = (View)BasicHeaderUI.this.descriptionPane.getClientProperty("html");
                    }
                    if (v != null) {
                        Container tla = header.getTopLevelAncestor();
                        if (tla == null) {
                            tla = header.getParent();
                            while (tla.getParent() != null) {
                                tla = tla.getParent();
                            }
                        }
                        int h = Math.max(BasicHeaderUI.this.descriptionPane.getHeight(), tla.getHeight());
                        int w = Math.min(tla.getWidth(), header.getParent().getWidth());
                        v.setSize(w -= 35 + header.getInsets().left + header.getInsets().right + BasicHeaderUI.this.descriptionPane.getInsets().left + BasicHeaderUI.this.descriptionPane.getInsets().right + BasicHeaderUI.this.imagePanel.getInsets().left + BasicHeaderUI.this.imagePanel.getInsets().right + BasicHeaderUI.this.imagePanel.getWidth() + BasicHeaderUI.this.descriptionPane.getBounds().x, h);
                        BasicHeaderUI.this.descriptionPane.setSize(w, (int)Math.ceil(v.getPreferredSpan(1)));
                    }
                }
            }
        };
        header.addPropertyChangeListener(this.propListener);
        header.addHierarchyBoundsListener(this.boundsListener);
    }

    protected void uninstallListeners(JXHeader h) {
        h.removePropertyChangeListener(this.propListener);
        h.removeHierarchyBoundsListener(this.boundsListener);
    }

    protected void onPropertyChange(JXHeader h, String propertyName, Object oldValue, Object newValue) {
        if ("title".equals(propertyName)) {
            this.titleLabel.setText(h.getTitle());
        } else if ("description".equals(propertyName)) {
            this.descriptionPane.setText(h.getDescription());
        } else if ("icon".equals(propertyName)) {
            this.imagePanel.setIcon(h.getIcon());
        } else if ("enabled".equals(propertyName)) {
            boolean enabled = h.isEnabled();
            this.titleLabel.setEnabled(enabled);
            this.descriptionPane.setEnabled(enabled);
            this.imagePanel.setEnabled(enabled);
        } else if ("titleFont".equals(propertyName)) {
            this.titleLabel.setFont((Font)newValue);
        } else if ("descriptionFont".equals(propertyName)) {
            this.descriptionPane.setFont((Font)newValue);
        } else if ("titleForeground".equals(propertyName)) {
            this.titleLabel.setForeground((Color)newValue);
        } else if ("descriptionForeground".equals(propertyName)) {
            this.descriptionPane.setForeground((Color)newValue);
        } else if ("iconPosition".equals(propertyName)) {
            this.resetLayout(h);
        }
    }

    private void resetLayout(JXHeader h) {
        h.remove(this.titleLabel);
        h.remove(this.descriptionPane);
        h.remove(this.imagePanel);
        if (h.getIconPosition() == null || h.getIconPosition() == JXHeader.IconPosition.RIGHT) {
            h.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 0, 11), 0, 0));
            h.add((Component)this.descriptionPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 24, 12, 11), 0, 0));
            h.add((Component)this.imagePanel, new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 24, 0, new Insets(12, 0, 11, 11), 0, 0));
        } else {
            h.add((Component)this.titleLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 0, 11), 0, 0));
            h.add((Component)this.descriptionPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 24, 12, 11), 0, 0));
            h.add((Component)this.imagePanel, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 24, 0, new Insets(12, 11, 0, 11), 0, 0));
        }
    }

    protected Painter createBackgroundPainter() {
        MattePainter p = new MattePainter(new GradientPaint(0.0f, 0.0f, this.gradientLightColor, 1.0f, 0.0f, this.gradientDarkColor));
        p.setPaintStretched(true);
        return new PainterUIResource(p);
    }

    protected class DescriptionPane
    extends JXLabel {
        protected DescriptionPane() {
        }

        public void paint(Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            super.paint(g);
        }

        public JXLabel.MultiLineSupport getMultiLineSupport() {
            return super.getMultiLineSupport();
        }
    }
}

