/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.Layer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLayer
implements Layer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLayer.class);
    private Layer upperLayer = LogOnlyLayer.getInstance();
    private Layer lowerLayer = LogOnlyLayer.getInstance();
    protected ScheduledExecutorService executor;
    protected ScheduledExecutorService secondaryExecutor;

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        this.lowerLayer.sendRequest(exchange, request);
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        this.lowerLayer.sendResponse(exchange, response);
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        this.lowerLayer.sendEmptyMessage(exchange, message);
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        this.upperLayer.receiveRequest(exchange, request);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        this.upperLayer.receiveResponse(exchange, response);
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        this.upperLayer.receiveEmptyMessage(exchange, message);
    }

    @Override
    public final void setLowerLayer(Layer layer) {
        if (this.lowerLayer != layer) {
            if (this.lowerLayer != null) {
                this.lowerLayer.setUpperLayer(null);
            }
            this.lowerLayer = layer;
            this.lowerLayer.setUpperLayer(this);
        }
    }

    final Layer lower() {
        return this.lowerLayer;
    }

    @Override
    public final void setUpperLayer(Layer layer) {
        if (this.upperLayer != layer) {
            if (this.upperLayer != null) {
                this.upperLayer.setLowerLayer(null);
            }
            this.upperLayer = layer;
            this.upperLayer.setLowerLayer(this);
        }
    }

    final Layer upper() {
        return this.upperLayer;
    }

    @Override
    public final void setExecutors(ScheduledExecutorService mainExecutor, ScheduledExecutorService secondaryExecutor) {
        this.executor = mainExecutor;
        this.secondaryExecutor = secondaryExecutor;
    }

    public final void reject(Exchange exchange, Message message) {
        if (message.getType() == CoAP.Type.ACK || message.getType() == CoAP.Type.RST) {
            throw new IllegalArgumentException("Can only reject CON/NON messages");
        }
        this.lower().sendEmptyMessage(exchange, EmptyMessage.newRST(message));
    }

    @Override
    public void start() {
    }

    @Override
    public void destroy() {
    }

    public static final class LogOnlyLayer
    implements Layer {
        private static final LogOnlyLayer INSTANCE = new LogOnlyLayer();

        public static LogOnlyLayer getInstance() {
            return INSTANCE;
        }

        @Override
        public void sendRequest(Exchange exchange, Request request) {
            LOGGER.error("No lower layer set for sending request [{}]", (Object)request);
        }

        @Override
        public void sendResponse(Exchange exchange, Response response) {
            LOGGER.error("No lower layer set for sending response [{}]", (Object)response);
        }

        @Override
        public void sendEmptyMessage(Exchange exchange, EmptyMessage emptyMessage) {
            LOGGER.error("No lower layer set for sending empty message [{}]", (Object)emptyMessage);
        }

        @Override
        public void receiveRequest(Exchange exchange, Request request) {
            LOGGER.error("No upper layer set for receiving request [{}]", (Object)request);
        }

        @Override
        public void receiveResponse(Exchange exchange, Response response) {
            LOGGER.error("No lower layer set for receiving response [{}]", (Object)response);
        }

        @Override
        public void receiveEmptyMessage(Exchange exchange, EmptyMessage emptyMessage) {
            LOGGER.error("No lower layer set for receiving empty message [{}]", (Object)emptyMessage);
        }

        @Override
        public void setLowerLayer(Layer layer) {
        }

        @Override
        public void setUpperLayer(Layer layer) {
        }

        @Override
        public void setExecutors(ScheduledExecutorService mainExecutor, ScheduledExecutorService secondaryExecutor) {
        }

        @Override
        public void start() {
        }

        @Override
        public void destroy() {
        }
    }
}

