/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.http.link;

import com.apicatalog.jsonld.http.link.LinkAttributes;
import com.apicatalog.jsonld.http.link.LinkHeaderParser;
import com.apicatalog.jsonld.http.media.MediaType;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public final class Link {
    private final URI contextUri;
    private final URI targetUri;
    private final Set<String> relations;
    private final MediaType type;
    private final LinkAttributes attributes;

    protected Link(URI contextUri, URI targetUri, Set<String> relations, MediaType type, LinkAttributes attributes) {
        this.contextUri = contextUri;
        this.targetUri = targetUri;
        this.relations = relations;
        this.type = type;
        this.attributes = attributes;
    }

    public static final Collection<Link> of(String linkHeader) {
        return Link.of(linkHeader, null);
    }

    public static final Collection<Link> of(String linkHeader, URI baseUri) {
        if (linkHeader == null) {
            throw new IllegalArgumentException("Link header value cannot be null.");
        }
        return new LinkHeaderParser(baseUri).parse(linkHeader);
    }

    public URI target() {
        return this.targetUri;
    }

    public Optional<URI> context() {
        return Optional.ofNullable(this.contextUri);
    }

    public Set<String> relations() {
        return Collections.unmodifiableSet(this.relations);
    }

    public Optional<MediaType> type() {
        return Optional.ofNullable(this.type);
    }

    public LinkAttributes attributes() {
        return this.attributes;
    }
}

