/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpTOCNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicHelpUI;
import javax.help.plaf.basic.BasicTOCCellRenderer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicTOCNavigatorUI
extends HelpNavigatorUI
implements HelpModelListener,
TreeSelectionListener,
PropertyChangeListener,
Serializable {
    protected JHelpTOCNavigator toc;
    protected JScrollPane sp;
    protected DefaultMutableTreeNode topNode;
    protected JTree tree;
    protected static final boolean debug = false;
    static /* synthetic */ Class class$javax$help$plaf$basic$BasicTOCNavigatorUI;

    public BasicTOCNavigatorUI(JHelpTOCNavigator jHelpTOCNavigator) {
        BasicTOCNavigatorUI.debug(String.valueOf(String.valueOf(this)) + " " + "CreateUI - sort of");
        this.setIcon(BasicHelpUI.getIcon(class$javax$help$plaf$basic$BasicTOCNavigatorUI != null ? class$javax$help$plaf$basic$BasicTOCNavigatorUI : (class$javax$help$plaf$basic$BasicTOCNavigatorUI = BasicTOCNavigatorUI.class$("javax.help.plaf.basic.BasicTOCNavigatorUI")), "images/toc.gif"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTOCNavigatorUI((JHelpTOCNavigator)jComponent);
    }

    protected static void debug(String string) {
    }

    private DefaultMutableTreeNode findID(DefaultMutableTreeNode defaultMutableTreeNode, Map.ID iD) {
        BasicTOCNavigatorUI.debug("findID: (" + iD + ")");
        BasicTOCNavigatorUI.debug("  node: " + defaultMutableTreeNode);
        if (iD == null) {
            return null;
        }
        TOCItem tOCItem = (TOCItem)defaultMutableTreeNode.getUserObject();
        if (tOCItem != null) {
            Map.ID iD2 = tOCItem.getID();
            BasicTOCNavigatorUI.debug("  testID: " + iD2);
            if (iD2 != null && iD2.equals(iD)) {
                return defaultMutableTreeNode;
            }
        }
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.findID(defaultMutableTreeNode2, iD);
            if (defaultMutableTreeNode3 != null) {
                return defaultMutableTreeNode3;
            }
            ++n2;
        }
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(100, 100);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(200, 100);
    }

    public void idChanged(HelpModelEvent helpModelEvent) {
        Map.ID iD;
        Serializable serializable;
        TOCItem tOCItem;
        Object object;
        Map.ID iD2 = helpModelEvent.getID();
        URL uRL = helpModelEvent.getURL();
        HelpModel helpModel = this.toc.getModel();
        BasicTOCNavigatorUI.debug("idChanged(" + helpModelEvent + ")");
        if (helpModelEvent.getSource() != helpModel) {
            System.err.println("Internal inconsistency!");
            System.err.println("  " + helpModelEvent.getSource() + " != " + helpModel);
            throw new Error("Internal error");
        }
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode && (tOCItem = (TOCItem)(serializable = (DefaultMutableTreeNode)object).getUserObject()) != null && (iD = tOCItem.getID()) != null && iD.equals(iD2)) {
            return;
        }
        object = this.findID(this.topNode, iD2);
        if (object == null) {
            this.tree.clearSelection();
            return;
        }
        serializable = new TreePath(((DefaultMutableTreeNode)object).getPath());
        this.tree.expandPath((TreePath)serializable);
        this.tree.setSelectionPath((TreePath)serializable);
        this.tree.scrollPathToVisible((TreePath)serializable);
    }

    public void installUI(JComponent jComponent) {
        BasicTOCNavigatorUI.debug(String.valueOf(String.valueOf(this)) + " " + "installUI");
        this.toc = (JHelpTOCNavigator)jComponent;
        HelpModel helpModel = this.toc.getModel();
        this.toc.setLayout(new BorderLayout());
        this.toc.addPropertyChangeListener(this);
        if (helpModel != null) {
            helpModel.addHelpModelListener(this);
        }
        this.topNode = new DefaultMutableTreeNode();
        this.tree = new JTree(this.topNode);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.toc.add("Center", this.sp);
        this.reloadData();
        BasicTOCNavigatorUI.debug("topTree is: " + this.topNode);
    }

    public void merge(NavigatorView navigatorView) {
        BasicTOCNavigatorUI.debug("merging " + navigatorView);
        TOCView tOCView = (TOCView)navigatorView;
        DefaultMutableTreeNode defaultMutableTreeNode = tOCView.getDataAsTree();
        while (defaultMutableTreeNode.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild());
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
        this.setCellRenderer(tOCView, this.tree);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        BasicTOCNavigatorUI.debug(String.valueOf(String.valueOf(this)) + " " + "propertyChange: " + propertyChangeEvent.getSource() + " " + propertyChangeEvent.getPropertyName());
        if (propertyChangeEvent.getSource() == this.toc) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("helpModel")) {
                this.reloadData();
            } else if (string.equals("font")) {
                BasicTOCNavigatorUI.debug("Font change");
                Font font = (Font)propertyChangeEvent.getNewValue();
                this.tree.setFont(font);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            }
        }
    }

    private void reloadData() {
        BasicTOCNavigatorUI.debug("reloadData");
        if (this.toc.getModel() == null) {
            return;
        }
        this.topNode.removeAllChildren();
        TOCView tOCView = (TOCView)this.toc.getNavigatorView();
        if (tOCView == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = tOCView.getDataAsTree();
        while (defaultMutableTreeNode.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild());
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
        this.setCellRenderer(tOCView, this.tree);
    }

    public void remove(NavigatorView navigatorView) {
        BasicTOCNavigatorUI.debug("removing " + navigatorView);
        this.remove(this.topNode, navigatorView.getHelpSet());
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
        this.setCellRenderer(navigatorView, this.tree);
    }

    private void remove(DefaultMutableTreeNode defaultMutableTreeNode, HelpSet helpSet) {
        BasicTOCNavigatorUI.debug("remove(" + defaultMutableTreeNode + ", " + helpSet + ")");
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            BasicTOCNavigatorUI.debug("  considering " + defaultMutableTreeNode2);
            TOCItem tOCItem = (TOCItem)defaultMutableTreeNode2.getUserObject();
            HelpSet helpSet2 = tOCItem.getHelpSet();
            if (helpSet2 != null && helpSet.contains(helpSet2)) {
                BasicTOCNavigatorUI.debug("  tagging for removal: " + defaultMutableTreeNode2);
                vector.addElement(defaultMutableTreeNode2);
                continue;
            }
            this.remove(defaultMutableTreeNode2, helpSet);
        }
        int n = 0;
        while (n < vector.size()) {
            BasicTOCNavigatorUI.debug("  removing " + vector.elementAt(n));
            defaultMutableTreeNode.remove((DefaultMutableTreeNode)vector.elementAt(n));
            ++n;
        }
    }

    protected void setCellRenderer(NavigatorView navigatorView, JTree jTree) {
        Map map = navigatorView.getHelpSet().getCombinedMap();
        jTree.setCellRenderer(new BasicTOCCellRenderer(map));
    }

    private void setVisibility(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            this.tree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
            ++n2;
        }
    }

    public void uninstallUI(JComponent jComponent) {
        BasicTOCNavigatorUI.debug(String.valueOf(String.valueOf(this)) + " " + "unistallUI");
        HelpModel helpModel = this.toc.getModel();
        this.toc.removePropertyChangeListener(this);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.removeTreeSelectionListener(this);
        this.toc.setLayout(null);
        this.toc.removeAll();
        if (helpModel != null) {
            helpModel.removeHelpModelListener(this);
        }
        this.toc = null;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        BasicTOCNavigatorUI.debug("ValueChanged: " + treeSelectionEvent);
        BasicTOCNavigatorUI.debug("  model: " + this.toc.getModel());
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        TOCItem tOCItem = (TOCItem)defaultMutableTreeNode.getUserObject();
        if (tOCItem != null && tOCItem.getID() != null) {
            try {
                this.toc.getModel().setCurrentID(tOCItem.getID());
            }
            catch (InvalidHelpSetContextException invalidHelpSetContextException) {
                BasicTOCNavigatorUI.debug(String.valueOf(String.valueOf(this)) + " " + "BadID");
                return;
            }
        }
    }
}

