/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.codecache.disk.adapters;

import jadx.api.metadata.annotations.VarNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.MethodNode;
import jadx.gui.utils.codecache.disk.adapters.ArgTypeAdapter;
import jadx.gui.utils.codecache.disk.adapters.DataAdapter;
import jadx.gui.utils.codecache.disk.adapters.DataAdapterHelper;
import jadx.gui.utils.codecache.disk.adapters.MethodNodeAdapter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class VarNodeAdapter
implements DataAdapter<VarNode> {
    private final MethodNodeAdapter mthAdapter;

    public VarNodeAdapter(MethodNodeAdapter mthAdapter) {
        this.mthAdapter = mthAdapter;
    }

    @Override
    public void write(DataOutput out, VarNode value) throws IOException {
        this.mthAdapter.write(out, value.getMth());
        DataAdapterHelper.writeUVInt(out, value.getReg());
        DataAdapterHelper.writeUVInt(out, value.getSsa());
        ArgTypeAdapter.INSTANCE.write(out, value.getType());
        DataAdapterHelper.writeNullableUTF(out, value.getName());
    }

    @Override
    public VarNode read(DataInput in) throws IOException {
        MethodNode mth = this.mthAdapter.read(in);
        int reg = DataAdapterHelper.readUVInt(in);
        int ssa = DataAdapterHelper.readUVInt(in);
        ArgType type = ArgTypeAdapter.INSTANCE.read(in);
        String name = DataAdapterHelper.readNullableUTF(in);
        return new VarNode(mth, reg, ssa, type, name);
    }
}

