/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.OptionsDefinitions;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.StreamEater;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.dialogs.AccessWarningPaneComplexReturn;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class XDesktopEntry {
    public static final String JAVA_ICON_NAME = "javaws";
    private JNLPFile file = null;
    private int iconSize = -1;
    private String iconLocation = null;
    private static final int[] VALID_ICON_SIZES = new int[]{16, 22, 32, 48, 64, 128};
    public static final String[] BROWSERS = new String[]{"firefox", "midori", "epiphany", "opera", "chromium", "chrome", "konqueror"};
    public static final String FAVICON = "favicon.ico";
    static final String XDG_DESKTOP_DIR = "XDG_DESKTOP_DIR";
    private static final String MIC = "MAGIC_QUOTIN_ITW_CONSTANT_FOR_DUMMIES";

    public XDesktopEntry(JNLPFile file) {
        this.file = file;
        this.iconSize = VALID_ICON_SIZES[2];
    }

    public Reader getContentsAsReader(boolean menu, AccessWarningPaneComplexReturn.ShortcutResult info, boolean isSigned) {
        File generatedJnlp = null;
        if (this.file instanceof PluginBridge && (info.getShortcutType() == AccessWarningPaneComplexReturn.ShortcutResult.Shortcut.GENERATED_JNLP || info.getShortcutType() == AccessWarningPaneComplexReturn.ShortcutResult.Shortcut.JNLP_HREF)) {
            try {
                String content = ((PluginBridge)this.file).toJnlp(isSigned, info.getShortcutType() == AccessWarningPaneComplexReturn.ShortcutResult.Shortcut.JNLP_HREF, info.isFixHref());
                generatedJnlp = this.getGeneratedJnlpFileName();
                FileUtils.saveFile(content, generatedJnlp);
            }
            catch (Exception ex) {
                OutputController.getLogger().log(ex);
            }
        }
        String fileContents = "[Desktop Entry]\n";
        fileContents = fileContents + "Version=1.0\n";
        fileContents = fileContents + "Name=" + this.getDesktopIconName() + "\n";
        fileContents = fileContents + "GenericName=Java Web Start Application\n";
        fileContents = fileContents + "Comment=" + XDesktopEntry.sanitize(this.file.getInformation().getDescription()) + "\n";
        if (menu) {
            String menuString = "Categories=Network;";
            if (this.file.getInformation().getShortcut() != null && this.file.getInformation().getShortcut().getMenu() != null && this.file.getInformation().getShortcut().getMenu().getSubMenu() != null && !this.file.getInformation().getShortcut().getMenu().getSubMenu().trim().isEmpty()) {
                menuString = menuString + this.file.getInformation().getShortcut().getMenu().getSubMenu().trim() + ";";
            }
            menuString = menuString + "Java;Javaws;";
            fileContents = fileContents + menuString + "\n";
        }
        fileContents = fileContents + "Type=Application\n";
        fileContents = this.iconLocation != null ? fileContents + "Icon=" + this.iconLocation + "\n" : fileContents + "Icon=javaws\n";
        if (this.file.getInformation().getVendor() != null) {
            fileContents = fileContents + "X-Vendor=" + XDesktopEntry.sanitize(this.file.getInformation().getVendor()) + "\n";
        }
        if (JNLPRuntime.isWebstartApplication()) {
            String htmlSwitch = "";
            if (JNLPRuntime.isHtml()) {
                htmlSwitch = " " + OptionsDefinitions.OPTIONS.HTML.option;
            }
            fileContents = fileContents + "Exec=" + this.getJavaWsBin() + htmlSwitch + " \"" + this.file.getSourceLocation() + "\"\n";
            OutputController.getLogger().log("Using " + this.getJavaWsBin() + htmlSwitch + " as binary for " + this.file.getSourceLocation());
        } else if (info.getShortcutType() == AccessWarningPaneComplexReturn.ShortcutResult.Shortcut.BROWSER) {
            String browser = info.getBrowser();
            if (browser == null) {
                browser = XDesktopEntry.getBrowserBin();
            }
            fileContents = fileContents + "Exec=" + browser + " \"" + this.file.getSourceLocation() + "\"\n";
            OutputController.getLogger().log("Using " + browser + " as binary for " + this.file.getSourceLocation());
        } else if ((info.getShortcutType() == AccessWarningPaneComplexReturn.ShortcutResult.Shortcut.GENERATED_JNLP || info.getShortcutType() == AccessWarningPaneComplexReturn.ShortcutResult.Shortcut.JNLP_HREF) && generatedJnlp != null) {
            fileContents = fileContents + "Exec=" + this.getJavaWsBin() + " \"" + generatedJnlp.getAbsolutePath() + "\"\n";
            OutputController.getLogger().log("Using " + this.getJavaWsBin() + " (generated) as binary for " + this.file.getSourceLocation() + " to " + generatedJnlp.getAbsolutePath());
        } else if (info.getShortcutType() == AccessWarningPaneComplexReturn.ShortcutResult.Shortcut.JAVAWS_HTML) {
            fileContents = fileContents + "Exec=" + this.getJavaWsBin() + " -html  \"" + this.file.getSourceLocation() + "\"\n";
            OutputController.getLogger().log("Using " + this.getJavaWsBin() + " -html as binary for " + this.file.getSourceLocation());
        } else {
            fileContents = fileContents + "Exec=" + XDesktopEntry.getBrowserBin() + " \"" + this.file.getSourceLocation() + "\"\n";
            OutputController.getLogger().log("Using " + XDesktopEntry.getBrowserBin() + " as binary for " + this.file.getSourceLocation());
        }
        return new StringReader(fileContents);
    }

    public static String getBrowserBin() {
        String pathResult = XDesktopEntry.findOnPath(BROWSERS);
        if (pathResult != null) {
            return pathResult;
        }
        return "browser_not_found";
    }

    private String getJavaWsBin() {
        String exec = System.getProperty("icedtea-web.bin.location");
        String pathResult = XDesktopEntry.findOnPath(new String[]{JAVA_ICON_NAME, System.getProperty("icedtea-web.bin.name")});
        if (pathResult != null) {
            return pathResult;
        }
        if (exec != null) {
            return exec;
        }
        return JAVA_ICON_NAME;
    }

    private static String findOnPath(String[] bins) {
        String exec = null;
        String path = System.getenv().get("PATH");
        if (path == null || path.trim().isEmpty()) {
            path = System.getenv().get("path");
        }
        if (path == null || path.trim().isEmpty()) {
            path = System.getenv().get("Path");
        }
        if (path != null && !path.trim().isEmpty()) {
            String[] paths = path.split(File.pathSeparator);
            block0: for (String bin : bins) {
                if (bin == null) continue;
                for (String p : paths) {
                    if (!new File(p, bin).exists()) continue;
                    exec = bin;
                    break block0;
                }
            }
        }
        return exec;
    }

    private static String sanitize(String input) {
        if (input == null) {
            return "";
        }
        input = FileUtils.sanitizeFileName(input, '-');
        return input.split("\n")[0];
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public File getShortcutTmpFile() {
        String userTmp = PathsAndFiles.TMP_DIR.getFullPath();
        File shortcutFile = new File(userTmp + File.separator + this.getDesktopIconFileName());
        return shortcutFile;
    }

    public void setIconSize(int size) {
        this.iconSize = size;
    }

    public void createDesktopShortcuts(AccessWarningPaneComplexReturn.ShortcutResult menu, AccessWarningPaneComplexReturn.ShortcutResult desktop, boolean isSigned) {
        boolean isDesktop = false;
        if (desktop != null && desktop.isCreate()) {
            isDesktop = true;
        }
        boolean isMenu = false;
        if (menu != null && menu.isCreate()) {
            isMenu = true;
        }
        try {
            if (isMenu || isDesktop) {
                try {
                    this.cacheIcon();
                }
                catch (NonFileProtocolException ex) {
                    OutputController.getLogger().log(ex);
                }
            }
            if (isDesktop) {
                this.installDesktopLauncher(desktop, isSigned);
            }
            if (isMenu) {
                this.installMenuLauncher(menu, isSigned);
            }
        }
        catch (Exception e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
    }

    private void installMenuLauncher(AccessWarningPaneComplexReturn.ShortcutResult info, boolean isSigned) {
        try {
            File f = this.getLinuxMenuIconFile();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), Charset.forName("UTF-8"));
                 Reader reader = this.getContentsAsReader(true, info, isSigned);){
                char[] buffer = new char[1024];
                int ret = 0;
                while (-1 != (ret = reader.read(buffer))) {
                    writer.write(buffer, 0, ret);
                }
            }
            OutputController.getLogger().log("Menu item created: " + f.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
    }

    private void installDesktopLauncher(AccessWarningPaneComplexReturn.ShortcutResult info, boolean isSigned) {
        File shortcutFile = this.getShortcutTmpFile();
        try {
            if (!shortcutFile.getParentFile().isDirectory() && !shortcutFile.getParentFile().mkdirs()) {
                throw new IOException(shortcutFile.getParentFile().toString());
            }
            FileUtils.createRestrictedFile(shortcutFile, true);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(shortcutFile), Charset.forName("UTF-8"));
                 Reader reader = this.getContentsAsReader(false, info, isSigned);){
                char[] buffer = new char[1024];
                int ret = 0;
                while (-1 != (ret = reader.read(buffer))) {
                    writer.write(buffer, 0, ret);
                }
            }
            Object[] execString = new String[]{"xdg-desktop-icon", "install", "--novendor", shortcutFile.getCanonicalPath()};
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Execing: " + Arrays.toString(execString));
            Process installer = Runtime.getRuntime().exec((String[])execString);
            new StreamEater(installer.getInputStream()).start();
            new StreamEater(installer.getErrorStream()).start();
            try {
                installer.waitFor();
            }
            catch (InterruptedException e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            }
            if (!shortcutFile.delete()) {
                throw new IOException("Unable to delete temporary file:" + shortcutFile);
            }
        }
        catch (FileNotFoundException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
    }

    public void refreshExistingShortcuts(boolean desktop, boolean menu) {
    }

    public File getGeneratedJnlpFileName() {
        String name = FileUtils.sanitizeFileName(this.file.createJnlpTitle());
        while (name.endsWith(".jnlp")) {
            name = name.substring(0, name.length() - 5);
        }
        name = name + ".jnlp";
        return new File(XDesktopEntry.findAndVerifyGeneratedJnlpDir(), name);
    }

    private void cacheIcon() throws IOException, NonFileProtocolException {
        URL uiconLocation = this.file.getInformation().getIconLocation(IconDesc.SHORTCUT, this.iconSize, this.iconSize);
        if (uiconLocation == null) {
            uiconLocation = this.file.getInformation().getIconLocation(IconDesc.DEFAULT, this.iconSize, this.iconSize);
        }
        String location = null;
        if (uiconLocation != null) {
            URL urlLocation = CacheUtil.getCachedResourceURL(uiconLocation, null, UpdatePolicy.SESSION);
            if (urlLocation == null) {
                this.cantCache();
            }
            if (!(location = urlLocation.toString()).startsWith("file:")) {
                this.cantCache();
            }
        } else {
            try {
                URL favico = new URL(this.file.getCodeBase().getProtocol(), this.file.getCodeBase().getHost(), this.file.getCodeBase().getPort(), "/favicon.ico");
                JNLPFile.openURL(favico, null, UpdatePolicy.ALWAYS);
                URL urlLocation = CacheUtil.getCachedResourceURL(favico, null, UpdatePolicy.SESSION);
                if (urlLocation == null) {
                    this.cantCache();
                }
                if (!(location = urlLocation.toString()).startsWith("file:")) {
                    this.cantCache();
                }
            }
            catch (IOException ex) {
                OutputController.getLogger().log(ex);
            }
        }
        if (location != null) {
            String origLocation;
            this.iconLocation = origLocation = location.substring("file:".length());
            PathsAndFiles.ICONS_DIR.getFile().mkdirs();
            File source = new File(origLocation);
            String targetName = source.getName();
            if (targetName.equals(FAVICON)) {
                targetName = this.file.getCodeBase().getHost() + ".ico";
            }
            File target = new File(PathsAndFiles.ICONS_DIR.getFile(), targetName);
            Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.iconLocation = target.getAbsolutePath();
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Cached desktop shortcut icon: " + target + " ,  With source from: " + origLocation);
        }
    }

    private void cantCache() throws NonFileProtocolException {
        throw new NonFileProtocolException("Unable to cache icon");
    }

    private String getDesktopIconName() {
        return XDesktopEntry.sanitize(this.file.createJnlpTitle());
    }

    public File getLinuxDesktopIconFile() {
        return new File(XDesktopEntry.findFreedesktopOrgDesktopPathCatch() + "/" + this.getDesktopIconFileName());
    }

    public File getLinuxMenuIconFile() {
        return new File(XDesktopEntry.findAndVerifyJavawsMenuDir() + "/" + this.getDesktopIconFileName());
    }

    private String getDesktopIconFileName() {
        return this.getDesktopIconName() + ".desktop";
    }

    private static String findAndVerifyGeneratedJnlpDir() {
        return XDesktopEntry.findAndVerifyBasicDir(PathsAndFiles.GEN_JNLPS_DIR.getFile(), " directroy for stroing generated jnlps cannot be created. You may expect failure");
    }

    private static String findAndVerifyJavawsMenuDir() {
        return XDesktopEntry.findAndVerifyBasicDir(PathsAndFiles.MENUS_DIR.getFile(), " directroy for stroing menu entry cannot be created. You may expect failure");
    }

    private static String findAndVerifyBasicDir(File f, String message) {
        String fPath = f.getAbsolutePath();
        if (!f.exists() && !f.mkdirs()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, fPath + message);
        }
        return fPath;
    }

    public static String findFreedesktopOrgDesktopPathCatch() {
        try {
            return XDesktopEntry.findFreedesktopOrgDesktopPath();
        }
        catch (Exception ex) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
            return System.getProperty("user.home") + "/Desktop";
        }
    }

    private static String findFreedesktopOrgDesktopPath() throws IOException {
        File userDirs = new File(System.getProperty("user.home") + "/.config/user-dirs.dirs");
        if (!userDirs.exists()) {
            return System.getProperty("user.home") + "/Desktop/";
        }
        return XDesktopEntry.getFreedesktopOrgDesktopPathFrom(userDirs);
    }

    private static String getFreedesktopOrgDesktopPathFrom(File userDirs) throws IOException {
        try (BufferedReader r = new BufferedReader(new FileReader(userDirs));){
            String string = XDesktopEntry.getFreedesktopOrgDesktopPathFrom(r);
            return string;
        }
    }

    static String getFreedesktopOrgDesktopPathFrom(BufferedReader r) throws IOException {
        String s;
        do {
            if ((s = r.readLine()) != null) continue;
            throw new IOException("End of user-dirs found, but no XDG_DESKTOP_DIR key found");
        } while (!(s = s.trim()).startsWith(XDG_DESKTOP_DIR));
        if (!s.contains("=")) {
            throw new IOException("XDG_DESKTOP_DIR has no value");
        }
        String[] keyAndValue = s.split("=");
        keyAndValue[1] = keyAndValue[1].trim();
        String filteredQuotes = XDesktopEntry.filterQuotes(keyAndValue[1]);
        return XDesktopEntry.evaluateLinuxVariables(filteredQuotes);
    }

    private static String filterQuotes(String string) {
        String s = string.replaceAll("\\\\\"", MIC);
        s = s.replaceAll("\"", "");
        s = s.replaceAll(MIC, "\\\"");
        return s;
    }

    private static String evaluateLinuxVariables(String orig) {
        return XDesktopEntry.evaluateLinuxVariables(orig, System.getenv());
    }

    private static String evaluateLinuxVariables(String orig, Map<String, String> variables) {
        String before;
        ArrayList<Map.Entry<String, String>> envVariables = new ArrayList<Map.Entry<String, String>>(variables.entrySet());
        Collections.sort(envVariables, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o2.getKey().length() - o1.getKey().length();
            }
        });
        do {
            before = orig;
            for (Map.Entry entry : envVariables) {
                orig = orig.replaceAll("\\$" + (String)entry.getKey(), (String)entry.getValue());
            }
        } while (!before.equals(orig));
        return orig;
    }

    private class NonFileProtocolException
    extends Exception {
        private NonFileProtocolException(String unable_to_cache_icon) {
            super(unable_to_cache_icon);
        }
    }
}

