/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.search.SearchPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class FindInFilesAction
extends CallableSystemAction {
    static final long serialVersionUID = 4554342565076372611L;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.search.FindAction_state");
    private static final String VAR_TOOLBAR_COMP_REF = "toolbar presenter ref";
    protected static final String REPLACING = "replacing";
    private static final String VAR_LAST_SEARCH_SCOPE_TYPE = "lastScopeType";
    private final String name;
    protected final boolean preferScopeSelection;
    private final String shortClassName;

    public FindInFilesAction() {
        this(false);
    }

    private FindInFilesAction(boolean bl) {
        this("LBL_Action_FindInProjects", bl);
    }

    protected FindInFilesAction(String string, boolean bl) {
        String string2 = ((Object)((Object)this)).getClass().getName();
        int n = string2.lastIndexOf(46);
        this.shortClassName = n != -1 ? string2.substring(n + 1) : string2;
        this.name = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)string);
        this.preferScopeSelection = bl;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.putProperty(REPLACING, Boolean.FALSE, false);
    }

    public Component getToolbarPresenter() {
        assert (EventQueue.isDispatchThread());
        if (this.shouldLog(LOG)) {
            this.log("getMenuPresenter()");
        }
        Component component = this.getStoredToolbarPresenter();
        return component;
    }

    private Component getStoredToolbarPresenter() {
        Object object;
        Object t;
        Object object2;
        assert (EventQueue.isDispatchThread());
        if (this.shouldLog(LOG)) {
            this.log("getStoredToolbarPresenter()");
        }
        if ((object2 = this.getProperty(VAR_TOOLBAR_COMP_REF)) instanceof Reference && (t = ((Reference)(object = (Reference)object2)).get()) instanceof Component) {
            return (Component)t;
        }
        object = super.getToolbarPresenter();
        this.putProperty(VAR_TOOLBAR_COMP_REF, new WeakReference<Object>(object));
        return object;
    }

    private boolean checkToolbarPresenterExists() {
        Object object;
        assert (EventQueue.isDispatchThread());
        if (this.shouldLog(LOG)) {
            this.log("checkToolbarPresenterExists()");
        }
        if ((object = this.getProperty(VAR_TOOLBAR_COMP_REF)) == null) {
            return false;
        }
        return ((Reference)object).get() != null;
    }

    protected String iconResource() {
        return "org/openide/resources/actions/find.gif";
    }

    public String getName() {
        return this.name;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.search.FindInFilesAction");
    }

    public void performAction() {
        assert (EventQueue.isDispatchThread());
        boolean bl = (Boolean)this.getProperty(REPLACING);
        SearchPanel searchPanel = SearchPanel.getCurrentlyShown();
        if (searchPanel != null) {
            if (searchPanel.isSearchAndReplace() == bl) {
                searchPanel.focusDialog();
            } else {
                searchPanel.close();
                this.showSearchDialog(bl);
            }
        } else {
            this.showSearchDialog(bl);
        }
    }

    private void showSearchDialog(boolean bl) {
        SearchPanel searchPanel = new SearchPanel(bl);
        searchPanel.setPreferScopeSelection(this.preferScopeSelection);
        searchPanel.showDialog();
    }

    protected boolean asynchronous() {
        return false;
    }

    private boolean shouldLog(Logger logger) {
        return logger.isLoggable(Level.FINER) && this.shortClassName.equals("FindInFilesAction");
    }

    private void log(String string) {
        LOG.log(Level.FINER, "{0}: {1}", new Object[]{this.shortClassName, string});
    }

    public static class Selection
    extends FindInFilesAction {
        public Selection() {
            super(true);
        }
    }
}

