/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.EncryptedExtensionsMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptedExtensionsParser
extends HandshakeMessageParser<EncryptedExtensionsMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EncryptedExtensionsParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, HandshakeMessageType.ENCRYPTED_EXTENSIONS, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(EncryptedExtensionsMessage msg) {
        LOGGER.debug("Parsing EncryptedExtensionsMessage");
        if (this.hasExtensionLengthField(msg)) {
            this.parseExtensionLength(msg);
            if (this.hasExtensions(msg)) {
                this.parseExtensionBytes(msg);
            }
        }
    }

    @Override
    protected EncryptedExtensionsMessage createHandshakeMessage() {
        return new EncryptedExtensionsMessage();
    }
}

