/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.charts.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.border.AbstractBorder;
import org.graalvm.visualvm.lib.charts.swing.Utils;

public class RoundBorder
extends AbstractBorder {
    private final Color lineColor;
    private final Color fillColor;
    private final Stroke borderStroke;
    private final int arcRadius;
    private final int borderExtent;
    private final int borderStrokeWidth;
    private final int halfBorderStrokeWidth;
    private final int inset;
    private final boolean forceSpeed;

    public RoundBorder(float lineWidth, Color lineColor, Color fillColor, int arcRadius, int borderExtent) {
        this.lineColor = Utils.checkedColor(lineColor);
        this.fillColor = Utils.checkedColor(fillColor);
        this.arcRadius = arcRadius;
        this.borderExtent = borderExtent;
        this.borderStroke = new BasicStroke(lineWidth);
        this.borderStrokeWidth = (int)lineWidth;
        this.halfBorderStrokeWidth = this.borderStrokeWidth / 2;
        this.inset = this.borderStrokeWidth + borderExtent;
        this.forceSpeed = Utils.forceSpeed();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.inset, this.inset, this.inset, this.inset);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.inset;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.fillColor);
        int arcRadius2 = this.arcRadius * 2;
        int arcRadius2p1 = arcRadius2 + 1;
        g2.fillArc(x, y, arcRadius2, arcRadius2, 90, 90);
        g2.fillArc(x + width - arcRadius2p1, y, arcRadius2, arcRadius2, 0, 90);
        g2.fillArc(x, y + height - arcRadius2p1, arcRadius2, arcRadius2, 180, 90);
        g2.fillArc(x + width - arcRadius2p1, y + height - arcRadius2p1, arcRadius2, arcRadius2, 270, 90);
        g2.fillRect(x + this.arcRadius, y, width - arcRadius2p1, height);
        g2.fillRect(x, y + this.arcRadius, this.arcRadius, height - arcRadius2p1);
        g2.fillRect(x + width - this.arcRadius - 1, y + this.arcRadius, this.arcRadius, height - arcRadius2p1);
        Object aa = null;
        Object sc = null;
        if (!this.forceSpeed) {
            aa = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            sc = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
        g2.setStroke(this.borderStroke);
        g2.setPaint(this.lineColor);
        g2.drawRoundRect(x + this.halfBorderStrokeWidth, y + this.halfBorderStrokeWidth, width - this.borderStrokeWidth, height - this.borderStrokeWidth, this.arcRadius * 2, this.arcRadius * 2);
        if (!this.forceSpeed) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, sc);
        }
    }
}

