/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.report;

import java.io.File;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.Message;

public class ConfigurationResolveReport {
    private final ModuleDescriptor md;
    private final String conf;
    private final Date date;
    private final ResolveOptions options;
    private Map dependencyReports = new LinkedHashMap();
    private Map dependencies = new LinkedHashMap();
    private final ResolveEngine resolveEngine;
    private Map modulesIdsMap = new LinkedHashMap();
    private List modulesIds;
    private Boolean hasChanged = null;

    public ConfigurationResolveReport(ResolveEngine resolveEngine, ModuleDescriptor moduleDescriptor, String string, Date date, ResolveOptions resolveOptions) {
        this.resolveEngine = resolveEngine;
        this.md = moduleDescriptor;
        this.conf = string;
        this.date = date;
        this.options = resolveOptions;
    }

    public void checkIfChanged() {
        Object object = this.resolveEngine.getSettings().getResolutionCacheManager();
        Object object2 = this.options.getResolveId();
        if (((File)(object = object.getConfigurationResolveReportInCache((String)object2, this.conf))).exists()) {
            try {
                object2 = new XmlReportParser();
                ((XmlReportParser)object2).parse((File)object);
                object2 = Arrays.asList(((XmlReportParser)object2).getDependencyRevisionIds());
                object2 = new HashSet<ModuleRevisionId>((Collection<ModuleRevisionId>)object2);
                this.hasChanged = !((AbstractSet)object2).equals(this.getModuleRevisionIds());
                return;
            }
            catch (Exception exception) {
                Message.warn("Error while parsing configuration resolve report " + ((File)object).getAbsolutePath());
                exception.printStackTrace();
            }
        }
        this.hasChanged = Boolean.TRUE;
    }

    public Set getModuleRevisionIds() {
        LinkedHashSet<ModuleRevisionId> linkedHashSet = new LinkedHashSet<ModuleRevisionId>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (ivyNode.isEvicted(this.getConfiguration()) || ivyNode.hasProblem()) continue;
            linkedHashSet.add(ivyNode.getResolvedId());
        }
        return linkedHashSet;
    }

    public void addDependency(IvyNode ivyNode) {
        this.dependencies.put(ivyNode.getId(), ivyNode);
        this.dependencies.put(ivyNode.getResolvedId(), ivyNode);
        this.dependencyReports.put(ivyNode, Collections.EMPTY_LIST);
    }

    public void updateDependency(ModuleRevisionId moduleRevisionId, IvyNode ivyNode) {
        this.dependencies.put(moduleRevisionId, ivyNode);
    }

    public void addDependency(IvyNode ivyNode, DownloadReport downloadReport) {
        this.dependencies.put(ivyNode.getId(), ivyNode);
        this.dependencies.put(ivyNode.getResolvedId(), ivyNode);
        ArrayList<ArtifactDownloadReport> arrayList = new ArrayList<ArtifactDownloadReport>();
        Artifact[] artifactArray = ivyNode.getArtifacts(this.conf);
        for (int i = 0; i < artifactArray.length; ++i) {
            ArtifactDownloadReport artifactDownloadReport = downloadReport.getArtifactReport(artifactArray[i]);
            if (artifactDownloadReport != null) {
                arrayList.add(artifactDownloadReport);
                continue;
            }
            Message.debug("no report found for " + artifactArray[i]);
        }
        this.dependencyReports.put(ivyNode, arrayList);
    }

    public String getConfiguration() {
        return this.conf;
    }

    public Date getDate() {
        return this.date;
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.md;
    }

    public IvyNode[] getUnresolvedDependencies() {
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (!ivyNode.hasProblem()) continue;
            arrayList.add(ivyNode);
        }
        ArrayList<IvyNode> arrayList2 = arrayList;
        return arrayList2.toArray(new IvyNode[arrayList2.size()]);
    }

    private Collection getDependencies() {
        return new LinkedHashSet(this.dependencies.values());
    }

    public IvyNode[] getEvictedNodes() {
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (!ivyNode.isEvicted(this.conf)) continue;
            arrayList.add(ivyNode);
        }
        ArrayList<IvyNode> arrayList2 = arrayList;
        return arrayList2.toArray(new IvyNode[arrayList2.size()]);
    }

    private Set getEvictedMrids() {
        LinkedHashSet<ModuleRevisionId> linkedHashSet = new LinkedHashSet<ModuleRevisionId>();
        IvyNode[] ivyNodeArray = this.getEvictedNodes();
        for (int i = 0; i < ivyNodeArray.length; ++i) {
            linkedHashSet.add(ivyNodeArray[i].getId());
        }
        return linkedHashSet;
    }

    public IvyNode[] getDownloadedNodes() {
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (!ivyNode.isDownloaded() || ivyNode.getRealNode() != ivyNode) continue;
            arrayList.add(ivyNode);
        }
        ArrayList<IvyNode> arrayList2 = arrayList;
        return arrayList2.toArray(new IvyNode[arrayList2.size()]);
    }

    public IvyNode[] getSearchedNodes() {
        ArrayList<IvyNode> arrayList = new ArrayList<IvyNode>();
        for (IvyNode ivyNode : this.getDependencies()) {
            if (!ivyNode.isSearched() || ivyNode.getRealNode() != ivyNode) continue;
            arrayList.add(ivyNode);
        }
        ArrayList<IvyNode> arrayList2 = arrayList;
        return arrayList2.toArray(new IvyNode[arrayList2.size()]);
    }

    public ArtifactDownloadReport[] getDownloadReports(ModuleRevisionId object) {
        if ((object = (Collection)this.dependencyReports.get(this.getDependency((ModuleRevisionId)object))) == null) {
            return new ArtifactDownloadReport[0];
        }
        Object object2 = object;
        return object2.toArray(new ArtifactDownloadReport[object2.size()]);
    }

    public IvyNode getDependency(ModuleRevisionId moduleRevisionId) {
        return (IvyNode)this.dependencies.get(moduleRevisionId);
    }

    public List getModuleIds() {
        if (this.modulesIds == null) {
            Object object = this.resolveEngine.getSortEngine().sortNodes(this.getDependencies(), SortOptions.SILENT);
            Collections.reverse(object);
            object = object.iterator();
            while (object.hasNext()) {
                IvyNode ivyNode = (IvyNode)object.next();
                ModuleId moduleId = ivyNode.getResolvedId().getModuleId();
                LinkedHashSet<IvyNode> linkedHashSet = (LinkedHashSet<IvyNode>)this.modulesIdsMap.get(moduleId);
                if (linkedHashSet == null) {
                    linkedHashSet = new LinkedHashSet<IvyNode>();
                    this.modulesIdsMap.put(moduleId, linkedHashSet);
                }
                linkedHashSet.add(ivyNode);
            }
            this.modulesIds = new ArrayList(this.modulesIdsMap.keySet());
        }
        return Collections.unmodifiableList(this.modulesIds);
    }

    public Collection getNodes(ModuleId moduleId) {
        if (this.modulesIds == null) {
            this.getModuleIds();
        }
        return (Collection)this.modulesIdsMap.get(moduleId);
    }

    public int getArtifactsNumber() {
        int n = 0;
        for (Collection collection : this.dependencyReports.values()) {
            n += collection == null ? 0 : collection.size();
        }
        return n;
    }

    public ArtifactDownloadReport[] getArtifactsReports(DownloadStatus downloadStatus, boolean bl) {
        LinkedHashSet<ArtifactDownloadReport> linkedHashSet = new LinkedHashSet<ArtifactDownloadReport>();
        Set set = null;
        if (!bl) {
            set = this.getEvictedMrids();
        }
        for (Object object : this.dependencyReports.values()) {
            object = object.iterator();
            while (object.hasNext()) {
                ArtifactDownloadReport artifactDownloadReport = (ArtifactDownloadReport)object.next();
                if (downloadStatus != null && artifactDownloadReport.getDownloadStatus() != downloadStatus || !bl && set.contains(artifactDownloadReport.getArtifact().getModuleRevisionId())) continue;
                linkedHashSet.add(artifactDownloadReport);
            }
        }
        LinkedHashSet<ArtifactDownloadReport> linkedHashSet2 = linkedHashSet;
        return linkedHashSet2.toArray(new ArtifactDownloadReport[linkedHashSet2.size()]);
    }

    public ArtifactDownloadReport[] getDownloadedArtifactsReports() {
        return this.getArtifactsReports(DownloadStatus.SUCCESSFUL, true);
    }

    public ArtifactDownloadReport[] getFailedArtifactsReports() {
        ArtifactDownloadReport[] artifactDownloadReportArray = this.getArtifactsReports(DownloadStatus.FAILED, true);
        return ConfigurationResolveReport.filterOutMergedArtifacts(artifactDownloadReportArray);
    }

    public boolean hasError() {
        return this.getUnresolvedDependencies().length > 0 || this.getFailedArtifactsReports().length > 0;
    }

    public int getNodesNumber() {
        return this.getDependencies().size();
    }

    public static ArtifactDownloadReport[] filterOutMergedArtifacts(ArtifactDownloadReport[] object) {
        object = new ArrayList<ArtifactDownloadReport>(Arrays.asList(object));
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            ArtifactDownloadReport artifactDownloadReport = (ArtifactDownloadReport)iterator.next();
            if (artifactDownloadReport.getArtifact().getExtraAttribute("ivy:merged") == null) continue;
            iterator.remove();
        }
        Object object2 = object;
        return object2.toArray(new ArtifactDownloadReport[object2.size()]);
    }
}

