/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.cache;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.ivy.core.cache.ModuleDescriptorProvider;
import org.apache.ivy.core.cache.ParserSettingsMonitor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.util.Message;

class ModuleDescriptorMemoryCache {
    private final int maxSize;
    private final LinkedHashMap valueMap;

    public ModuleDescriptorMemoryCache(int n) {
        this.maxSize = n;
        this.valueMap = new LinkedHashMap(n);
    }

    public ModuleDescriptor get(File file, ParserSettings parserSettings, boolean bl, ModuleDescriptorProvider moduleDescriptorProvider) throws ParseException, IOException {
        ModuleDescriptor moduleDescriptor = this.getFromCache(file, parserSettings, bl);
        if (moduleDescriptor == null) {
            moduleDescriptor = this.getStale(file, parserSettings, bl, moduleDescriptorProvider);
        }
        return moduleDescriptor;
    }

    public ModuleDescriptor getStale(File file, ParserSettings object, boolean bl, ModuleDescriptorProvider object2) throws ParseException, IOException {
        object = new ParserSettingsMonitor((ParserSettings)object);
        object2 = object2.provideModule(((ParserSettingsMonitor)object).getMonitoredSettings(), file, bl);
        this.putInCache(file, (ParserSettingsMonitor)object, bl, (ModuleDescriptor)object2);
        return object2;
    }

    ModuleDescriptor getFromCache(File file, ParserSettings parserSettings, boolean bl) {
        if (this.maxSize <= 0) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)this.valueMap.get(file);
        if (cacheEntry != null) {
            if (cacheEntry.isStale(bl, parserSettings)) {
                Message.debug("Entry is found in the ModuleDescriptorCache but entry should be reevaluated : " + file);
                this.valueMap.remove(file);
                return null;
            }
            this.valueMap.remove(file);
            this.valueMap.put(file, cacheEntry);
            Message.debug("Entry is found in the ModuleDescriptorCache : " + file);
            return cacheEntry.md;
        }
        Message.debug("No entry is found in the ModuleDescriptorCache : " + file);
        return null;
    }

    void putInCache(File file, ParserSettingsMonitor parserSettingsMonitor, boolean bl, ModuleDescriptor moduleDescriptor) {
        if (this.maxSize <= 0) {
            return;
        }
        if (this.valueMap.size() >= this.maxSize) {
            Message.debug("ModuleDescriptorCache is full, remove one entry");
            Iterator iterator = this.valueMap.values().iterator();
            iterator.next();
            iterator.remove();
        }
        this.valueMap.put(file, new CacheEntry(moduleDescriptor, bl, parserSettingsMonitor));
    }

    private static class CacheEntry {
        private final ModuleDescriptor md;
        private final boolean validated;
        private final ParserSettingsMonitor parserSettingsMonitor;

        CacheEntry(ModuleDescriptor moduleDescriptor, boolean bl, ParserSettingsMonitor parserSettingsMonitor) {
            this.md = moduleDescriptor;
            this.validated = bl;
            this.parserSettingsMonitor = parserSettingsMonitor;
        }

        boolean isStale(boolean bl, ParserSettings parserSettings) {
            return bl && !this.validated || this.parserSettingsMonitor.hasChanged(parserSettings);
        }
    }
}

