/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils;

import org.jitsi.utils.ByteArrayBuffer;

public class ByteArrayUtils {
    public static int readUint16(ByteArrayBuffer bab, int off) {
        return ByteArrayUtils.readUint16(bab.getBuffer(), off + bab.getOffset());
    }

    public static int readUint16(byte[] buf, int off) {
        int b1 = 0xFF & buf[off++];
        int b2 = 0xFF & buf[off];
        return b1 << 8 | b2;
    }

    public static void writeUint16(ByteArrayBuffer bab, int off, int value2) {
        ByteArrayUtils.writeUint16(bab.getBuffer(), off + bab.getOffset(), value2);
    }

    public static void writeUint16(byte[] buf, int off, int value2) {
        buf[off++] = (byte)(value2 >> 8 & 0xFF);
        buf[off] = (byte)(value2 & 0xFF);
    }

    public static int readUint24(ByteArrayBuffer bab, int off) {
        return ByteArrayUtils.readUint24(bab.getBuffer(), off + bab.getOffset());
    }

    public static int readUint24(byte[] buf, int off) {
        int b1 = 0xFF & buf[off++];
        int b2 = 0xFF & buf[off++];
        int b3 = 0xFF & buf[off];
        return b1 << 16 | b2 << 8 | b3;
    }

    public static void writeUint24(ByteArrayBuffer bab, int off, int value2) {
        ByteArrayUtils.writeUint24(bab.getBuffer(), off + bab.getOffset(), value2);
    }

    public static void writeUint24(byte[] buf, int off, int value2) {
        buf[off++] = (byte)(value2 >> 16 & 0xFF);
        buf[off++] = (byte)(value2 >> 8 & 0xFF);
        buf[off] = (byte)(value2 & 0xFF);
    }

    public static long readUint32(ByteArrayBuffer bab, int off) {
        return ByteArrayUtils.readUint32(bab.getBuffer(), off + bab.getOffset());
    }

    public static long readUint32(byte[] buf, int off) {
        return (long)ByteArrayUtils.readInt(buf, off) & 0xFFFFFFFFL;
    }

    public static int readInt(ByteArrayBuffer bab, int off) {
        return ByteArrayUtils.readInt(bab.getBuffer(), off + bab.getOffset());
    }

    public static int readInt(byte[] buf, int off) {
        return (buf[off++] & 0xFF) << 24 | (buf[off++] & 0xFF) << 16 | (buf[off++] & 0xFF) << 8 | buf[off] & 0xFF;
    }

    public static void writeInt(ByteArrayBuffer bab, int off, int value2) {
        ByteArrayUtils.writeInt(bab.getBuffer(), off + bab.getOffset(), value2);
    }

    public static void writeInt(byte[] buf, int off, int value2) {
        buf[off++] = (byte)(value2 >> 24 & 0xFF);
        buf[off++] = (byte)(value2 >> 16 & 0xFF);
        buf[off++] = (byte)(value2 >> 8 & 0xFF);
        buf[off] = (byte)(value2 & 0xFF);
    }

    public static short readShort(ByteArrayBuffer bab, int off) {
        return ByteArrayUtils.readShort(bab.getBuffer(), off + bab.getOffset());
    }

    public static short readShort(byte[] buf, int off) {
        return (short)((buf[off++] & 0xFF) << 8 | buf[off] & 0xFF);
    }

    public static void writeShort(ByteArrayBuffer bab, int off, short value2) {
        ByteArrayUtils.writeShort(bab.getBuffer(), off + bab.getOffset(), value2);
    }

    public static void writeShort(byte[] buf, int off, short value2) {
        buf[off++] = (byte)(value2 >> 8 & 0xFF);
        buf[off] = (byte)(value2 & 0xFF);
    }
}

