<?php
/**
 * TableViewPropertiesTableOptions
 *
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Model;

use \ArrayAccess;
use \InfluxDB2\ObjectSerializer;

/**
 * TableViewPropertiesTableOptions Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class TableViewPropertiesTableOptions implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TableViewProperties_tableOptions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'vertical_time_axis' => 'bool',
        'sort_by' => '\InfluxDB2\Model\RenamableField',
        'wrapping' => 'string',
        'fix_first_column' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'vertical_time_axis' => null,
        'sort_by' => null,
        'wrapping' => null,
        'fix_first_column' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'vertical_time_axis' => 'verticalTimeAxis',
        'sort_by' => 'sortBy',
        'wrapping' => 'wrapping',
        'fix_first_column' => 'fixFirstColumn'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'vertical_time_axis' => 'setVerticalTimeAxis',
        'sort_by' => 'setSortBy',
        'wrapping' => 'setWrapping',
        'fix_first_column' => 'setFixFirstColumn'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'vertical_time_axis' => 'getVerticalTimeAxis',
        'sort_by' => 'getSortBy',
        'wrapping' => 'getWrapping',
        'fix_first_column' => 'getFixFirstColumn'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    const WRAPPING_TRUNCATE = 'truncate';
    const WRAPPING_WRAP = 'wrap';
    const WRAPPING_SINGLE_LINE = 'single-line';
    

    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getWrappingAllowableValues()
    {
        return [
            self::WRAPPING_TRUNCATE,
            self::WRAPPING_WRAP,
            self::WRAPPING_SINGLE_LINE,
        ];
    }
    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['vertical_time_axis'] = isset($data['vertical_time_axis']) ? $data['vertical_time_axis'] : null;
        $this->container['sort_by'] = isset($data['sort_by']) ? $data['sort_by'] : null;
        $this->container['wrapping'] = isset($data['wrapping']) ? $data['wrapping'] : null;
        $this->container['fix_first_column'] = isset($data['fix_first_column']) ? $data['fix_first_column'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getWrappingAllowableValues();
        if (!is_null($this->container['wrapping']) && !in_array($this->container['wrapping'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'wrapping', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets vertical_time_axis
     *
     * @return bool|null
     */
    public function getVerticalTimeAxis()
    {
        return $this->container['vertical_time_axis'];
    }

    /**
     * Sets vertical_time_axis
     *
     * @param bool|null $vertical_time_axis verticalTimeAxis describes the orientation of the table by indicating whether the time axis will be displayed vertically
     *
     * @return $this
     */
    public function setVerticalTimeAxis($vertical_time_axis)
    {
        $this->container['vertical_time_axis'] = $vertical_time_axis;

        return $this;
    }

    /**
     * Gets sort_by
     *
     * @return \InfluxDB2\Model\RenamableField|null
     */
    public function getSortBy()
    {
        return $this->container['sort_by'];
    }

    /**
     * Sets sort_by
     *
     * @param \InfluxDB2\Model\RenamableField|null $sort_by sort_by
     *
     * @return $this
     */
    public function setSortBy($sort_by)
    {
        $this->container['sort_by'] = $sort_by;

        return $this;
    }

    /**
     * Gets wrapping
     *
     * @return string|null
     */
    public function getWrapping()
    {
        return $this->container['wrapping'];
    }

    /**
     * Sets wrapping
     *
     * @param string|null $wrapping Wrapping describes the text wrapping style to be used in table views
     *
     * @return $this
     */
    public function setWrapping($wrapping)
    {
        $allowedValues = $this->getWrappingAllowableValues();
        if (!is_null($wrapping) && !in_array($wrapping, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'wrapping', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['wrapping'] = $wrapping;

        return $this;
    }

    /**
     * Gets fix_first_column
     *
     * @return bool|null
     */
    public function getFixFirstColumn()
    {
        return $this->container['fix_first_column'];
    }

    /**
     * Sets fix_first_column
     *
     * @param bool|null $fix_first_column fixFirstColumn indicates whether the first column of the table should be locked
     *
     * @return $this
     */
    public function setFixFirstColumn($fix_first_column)
    {
        $this->container['fix_first_column'] = $fix_first_column;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


