/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordScan;
import org.parosproxy.paros.db.TableScan;
import org.parosproxy.paros.db.paros.ParosAbstractTable;

public class ParosTableScan
extends ParosAbstractTable
implements TableScan {
    private static final String TABLE_NAME = "SCAN";
    private static final String SCANID = "SCANID";
    private static final String SESSIONID = "SESSIONID";
    private static final String SCANNAME = "SCANNAME";
    private static final String SCANTIME = "SCANTIME";
    private PreparedStatement psRead = null;
    private PreparedStatement psInsert = null;
    private CallableStatement psGetIdLastInsert = null;

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            this.psRead = conn.prepareStatement("SELECT * FROM SCAN WHERE SCANID = ?");
            this.psInsert = conn.prepareStatement("INSERT INTO SCAN (SESSIONID,SCANNAME) VALUES (?, ?)");
            this.psGetIdLastInsert = conn.prepareCall("CALL IDENTITY();");
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RecordScan getLatestScan() throws DatabaseException {
        try (PreparedStatement psLatest = this.getConnection().prepareStatement("SELECT * FROM SCAN WHERE SCANID = (SELECT MAX(B.SCANID) FROM SCAN AS B)");){
            RecordScan recordScan;
            block14: {
                ResultSet rs = psLatest.executeQuery();
                try {
                    RecordScan result;
                    recordScan = result = this.build(rs);
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return recordScan;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized RecordScan read(int scanId) throws DatabaseException {
        RecordScan recordScan;
        block8: {
            this.psRead.setInt(1, scanId);
            ResultSet rs = this.psRead.executeQuery();
            try {
                RecordScan result;
                recordScan = result = this.build(rs);
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseException(e);
                }
            }
            rs.close();
        }
        return recordScan;
    }

    @Override
    public synchronized RecordScan insert(long sessionId, String scanName) throws DatabaseException {
        try {
            int id;
            this.psInsert.setLong(1, sessionId);
            this.psInsert.setString(2, scanName);
            this.psInsert.executeUpdate();
            try (ResultSet rs = this.psGetIdLastInsert.executeQuery();){
                rs.next();
                id = rs.getInt(1);
            }
            return this.read(id);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    private RecordScan build(ResultSet rs) throws DatabaseException {
        try {
            RecordScan scan = null;
            if (rs.next()) {
                scan = new RecordScan(rs.getInt(SCANID), rs.getString(SCANNAME), rs.getDate(SCANTIME));
            }
            rs.close();
            return scan;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }
}

