/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.DataRemovedListener;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.sampler.SamplerArguments;
import org.graalvm.visualvm.sampler.SamplerImpl;
import org.graalvm.visualvm.sampler.SamplerParameters;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

final class ApplicationSamplerView
extends DataSourceView {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/sampler/resources/sampler.png";
    private SamplerImpl sampler;
    private SamplerArguments.Request startRequest = SamplerArguments.Request.NONE;
    private SamplerParameters settingsRequest;
    private ApplicationListener applicationListener;

    ApplicationSamplerView(Application application) {
        super((DataSource)application, NbBundle.getMessage(ApplicationSamplerView.class, (String)"LBL_Sampler"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 35, false);
    }

    void startCPU(SamplerParameters settings) {
        if (this.sampler != null) {
            this.sampler.startCPU(settings);
        } else {
            this.startRequest = SamplerArguments.Request.CPU;
            this.settingsRequest = settings;
        }
    }

    void startMemory(SamplerParameters settings) {
        if (this.sampler != null) {
            this.sampler.startMemory(settings);
        } else {
            this.startRequest = SamplerArguments.Request.MEMORY;
            this.settingsRequest = settings;
        }
    }

    void takeSnapshot(boolean openView) {
        if (this.sampler != null) {
            this.sampler.takeSnapshot(openView);
        }
    }

    void stop() {
        if (this.sampler != null) {
            this.sampler.stop();
        }
    }

    protected void willBeAdded() {
        Application application = (Application)this.getDataSource();
        this.sampler = new SamplerImpl(application, this.startRequest, this.settingsRequest);
        this.applicationListener = new ApplicationListener(){

            @Override
            public void dataRemoved(Application application) {
                ApplicationSamplerView.this.applicationFinished();
            }
        };
        application.notifyWhenRemoved((DataRemovedListener)this.applicationListener);
        application.addPropertyChangeListener("prop_state", (PropertyChangeListener)this.applicationListener);
    }

    protected void removed() {
        this.sampler.removed();
        this.cleanup();
    }

    private void applicationFinished() {
        this.sampler.applicationFinished();
        this.cleanup();
    }

    private synchronized void cleanup() {
        Application application = (Application)this.getDataSource();
        if (this.applicationListener != null) {
            application.removePropertyChangeListener("prop_state", (PropertyChangeListener)this.applicationListener);
        }
        this.applicationListener = null;
    }

    protected DataViewComponent createComponent() {
        DataViewComponent dvc = new DataViewComponent(this.sampler.getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        this.sampler.setDataViewComponent(dvc);
        return dvc;
    }

    private static abstract class ApplicationListener
    implements DataRemovedListener<Application>,
    PropertyChangeListener {
        private ApplicationListener() {
        }

        public abstract void dataRemoved(Application var1);

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.dataRemoved(null);
        }
    }
}

