/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.cpu;

import java.util.logging.Logger;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.results.RuntimeCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.RuntimeCCTNodeProcessor;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUCCTProvider;
import org.graalvm.visualvm.lib.jfluid.results.cpu.FlatProfileContainer;
import org.graalvm.visualvm.lib.jfluid.results.cpu.FlatProfileProvider;
import org.graalvm.visualvm.lib.jfluid.results.cpu.cct.CCTFlattener;
import org.graalvm.visualvm.lib.jfluid.results.cpu.cct.CCTResultsFilter;
import org.graalvm.visualvm.lib.jfluid.results.cpu.cct.TimeCollector;
import org.graalvm.visualvm.lib.jfluid.results.cpu.cct.nodes.SimpleCPUCCTNode;

public class FlatProfileBuilder
implements FlatProfileProvider,
CPUCCTProvider.Listener {
    private static final Logger LOGGER = Logger.getLogger(FlatProfileBuilder.class.getName());
    private CCTFlattener flattener;
    private FlatProfileContainer lastFlatProfile = null;
    private ProfilerClient client;
    private SimpleCPUCCTNode appNode;
    private TimeCollector collector = null;
    private CCTResultsFilter filter = null;

    public void setContext(ProfilerClient client, TimeCollector collector, CCTResultsFilter filter) {
        if (this.client != null) {
            this.collector = null;
            this.filter = null;
            this.client.registerFlatProfileProvider(null);
        }
        if (client != null) {
            this.collector = collector;
            this.filter = filter;
            this.flattener = new CCTFlattener(client, filter);
            client.registerFlatProfileProvider(this);
        } else {
            this.flattener = null;
        }
        this.client = client;
        this.appNode = null;
    }

    @Override
    public synchronized void cctEstablished(RuntimeCCTNode appRootNode, boolean empty) {
        if (empty) {
            return;
        }
        this.appNode = appRootNode instanceof SimpleCPUCCTNode ? (SimpleCPUCCTNode)appRootNode : null;
    }

    @Override
    public synchronized void cctReset() {
        this.appNode = null;
    }

    @Override
    public synchronized FlatProfileContainer createFlatProfile() {
        if (this.appNode == null) {
            return null;
        }
        this.client.getStatus().beginTrans(false);
        try {
            RuntimeCCTNodeProcessor.process(this.appNode, this.filter, this.flattener, this.collector);
            this.lastFlatProfile = this.flattener.getFlatProfile();
        }
        finally {
            this.client.getStatus().endTrans();
        }
        return this.lastFlatProfile;
    }
}

