/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.traccar.model.BaseModel;

public class ExtendedModel
extends BaseModel {
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = Objects.requireNonNullElseGet(attributes, LinkedHashMap::new);
    }

    public void set(String key, Boolean value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
    }

    public void set(String key, Byte value) {
        if (value != null) {
            this.attributes.put(key, value.intValue());
        }
    }

    public void set(String key, Short value) {
        if (value != null) {
            this.attributes.put(key, value.intValue());
        }
    }

    public void set(String key, Integer value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
    }

    public void set(String key, Long value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
    }

    public void set(String key, Float value) {
        if (value != null) {
            this.attributes.put(key, value.doubleValue());
        }
    }

    public void set(String key, Double value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
    }

    public void set(String key, String value) {
        if (value != null && !value.isEmpty()) {
            this.attributes.put(key, value);
        }
    }

    public void add(Map.Entry<String, Object> entry) {
        if (entry != null && entry.getValue() != null) {
            this.attributes.put(entry.getKey(), entry.getValue());
        }
    }

    public String getString(String key, String defaultValue) {
        if (this.attributes.containsKey(key)) {
            Object value = this.attributes.get(key);
            return value != null ? value.toString() : null;
        }
        return defaultValue;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public double getDouble(String key) {
        if (this.attributes.containsKey(key)) {
            Object value = this.attributes.get(key);
            if (value instanceof Number) {
                Number numberValue = (Number)value;
                return numberValue.doubleValue();
            }
            return Double.parseDouble(value.toString());
        }
        return 0.0;
    }

    public boolean getBoolean(String key) {
        if (this.attributes.containsKey(key)) {
            Object value = this.attributes.get(key);
            if (value instanceof Boolean) {
                Boolean booleanValue = (Boolean)value;
                return booleanValue;
            }
            return Boolean.parseBoolean(value.toString());
        }
        return false;
    }

    public int getInteger(String key) {
        if (this.attributes.containsKey(key)) {
            Object value = this.attributes.get(key);
            if (value instanceof Number) {
                Number numberValue = (Number)value;
                return numberValue.intValue();
            }
            return Integer.parseInt(value.toString());
        }
        return 0;
    }

    public long getLong(String key) {
        if (this.attributes.containsKey(key)) {
            Object value = this.attributes.get(key);
            if (value instanceof Number) {
                Number numberValue = (Number)value;
                return numberValue.longValue();
            }
            return Long.parseLong(value.toString());
        }
        return 0L;
    }
}

