/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf)) => dmat4(-0.0lf, 0.0lf, 0.0lf, -0.0lf, -0.0lf, 0.0lf, -0.0lf, -0.0lf, -0.0lf, 0.0lf, -0.0lf, -0.0lf, 0.0lf, -0.0lf, -0.0lf, 0.0lf)
 * (0.0lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf)) => dmat4(0.0lf, 0.0lf, 0.0lf, -0.0lf, 0.0lf, -0.0lf, 0.0lf, 0.0lf, 0.0lf, 0.0lf, 0.0lf, -0.0lf, -0.0lf, -0.0lf, -0.0lf, 0.0lf)
 * (-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf)) => dmat4(1.3333333333333333lf, -0.7532956685499058lf, -14.814814814814815lf, 1.465201465201465lf, 2.424242424242424lf, -2.150537634408602lf, 1.8779342723004695lf, 0.7326007326007326lf, 1.2345679012345678lf, -2.7777777777777777lf, 0.9592326139088729lf, 0.9324009324009324lf, -0.74487895716946lf, 0.9876543209876542lf, 1.1019283746556474lf, -1.8518518518518519lf)
 * (-1.3333333333333333lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf)) => dmat4(-22.22222222222222lf, -0.8333333333333333lf, -1.0666666666666667lf, 8.333333333333332lf, -1.0178117048346056lf, 4.166666666666666lf, -2.962962962962963lf, -2.962962962962963lf, -0.8771929824561403lf, -2.61437908496732lf, -0.7017543859649122lf, 1.5151515151515151lf, 0.6802721088435374lf, 0.7246376811594202lf, 1.8518518518518519lf, -3.4188034188034186lf)
 * (0.85lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf)) => dmat4(-0.85lf, 0.48022598870056493lf, 9.444444444444445lf, -0.934065934065934lf, -1.5454545454545452lf, 1.3709677419354838lf, -1.1971830985915493lf, -0.467032967032967lf, -0.787037037037037lf, 1.7708333333333333lf, -0.6115107913669064lf, -0.5944055944055944lf, 0.4748603351955307lf, -0.6296296296296295lf, -0.7024793388429752lf, 1.1805555555555556lf)
 * (0.85lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf)) => dmat4(14.166666666666666lf, 0.53125lf, 0.6799999999999999lf, -5.3125lf, 0.648854961832061lf, -2.65625lf, 1.8888888888888888lf, 1.8888888888888888lf, 0.5592105263157895lf, 1.6666666666666665lf, 0.4473684210526316lf, -0.9659090909090908lf, -0.4336734693877551lf, -0.4619565217391304lf, -1.1805555555555556lf, 2.1794871794871793lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[(distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[0], dvec4(-0.0lf, 0.0lf, 0.0lf, -0.0lf)) * distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[0], dvec4(-0.0lf, 0.0lf, 0.0lf, -0.0lf))) + (distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[1], dvec4(-0.0lf, 0.0lf, -0.0lf, -0.0lf)) * distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[1], dvec4(-0.0lf, 0.0lf, -0.0lf, -0.0lf))) + (distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[2], dvec4(-0.0lf, 0.0lf, -0.0lf, -0.0lf)) * distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[2], dvec4(-0.0lf, 0.0lf, -0.0lf, -0.0lf))) + (distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[3], dvec4(0.0lf, -0.0lf, -0.0lf, 0.0lf)) * distance((0.0lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[3], dvec4(0.0lf, -0.0lf, -0.0lf, 0.0lf))) <= 0.0lf ? 1 : -1] array0;
  double[(distance((0.0lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[0], dvec4(0.0lf, 0.0lf, 0.0lf, -0.0lf)) * distance((0.0lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[0], dvec4(0.0lf, 0.0lf, 0.0lf, -0.0lf))) + (distance((0.0lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[1], dvec4(0.0lf, -0.0lf, 0.0lf, 0.0lf)) * distance((0.0lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[1], dvec4(0.0lf, -0.0lf, 0.0lf, 0.0lf))) + (distance((0.0lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[2], dvec4(0.0lf, 0.0lf, 0.0lf, -0.0lf)) * distance((0.0lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[2], dvec4(0.0lf, 0.0lf, 0.0lf, -0.0lf))) + (distance((0.0lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[3], dvec4(-0.0lf, -0.0lf, -0.0lf, 0.0lf)) * distance((0.0lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[3], dvec4(-0.0lf, -0.0lf, -0.0lf, 0.0lf))) <= 0.0lf ? 1 : -1] array1;
  double[(distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[0], dvec4(1.3333333333333333lf, -0.7532956685499058lf, -14.814814814814815lf, 1.465201465201465lf)) * distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[0], dvec4(1.3333333333333333lf, -0.7532956685499058lf, -14.814814814814815lf, 1.465201465201465lf))) + (distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[1], dvec4(2.424242424242424lf, -2.150537634408602lf, 1.8779342723004695lf, 0.7326007326007326lf)) * distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[1], dvec4(2.424242424242424lf, -2.150537634408602lf, 1.8779342723004695lf, 0.7326007326007326lf))) + (distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[2], dvec4(1.2345679012345678lf, -2.7777777777777777lf, 0.9592326139088729lf, 0.9324009324009324lf)) * distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[2], dvec4(1.2345679012345678lf, -2.7777777777777777lf, 0.9592326139088729lf, 0.9324009324009324lf))) + (distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[3], dvec4(-0.74487895716946lf, 0.9876543209876542lf, 1.1019283746556474lf, -1.8518518518518519lf)) * distance((-1.3333333333333333lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[3], dvec4(-0.74487895716946lf, 0.9876543209876542lf, 1.1019283746556474lf, -1.8518518518518519lf))) <= 2.5573950302039242e-08lf ? 1 : -1] array2;
  double[(distance((-1.3333333333333333lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[0], dvec4(-22.22222222222222lf, -0.8333333333333333lf, -1.0666666666666667lf, 8.333333333333332lf)) * distance((-1.3333333333333333lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[0], dvec4(-22.22222222222222lf, -0.8333333333333333lf, -1.0666666666666667lf, 8.333333333333332lf))) + (distance((-1.3333333333333333lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[1], dvec4(-1.0178117048346056lf, 4.166666666666666lf, -2.962962962962963lf, -2.962962962962963lf)) * distance((-1.3333333333333333lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[1], dvec4(-1.0178117048346056lf, 4.166666666666666lf, -2.962962962962963lf, -2.962962962962963lf))) + (distance((-1.3333333333333333lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[2], dvec4(-0.8771929824561403lf, -2.61437908496732lf, -0.7017543859649122lf, 1.5151515151515151lf)) * distance((-1.3333333333333333lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[2], dvec4(-0.8771929824561403lf, -2.61437908496732lf, -0.7017543859649122lf, 1.5151515151515151lf))) + (distance((-1.3333333333333333lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[3], dvec4(0.6802721088435374lf, 0.7246376811594202lf, 1.8518518518518519lf, -3.4188034188034186lf)) * distance((-1.3333333333333333lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[3], dvec4(0.6802721088435374lf, 0.7246376811594202lf, 1.8518518518518519lf, -3.4188034188034186lf))) <= 6.275572088470112e-08lf ? 1 : -1] array3;
  double[(distance((0.85lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[0], dvec4(-0.85lf, 0.48022598870056493lf, 9.444444444444445lf, -0.934065934065934lf)) * distance((0.85lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[0], dvec4(-0.85lf, 0.48022598870056493lf, 9.444444444444445lf, -0.934065934065934lf))) + (distance((0.85lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[1], dvec4(-1.5454545454545452lf, 1.3709677419354838lf, -1.1971830985915493lf, -0.467032967032967lf)) * distance((0.85lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[1], dvec4(-1.5454545454545452lf, 1.3709677419354838lf, -1.1971830985915493lf, -0.467032967032967lf))) + (distance((0.85lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[2], dvec4(-0.787037037037037lf, 1.7708333333333333lf, -0.6115107913669064lf, -0.5944055944055944lf)) * distance((0.85lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[2], dvec4(-0.787037037037037lf, 1.7708333333333333lf, -0.6115107913669064lf, -0.5944055944055944lf))) + (distance((0.85lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[3], dvec4(0.4748603351955307lf, -0.6296296296296295lf, -0.7024793388429752lf, 1.1805555555555556lf)) * distance((0.85lf / dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf))[3], dvec4(0.4748603351955307lf, -0.6296296296296295lf, -0.7024793388429752lf, 1.1805555555555556lf))) <= 1.0393413239938136e-08lf ? 1 : -1] array4;
  double[(distance((0.85lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[0], dvec4(14.166666666666666lf, 0.53125lf, 0.6799999999999999lf, -5.3125lf)) * distance((0.85lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[0], dvec4(14.166666666666666lf, 0.53125lf, 0.6799999999999999lf, -5.3125lf))) + (distance((0.85lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[1], dvec4(0.648854961832061lf, -2.65625lf, 1.8888888888888888lf, 1.8888888888888888lf)) * distance((0.85lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[1], dvec4(0.648854961832061lf, -2.65625lf, 1.8888888888888888lf, 1.8888888888888888lf))) + (distance((0.85lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[2], dvec4(0.5592105263157895lf, 1.6666666666666665lf, 0.4473684210526316lf, -0.9659090909090908lf)) * distance((0.85lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[2], dvec4(0.5592105263157895lf, 1.6666666666666665lf, 0.4473684210526316lf, -0.9659090909090908lf))) + (distance((0.85lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[3], dvec4(-0.4336734693877551lf, -0.4619565217391304lf, -1.1805555555555556lf, 2.1794871794871793lf)) * distance((0.85lf / dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf))[3], dvec4(-0.4336734693877551lf, -0.4619565217391304lf, -1.1805555555555556lf, 2.1794871794871793lf))) <= 2.550431719079807e-08lf ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
