/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commons.io.UnsignedNumeric;

public class IracManagerKeyInfo {
    final int segment;
    final Object key;
    final Object owner;

    public IracManagerKeyInfo(int segment, Object key, Object owner) {
        this.segment = segment;
        this.key = Objects.requireNonNull(key);
        this.owner = Objects.requireNonNull(owner);
    }

    public Object getKey() {
        return this.key;
    }

    public Object getOwner() {
        return this.owner;
    }

    public int getSegment() {
        return this.segment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IracManagerKeyInfo)) {
            return false;
        }
        IracManagerKeyInfo that = (IracManagerKeyInfo)o;
        if (this.segment != that.getSegment()) {
            return false;
        }
        if (!this.key.equals(that.getKey())) {
            return false;
        }
        return this.owner.equals(that.getOwner());
    }

    public int hashCode() {
        int result = this.segment;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.owner.hashCode();
        return result;
    }

    public String toString() {
        return "IracManagerKeyInfoImpl{segment=" + this.segment + ", key=" + String.valueOf(this.key) + ", owner=" + String.valueOf(this.owner) + "}";
    }

    public static void writeTo(ObjectOutput output, IracManagerKeyInfo keyInfo) throws IOException {
        if (keyInfo == null) {
            output.writeObject(null);
            return;
        }
        output.writeObject(keyInfo.getKey());
        UnsignedNumeric.writeUnsignedInt((DataOutput)output, (int)keyInfo.getSegment());
        output.writeObject(keyInfo.getOwner());
    }

    public static IracManagerKeyInfo readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        Object key = input.readObject();
        if (key == null) {
            return null;
        }
        return new IracManagerKeyInfo(UnsignedNumeric.readUnsignedInt((DataInput)input), key, input.readObject());
    }
}

