/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.runtime;

import io.quarkus.runtime.ExecutorRecorder;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.vertx.core.runtime.config.VertxConfiguration;
import io.vertx.core.spi.ExecutorServiceFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.threads.EnhancedQueueExecutor;
import org.jboss.threads.JBossExecutors;

public class QuarkusExecutorFactory
implements ExecutorServiceFactory {
    static volatile ExecutorService sharedExecutor;
    private static final AtomicInteger executorCount;
    private static final Logger log;
    private final VertxConfiguration conf;
    private final LaunchMode launchMode;

    public QuarkusExecutorFactory(VertxConfiguration conf, LaunchMode launchMode) {
        this.conf = conf;
        this.launchMode = launchMode;
    }

    public ExecutorService createExecutor(ThreadFactory threadFactory, Integer concurrency, Integer maxConcurrency) {
        if (executorCount.incrementAndGet() == 1 && this.launchMode != LaunchMode.DEVELOPMENT) {
            if (sharedExecutor == null) {
                log.warn((Object)"Shared executor not set. Unshared executor will be created for blocking work");
                sharedExecutor = this.internalCreateExecutor(threadFactory, concurrency, maxConcurrency);
            }
            return sharedExecutor;
        }
        return this.internalCreateExecutor(threadFactory, concurrency, maxConcurrency);
    }

    private ExecutorService internalCreateExecutor(ThreadFactory threadFactory, Integer concurrency, Integer maxConcurrency) {
        EnhancedQueueExecutor.Builder builder = new EnhancedQueueExecutor.Builder().setRegisterMBean(false).setHandoffExecutor(JBossExecutors.rejectingExecutor()).setThreadFactory(JBossExecutors.resettingThreadFactory((ThreadFactory)threadFactory));
        builder.setCorePoolSize(concurrency.intValue());
        builder.setMaximumPoolSize(maxConcurrency != null ? maxConcurrency : ExecutorRecorder.calculateMaxThreads());
        if (this.conf != null) {
            if (this.conf.queueSize().isPresent()) {
                if (this.conf.queueSize().getAsInt() < 0) {
                    builder.setMaximumQueueSize(Integer.MAX_VALUE);
                } else {
                    builder.setMaximumQueueSize(this.conf.queueSize().getAsInt());
                }
            }
            builder.setGrowthResistance(this.conf.growthResistance());
            builder.setKeepAliveTime(this.conf.keepAliveTime());
        }
        EnhancedQueueExecutor eqe = builder.build();
        if (this.conf != null && this.conf.prefill()) {
            eqe.prestartAllCoreThreads();
        }
        return eqe;
    }

    static {
        executorCount = new AtomicInteger(0);
        log = Logger.getLogger(QuarkusExecutorFactory.class);
    }
}

