/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.c14n.implementations;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.security.Key;
import java.security.MessageDigest;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.c14n.implementations.Canonicalizer20010315ExclOmitComments;
import org.apache.xml.security.c14n.implementations.Canonicalizer20010315ExclWithComments;
import org.apache.xml.security.c14n.implementations.Canonicalizer20010315WithComments;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Canonicalizer20010315ExclusiveTest
extends TestCase {
    static Log log;
    DocumentBuilderFactory dbf;
    DocumentBuilder db;
    static /* synthetic */ Class class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315ExclusiveTest;

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315ExclusiveTest == null ? (class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315ExclusiveTest = Canonicalizer20010315ExclusiveTest.class$("org.apache.xml.security.test.c14n.implementations.Canonicalizer20010315ExclusiveTest")) : class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315ExclusiveTest);
    }

    public Canonicalizer20010315ExclusiveTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-noloading", (class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315ExclusiveTest == null ? (class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315ExclusiveTest = Canonicalizer20010315ExclusiveTest.class$("org.apache.xml.security.test.c14n.implementations.Canonicalizer20010315ExclusiveTest")) : class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315ExclusiveTest).getName()};
        TestRunner.main((String[])stringArray2);
    }

    public void setUp() throws ParserConfigurationException {
        this.dbf = DocumentBuilderFactory.newInstance();
        this.dbf.setNamespaceAware(true);
        this.db = this.dbf.newDocumentBuilder();
    }

    public void testA() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XMLSignatureException, XMLSecurityException, KeyResolverException {
        File file = new File(this.getAbsolutePath("data/ie/baltimore/merlin-examples/ec-merlin-iaikTests-two/signature.xml"));
        Canonicalizer20010315ExclusiveTest.assertTrue((String)"file exists", (boolean)file.exists());
        Document document = this.db.parse(file);
        Element element = (Element)document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        XMLSignature xMLSignature = new XMLSignature(element, file.toURL().toString());
        boolean bl = xMLSignature.checkSignatureValue((Key)xMLSignature.getKeyInfo().getPublicKey());
        int n = xMLSignature.getSignedInfo().getLength();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl2 = xMLSignature.getSignedInfo().getVerificationResult(i);
            if (!bl2) continue;
            ++n2;
        }
        Canonicalizer20010315ExclusiveTest.assertTrue((String)("Verification failed; only " + n2 + "/" + n + " matched"), (boolean)bl);
    }

    public void test221() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XMLSignatureException, XMLSecurityException {
        Document document = this.db.parse(this.getAbsolutePath("data/org/apache/xml/security/c14n/inExcl/example2_2_1.xml"));
        Node node = document.getElementsByTagNameNS("http://example.net", "elem2").item(0);
        Canonicalizer20010315WithComments canonicalizer20010315WithComments = new Canonicalizer20010315WithComments();
        byte[] byArray = JavaUtils.getBytesFromFile((String)this.getAbsolutePath("data/org/apache/xml/security/c14n/inExcl/example2_2_1_c14nized.xml"));
        byte[] byArray2 = canonicalizer20010315WithComments.engineCanonicalizeSubTree(node);
        boolean bl = MessageDigest.isEqual(byArray, byArray2);
        Canonicalizer20010315ExclusiveTest.assertTrue((boolean)bl);
    }

    public void test222() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XMLSignatureException, XMLSecurityException {
        Document document = this.db.parse(this.getAbsolutePath("data/org/apache/xml/security/c14n/inExcl/example2_2_2.xml"));
        Node node = document.getElementsByTagNameNS("http://example.net", "elem2").item(0);
        Canonicalizer20010315WithComments canonicalizer20010315WithComments = new Canonicalizer20010315WithComments();
        byte[] byArray = JavaUtils.getBytesFromFile((String)this.getAbsolutePath("data/org/apache/xml/security/c14n/inExcl/example2_2_2_c14nized.xml"));
        byte[] byArray2 = canonicalizer20010315WithComments.engineCanonicalizeSubTree(node);
        boolean bl = MessageDigest.isEqual(byArray, byArray2);
        Canonicalizer20010315ExclusiveTest.assertTrue((boolean)bl);
    }

    public void test221excl() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XMLSignatureException, XMLSecurityException {
        Document document = this.db.parse(this.getAbsolutePath("data/org/apache/xml/security/c14n/inExcl/example2_2_1.xml"));
        Node node = document.getElementsByTagNameNS("http://example.net", "elem2").item(0);
        Canonicalizer20010315ExclWithComments canonicalizer20010315ExclWithComments = new Canonicalizer20010315ExclWithComments();
        byte[] byArray = JavaUtils.getBytesFromFile((String)this.getAbsolutePath("data/org/apache/xml/security/c14n/inExcl/example2_2_c14nized_exclusive.xml"));
        byte[] byArray2 = canonicalizer20010315ExclWithComments.engineCanonicalizeSubTree(node);
        boolean bl = MessageDigest.isEqual(byArray, byArray2);
        Canonicalizer20010315ExclusiveTest.assertTrue((boolean)bl);
    }

    public void test222excl() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XMLSignatureException, XMLSecurityException {
        Document document = this.db.parse(this.getAbsolutePath("data/org/apache/xml/security/c14n/inExcl/example2_2_2.xml"));
        Node node = document.getElementsByTagNameNS("http://example.net", "elem2").item(0);
        Canonicalizer20010315ExclWithComments canonicalizer20010315ExclWithComments = new Canonicalizer20010315ExclWithComments();
        byte[] byArray = JavaUtils.getBytesFromFile((String)this.getAbsolutePath("data/org/apache/xml/security/c14n/inExcl/example2_2_c14nized_exclusive.xml"));
        byte[] byArray2 = canonicalizer20010315ExclWithComments.engineCanonicalizeSubTree(node);
        boolean bl = MessageDigest.isEqual(byArray, byArray2);
        Canonicalizer20010315ExclusiveTest.assertTrue((boolean)bl);
    }

    public void test223excl() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XMLSignatureException, XMLSecurityException {
        Document document = this.db.parse(this.getAbsolutePath("data/org/apache/xml/security/c14n/inExcl/example2_2_3.xml"));
        NodeList nodeList = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)"(//. | //@* | //namespace::*)[ancestor-or-self::p]");
        Canonicalizer20010315ExclWithComments canonicalizer20010315ExclWithComments = new Canonicalizer20010315ExclWithComments();
        byte[] byArray = JavaUtils.getBytesFromFile((String)this.getAbsolutePath("data/org/apache/xml/security/c14n/inExcl/example2_2_3_c14nized_exclusive.xml"));
        byte[] byArray2 = canonicalizer20010315ExclWithComments.engineCanonicalizeXPathNodeSet(nodeList);
        Canonicalizer20010315ExclusiveTest.assertEquals((String)new String(byArray), (String)new String(byArray2));
    }

    public void testNodeSet() throws Exception {
        Document document = this.db.parse(new InputSource(new StringReader("<env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ns0=\"http://xmlsoap.org/Ping\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"><env:Body wsu:Id=\"body\"><ns0:Ping xsi:type=\"ns0:ping\"><ns0:text xsi:type=\"xsd:string\">hello</ns0:text></ns0:Ping></env:Body></env:Envelope>")));
        Canonicalizer20010315ExclOmitComments canonicalizer20010315ExclOmitComments = new Canonicalizer20010315ExclOmitComments();
        HashSet hashSet = new HashSet();
        XMLUtils.getSet((Node)document.getDocumentElement().getFirstChild(), hashSet, null, (boolean)false);
        XMLSignatureInput xMLSignatureInput = new XMLSignatureInput(hashSet);
        byte[] byArray = canonicalizer20010315ExclOmitComments.engineCanonicalize(xMLSignatureInput, "env ns0 xsi wsu");
        Canonicalizer20010315ExclusiveTest.assertEquals((String)"<env:Body xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ns0=\"http://xmlsoap.org/Ping\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" wsu:Id=\"body\"><ns0:Ping xsi:type=\"ns0:ping\"><ns0:text xsi:type=\"xsd:string\">hello</ns0:text></ns0:Ping></env:Body>", (String)new String(byArray));
    }

    public void test24excl() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XMLSignatureException, XMLSecurityException {
        Document document = this.db.parse(this.getAbsolutePath("data/org/apache/xml/security/c14n/inExcl/example2_4.xml"));
        Node node = document.getElementsByTagNameNS("http://example.net", "elem2").item(0);
        Canonicalizer20010315ExclWithComments canonicalizer20010315ExclWithComments = new Canonicalizer20010315ExclWithComments();
        byte[] byArray = JavaUtils.getBytesFromFile((String)this.getAbsolutePath("data/org/apache/xml/security/c14n/inExcl/example2_4_c14nized.xml"));
        byte[] byArray2 = canonicalizer20010315ExclWithComments.engineCanonicalizeSubTree(node);
        boolean bl = MessageDigest.isEqual(byArray, byArray2);
        Canonicalizer20010315ExclusiveTest.assertTrue((boolean)bl);
    }

    public void test24Aexcl() throws IOException, FileNotFoundException, SAXException, ParserConfigurationException, CanonicalizationException, InvalidCanonicalizerException, TransformerException, XMLSignatureException, XMLSecurityException {
        Document document = this.dbf.newDocumentBuilder().newDocument();
        Element element = document.createElementNS("foo:bar", "dsig:local");
        Element element2 = document.createElementNS("http://example.net", "etsi:test");
        Element element3 = document.createElementNS("http://example.net", "etsi:elem2");
        Element element4 = document.createElementNS("foo:bar", "dsig:stuff");
        element3.appendChild(element4);
        element2.appendChild(element3);
        element.appendChild(element2);
        document.appendChild(element);
        Node node = document.getElementsByTagNameNS("http://example.net", "elem2").item(0);
        Canonicalizer20010315ExclWithComments canonicalizer20010315ExclWithComments = new Canonicalizer20010315ExclWithComments();
        byte[] byArray = JavaUtils.getBytesFromFile((String)this.getAbsolutePath("data/org/apache/xml/security/c14n/inExcl/example2_4_c14nized.xml"));
        byte[] byArray2 = canonicalizer20010315ExclWithComments.engineCanonicalizeSubTree(node);
        boolean bl = MessageDigest.isEqual(byArray, byArray2);
        Canonicalizer20010315ExclusiveTest.assertTrue((boolean)bl);
    }

    private String getAbsolutePath(String string) {
        String string2 = System.getProperty("basedir");
        if (string2 != null && !"".equals(string2)) {
            string = string2 + "/" + string;
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Init.init();
        log = LogFactory.getLog((String)(class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315ExclusiveTest == null ? (class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315ExclusiveTest = Canonicalizer20010315ExclusiveTest.class$("org.apache.xml.security.test.c14n.implementations.Canonicalizer20010315ExclusiveTest")) : class$org$apache$xml$security$test$c14n$implementations$Canonicalizer20010315ExclusiveTest).getName());
    }
}

