/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ArchitectPropertiesDataSourceTypeOptionPanel;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionImpl;
import ca.sqlpower.architect.swingui.DefaultColumnPanel;
import ca.sqlpower.architect.swingui.KettleDataSourceTypeOptionPanel;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.PreferencesPanel;
import ca.sqlpower.architect.swingui.action.EditTableAction;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.JDefaultButton;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.db.DataSourceTypeEditor;
import ca.sqlpower.swingui.db.DataSourceTypeEditorTabPanel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

public class PreferencesEditor {
    private static final Logger logger = Logger.getLogger(EditTableAction.class);
    private static final ImageIcon SERVER_JDBCDRIVER_ICON = new ImageIcon(PreferencesEditor.class.getResource(""));
    private static final ImageIcon LOCAL_JDBCDRIVER_ICON = new ImageIcon(PreferencesEditor.class.getResource(""));

    public Window showPreferencesDialog(Window owner, ArchitectSwingSession session) {
        logger.debug((Object)"showPreferencesDialog");
        final JDialog d = SPSUtils.makeOwnedDialog((Component)owner, (String)Messages.getString("PreferencesEditor.userPreferencesDialogTitle"));
        JPanel cp = new JPanel(new BorderLayout(12, 12));
        JTabbedPane tp = new JTabbedPane();
        cp.add((Component)tp, "Center");
        cp.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        final PreferencesPanel prefPanel = new PreferencesPanel(session.getContext());
        tp.add(Messages.getString("PreferencesEditor.generalSection"), prefPanel);
        final DataSourceTypeEditor dsTypeEditor = new DataSourceTypeEditor(session.getDataSources(), owner, session.isEnterpriseSession());
        KettleDataSourceTypeOptionPanel kettleOptsPanel = new KettleDataSourceTypeOptionPanel();
        dsTypeEditor.addTab(Messages.getString("PreferencesEditor.kettleSection"), (DataSourceTypeEditorTabPanel)kettleOptsPanel);
        ArchitectPropertiesDataSourceTypeOptionPanel architectPropPanel = new ArchitectPropertiesDataSourceTypeOptionPanel();
        dsTypeEditor.addTab(Messages.getString("PreferencesEditor.propertiesSection"), (DataSourceTypeEditorTabPanel)architectPropPanel);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.createLabelPanel(session), "North");
        p.add((Component)dsTypeEditor.getPanel(), "Center");
        tp.add("Local " + Messages.getString("PreferencesEditor.jdbcDriversSection"), p);
        final DefaultColumnPanel defaultColumnPanel = new DefaultColumnPanel(session.getContext());
        tp.add(Messages.getString("PreferencesEditor.defaultColumnSection"), defaultColumnPanel);
        JDefaultButton okButton = new JDefaultButton(DataEntryPanelBuilder.OK_BUTTON_LABEL);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                prefPanel.applyChanges();
                dsTypeEditor.applyChanges();
                defaultColumnPanel.applyChanges();
                d.setVisible(false);
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                prefPanel.discardChanges();
                dsTypeEditor.discardChanges();
                defaultColumnPanel.discardChanges();
                d.setVisible(false);
            }
        };
        cancelAction.putValue("Name", DataEntryPanelBuilder.CANCEL_BUTTON_LABEL);
        JButton cancelButton = new JButton(cancelAction);
        JPanel buttonPanel = ButtonBarFactory.buildOKCancelBar((JButton)okButton, (JButton)cancelButton);
        SPSUtils.makeJDialogCancellable((Window)d, (Action)cancelAction);
        d.getRootPane().setDefaultButton((JButton)okButton);
        cp.add((Component)buttonPanel, "South");
        d.setContentPane(cp);
        d.pack();
        d.setLocationRelativeTo(owner);
        d.setVisible(true);
        return d;
    }

    public Window showJDBCDriverPreferences(Window owner, ArchitectSwingSession session) {
        logger.debug((Object)"showJDBCDriverPreferences");
        final JDialog d = SPSUtils.makeOwnedDialog((Component)owner, (String)Messages.getString("PreferencesEditor.jdbcDriversSection"));
        JPanel cp = new JPanel(new BorderLayout(12, 12));
        cp.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        cp.add((Component)this.createLabelPanel(session), "North");
        final DataSourceTypeEditor dsTypeEditor = new DataSourceTypeEditor(session.getDataSources(), owner, session.isEnterpriseSession());
        KettleDataSourceTypeOptionPanel kettleOptsPanel = new KettleDataSourceTypeOptionPanel();
        dsTypeEditor.addTab(Messages.getString("PreferencesEditor.kettleSection"), (DataSourceTypeEditorTabPanel)kettleOptsPanel);
        ArchitectPropertiesDataSourceTypeOptionPanel architectPropPanel = new ArchitectPropertiesDataSourceTypeOptionPanel();
        dsTypeEditor.addTab(Messages.getString("PreferencesEditor.propertiesSection"), (DataSourceTypeEditorTabPanel)architectPropPanel);
        cp.add((Component)dsTypeEditor.getPanel(), "Center");
        JDefaultButton okButton = new JDefaultButton(DataEntryPanelBuilder.OK_BUTTON_LABEL);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                dsTypeEditor.applyChanges();
                d.setVisible(false);
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                dsTypeEditor.discardChanges();
                d.setVisible(false);
            }
        };
        cancelAction.putValue("Name", DataEntryPanelBuilder.CANCEL_BUTTON_LABEL);
        JButton cancelButton = new JButton(cancelAction);
        JPanel buttonPanel = ButtonBarFactory.buildOKCancelBar((JButton)okButton, (JButton)cancelButton);
        SPSUtils.makeJDialogCancellable((Window)d, (Action)cancelAction);
        d.getRootPane().setDefaultButton((JButton)okButton);
        cp.add((Component)buttonPanel, "South");
        d.setContentPane(cp);
        d.pack();
        d.setLocationRelativeTo(owner);
        d.setVisible(true);
        return d;
    }

    private JPanel createLabelPanel(ArchitectSwingSession session) {
        FormLayout layout = new FormLayout("pref:grow, pref, pref:grow", "pref");
        DefaultFormBuilder fb = new DefaultFormBuilder(layout);
        JLabel label = new JLabel();
        label.setText(session.isEnterpriseSession() ? "Enterprise Server JDBCDrivers on " + ((ArchitectSwingSessionImpl)session).getServerName() : "Local JDBCDrivers");
        label.setFont(new Font("Arial", 1, 18));
        label.setIcon(session.isEnterpriseSession() ? SERVER_JDBCDRIVER_ICON : LOCAL_JDBCDRIVER_ICON);
        fb.add((Component)label, "2, 1");
        return fb.getPanel();
    }
}

