/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.accessinput;

import com.healthmarketscience.jackcess.Database;
import java.io.File;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.accessinput.AccessInputData;
import org.pentaho.di.trans.steps.accessinput.AccessInputField;
import org.pentaho.di.trans.steps.accessinput.AccessInputMeta;
import org.pentaho.di.trans.steps.accessinput.Messages;

public class AccessInput
extends BaseStep
implements StepInterface {
    private AccessInputMeta meta;
    private AccessInputData data;

    public AccessInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block5: {
            Object[] r = null;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                Object[] outputRowData = this.getOneRow();
                if (outputRowData == null) {
                    this.setOutputDone();
                    return false;
                }
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.meta.getRowLimit() > 0L && this.data.rownr > this.meta.getRowLimit()) {
                    this.setOutputDone();
                    return false;
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("AccessInput.ErrorInStepRunning", e.getMessage()));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block5;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "AccessInput001");
            }
        }
        return true;
    }

    private Object[] getOneRow() throws KettleException {
        try {
            if (this.meta.isFileField()) {
                while (this.data.readrow == null || (this.data.rw = this.data.t.getNextRow()) == null) {
                    if (this.openNextFile()) continue;
                    return null;
                }
            } else {
                while (this.data.file == null || (this.data.rw = this.data.t.getNextRow()) == null) {
                    if (this.openNextFile()) continue;
                    return null;
                }
            }
        }
        catch (Exception IO) {
            return null;
        }
        Object[] r = this.buildEmptyRow();
        if (this.meta.isFileField()) {
            System.arraycopy(this.data.readrow, 0, r, 0, this.data.readrow.length);
        }
        try {
            RowMetaInterface irow;
            for (int i = 0; i < this.meta.getInputFields().length; ++i) {
                AccessInputField field = this.meta.getInputFields()[i];
                Object obj = this.data.rw.get(this.environmentSubstitute(field.getColumn()));
                String value = obj == null ? null : String.valueOf(obj);
                if (obj instanceof Date && field.getType() == 3) {
                    r[this.data.totalpreviousfields + i] = obj;
                } else {
                    switch (field.getTrimType()) {
                        case 1: {
                            value = Const.ltrim((String)value);
                            break;
                        }
                        case 2: {
                            value = Const.rtrim((String)value);
                            break;
                        }
                        case 3: {
                            value = Const.trim((String)value);
                            break;
                        }
                    }
                    ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(this.data.totalpreviousfields + i);
                    ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(this.data.totalpreviousfields + i);
                    r[this.data.totalpreviousfields + i] = targetValueMeta.convertData(sourceValueMeta, (Object)value);
                }
                if (!field.isRepeated() || this.data.previousRow == null || !Const.isEmpty((String)value)) continue;
                r[this.data.totalpreviousfields + i] = this.data.previousRow[this.data.totalpreviousfields + i];
            }
            int rowIndex = this.meta.getInputFields().length;
            if (this.meta.includeFilename() && !Const.isEmpty((String)this.meta.getFilenameField())) {
                r[this.data.totalpreviousfields + rowIndex++] = AccessInputMeta.getFilename(this.data.file);
            }
            if (this.meta.includeTablename() && !Const.isEmpty((String)this.data.t.getName())) {
                r[this.data.totalpreviousfields + rowIndex++] = this.data.t.getName();
            }
            if (this.meta.includeRowNumber() && !Const.isEmpty((String)this.meta.getRowNumberField())) {
                r[this.data.totalpreviousfields + rowIndex++] = new Long(this.data.rownr);
            }
            this.data.previousRow = (irow = this.getInputRowMeta()) == null ? r : irow.cloneRow(r);
            this.incrementLinesInput();
            ++this.data.rownr;
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("AccessInput.Error.ErrorReadingFile"), (Throwable)e);
        }
        return r;
    }

    private boolean openNextFile() {
        try {
            if (!this.meta.isFileField()) {
                if (this.data.filenr >= this.data.files.nrOfFiles()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString("AccessInput.Log.FinishedProcessing"));
                    }
                    return false;
                }
                this.data.last_file = this.data.filenr == this.data.files.nrOfFiles() - 1;
                this.data.file = this.data.files.getFile(this.data.filenr);
                ++this.data.filenr;
            } else {
                this.data.readrow = this.getRow();
                if (this.data.readrow == null) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString("AccessInput.Log.FinishedProcessing"));
                    }
                    return false;
                }
                if (this.first) {
                    this.first = false;
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (int i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                    if (Const.isEmpty((String)this.meta.getDynamicFilenameField())) {
                        this.logError(Messages.getString("AccessInput.Log.NoField"));
                        throw new KettleException(Messages.getString("AccessInput.Log.NoField"));
                    }
                    if (this.data.indexOfFilenameField < 0) {
                        this.data.indexOfFilenameField = this.getInputRowMeta().indexOfValue(this.meta.getDynamicFilenameField());
                        if (this.data.indexOfFilenameField < 0) {
                            this.logError(Messages.getString("AccessInput.Log.ErrorFindingField") + "[" + this.meta.getDynamicFilenameField() + "]");
                            throw new KettleException(Messages.getString("AccessInput.Exception.CouldnotFindField", this.meta.getDynamicFilenameField()));
                        }
                    }
                }
                String filename = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfFilenameField);
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), Messages.getString("AccessInput.Log.FilenameInStream", this.meta.getDynamicFilenameField(), filename), new Object[0]);
                }
                this.data.file = KettleVFS.getFileObject((String)filename);
            }
            if (this.meta.resetRowNumber()) {
                this.data.rownr = 0L;
            }
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("AccessInput.Log.OpeningFile", this.data.file.toString()));
            }
            if (this.meta.isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment(Messages.getString("AccessInput.Log.FileAddedResult"));
                this.addResultFile(resultFile);
            }
            this.data.file.getName().getPathDecoded();
            this.data.d = Database.open((File)new File(AccessInputMeta.getFilename(this.data.file)), (boolean)true);
            String realTableName = this.environmentSubstitute(this.meta.getTableName());
            this.data.t = realTableName.startsWith("MSys") ? this.data.d.getSystemTable(realTableName) : this.data.d.getTable(realTableName);
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("AccessInput.Log.FileOpened", this.data.file.toString()));
            }
        }
        catch (Exception e) {
            this.logError(Messages.getString("AccessInput.Log.UnableToOpenFile", "" + this.data.filenr, this.data.file.toString(), e.toString()));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AccessInputMeta)smi;
        this.data = (AccessInputData)sdi;
        if (super.init(smi, sdi)) {
            if (!this.meta.isFileField()) {
                this.data.files = this.meta.getFiles(this);
                if (this.data.files == null || this.data.files.nrOfFiles() == 0) {
                    this.logError(Messages.getString("AccessInput.Log.NoFiles"));
                    return false;
                }
                try {
                    this.data.outputRowMeta = new RowMeta();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (int i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                }
                catch (Exception e) {
                    this.logError(Messages.getString("AccessInput.ErrorInit", e.toString()));
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AccessInputMeta)smi;
        this.data = (AccessInputData)sdi;
        if (this.data.t != null) {
            this.data.t = null;
        }
        if (this.data.rw != null) {
            this.data.rw = null;
        }
        if (this.data.readrow != null) {
            this.data.readrow = null;
        }
        try {
            if (this.data.d != null) {
                this.data.d.close();
                this.data.d = null;
            }
            if (this.data.file != null) {
                this.data.file.close();
                this.data.file = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

