/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.views.threads;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.views.threads.Bundle;
import org.graalvm.visualvm.application.views.threads.PersistenceSupport;
import org.graalvm.visualvm.application.views.threads.ThreadMXBeanDataManager;
import org.graalvm.visualvm.application.views.threads.VisualVMThreadsDataManager;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.DataRemovedListener;
import org.graalvm.visualvm.core.options.GlobalPreferences;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.lib.profiler.api.ActionsSupport;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.ActionPopupButton;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;
import org.graalvm.visualvm.lib.ui.threads.ThreadsPanel;
import org.graalvm.visualvm.threaddump.ThreadDumpSupport;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;
import org.graalvm.visualvm.tools.jmx.JvmMXBeans;
import org.graalvm.visualvm.tools.jmx.JvmMXBeansFactory;
import org.graalvm.visualvm.tools.jmx.MBeanCacheListener;
import org.graalvm.visualvm.uisupport.HTMLTextArea;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

class ApplicationThreadsView
extends DataSourceView
implements DataRemovedListener<Application> {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/application/views/resources/threads.png";
    private static final String DEADLOCK_ALERT_TEXT = NbBundle.getMessage(ApplicationThreadsView.class, (String)"Deadlock_Alert_Text");
    private JvmMXBeans mxbeans;
    private VisualVMThreadsDataManager threadsManager;
    private MBeanCacheListener listener;
    private boolean takeThreadDumpSupported;
    private MasterViewSupport mvs;

    ApplicationThreadsView(DataSource dataSource) {
        super(dataSource, NbBundle.getMessage(ApplicationThreadsView.class, (String)"LBL_Threads"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 30, false);
    }

    protected void willBeAdded() {
        DataSource ds = this.getDataSource();
        if (ds instanceof Application) {
            Application application = (Application)ds;
            Jvm jvm = JvmFactory.getJVMFor((Application)application);
            this.takeThreadDumpSupported = jvm.isTakeThreadDumpSupported();
            this.threadsManager = null;
            JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)application);
            if (jmxModel != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
                this.mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmxModel, (int)(GlobalPreferences.sharedInstance().getThreadsPoll() * 1000));
                if (this.mxbeans != null) {
                    ThreadMXBeanDataManager threadsMXManager = new ThreadMXBeanDataManager(application, this.mxbeans.getThreadMXBean());
                    threadsMXManager.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            ApplicationThreadsView.this.handleThreadsPropertyChange(evt);
                        }
                    });
                    this.threadsManager = threadsMXManager;
                }
            }
        } else {
            this.threadsManager = PersistenceSupport.loadDataManager(ds.getStorage());
        }
    }

    protected synchronized void removed() {
        this.cleanup();
    }

    VisualVMThreadsDataManager getDataManager() {
        return this.threadsManager;
    }

    public synchronized void dataRemoved(Application dataSource) {
        this.cleanup();
    }

    private synchronized void cleanup() {
        if (this.mxbeans != null) {
            this.mxbeans.removeMBeanCacheListener(this.listener);
            this.mxbeans = null;
            this.threadsManager.cleanup();
        }
    }

    protected void setAlert(DataSourceView.Alert newAlert, String newText) {
        super.setAlert(newAlert, newText);
        this.mvs.setAlertText(newText);
    }

    protected DataViewComponent createComponent() {
        DataSource ds = this.getDataSource();
        final Application application = ds instanceof Application ? (Application)ds : null;
        this.mvs = new MasterViewSupport(ds, this.takeThreadDumpSupported, this.threadsManager);
        if (this.mxbeans != null) {
            this.listener = new MBeanCacheListener(){

                public void flushed() {
                    if (application.getState() != 1) {
                        ApplicationThreadsView.this.cleanup();
                    } else {
                        ((ThreadMXBeanDataManager)ApplicationThreadsView.this.threadsManager).refreshThreadsAsync();
                        ApplicationThreadsView.this.mvs.updateThreadsCounts(ApplicationThreadsView.this.threadsManager);
                    }
                }
            };
            this.mxbeans.addMBeanCacheListener(this.listener);
        }
        if (application != null) {
            application.notifyWhenRemoved((DataRemovedListener)this);
        }
        DataViewComponent dvc = new DataViewComponent(this.mvs.getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationThreadsView.class, (String)"LBL_Threads_visualization"), true), 1);
        dvc.addDetailsView(new TimelineViewSupport(this.threadsManager).getDetailsView(), 1);
        return dvc;
    }

    private void handleThreadsPropertyChange(PropertyChangeEvent evt) {
        if ("Deadlock".equals(evt.getPropertyName())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationThreadsView.this.setAlert(DataSourceView.Alert.ERROR, DEADLOCK_ALERT_TEXT);
                }
            });
        }
    }

    private static class TimelineViewSupport
    extends JPanel {
        private ProfilerToolbar toolbar;
        private ThreadsPanel threadsPanel;
        private JLabel shLabel;
        private ActionPopupButton shFilter;
        private JLabel tlLabel;
        private JComponent tlZoomInButton;
        private JComponent tlZoomOutButton;
        private JComponent tlFitWidthButton;

        TimelineViewSupport(VisualVMThreadsDataManager threadsManager) {
            this.initComponents(threadsManager);
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(ApplicationThreadsView.class, (String)"LBL_Timeline"), null, 10, (JComponent)this, null);
        }

        private void initComponents(VisualVMThreadsDataManager threadsManager) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.threadsPanel = new ThreadsPanel(threadsManager, null){

                protected void filterSelected(ThreadsPanel.Filter filter) {
                    super.filterSelected(filter);
                    shFilter.selectAction(filter.ordinal());
                }
            };
            this.threadsPanel.threadsMonitoringEnabled();
            InputMap inputMap = this.getInputMap(1);
            ActionMap actionMap = this.getActionMap();
            String filterKey = "filter-action-key";
            AbstractAction filterAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Action action = threadsPanel.getActionMap().get("filter-action-key");
                    if (action != null && action.isEnabled()) {
                        action.actionPerformed(e);
                    }
                }
            };
            ActionsSupport.registerAction((String)"filter-action-key", (Action)filterAction, (ActionMap)actionMap, (InputMap)inputMap);
            String findKey = "find-action-key";
            AbstractAction findAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Action action = threadsPanel.getActionMap().get("find-action-key");
                    if (action != null && action.isEnabled()) {
                        action.actionPerformed(e);
                    }
                }
            };
            ActionsSupport.registerAction((String)"find-action-key", (Action)findAction, (ActionMap)actionMap, (InputMap)inputMap);
            this.shLabel = new GrayLabel(Bundle.ThreadsFeatureUI_show());
            AbstractAction aAll = new AbstractAction(){
                {
                    this.putValue("Name", Bundle.ThreadsFeatureUI_filterAll());
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setFilter(ThreadsPanel.Filter.ALL);
                }
            };
            AbstractAction aLive = new AbstractAction(){
                {
                    this.putValue("Name", Bundle.ThreadsFeatureUI_filterLive());
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setFilter(ThreadsPanel.Filter.LIVE);
                }
            };
            AbstractAction aFinished = new AbstractAction(){
                {
                    this.putValue("Name", Bundle.ThreadsFeatureUI_filterFinished());
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setFilter(ThreadsPanel.Filter.FINISHED);
                }
            };
            AbstractAction aSelected = new AbstractAction(){
                {
                    this.putValue("Name", Bundle.ThreadsFeatureUI_filterSelected());
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setSelectedFilter();
                }
            };
            this.shFilter = new ActionPopupButton(new Action[]{aAll, aLive, aFinished, aSelected});
            this.shFilter.setToolTipText(Bundle.ThreadsFeatureUI_threadsFilter());
            this.tlLabel = new GrayLabel(Bundle.ThreadsFeatureUI_timeline());
            this.tlZoomInButton = (JComponent)this.threadsPanel.getZoomIn();
            this.tlZoomInButton.putClientProperty("JButton.buttonType", "segmented");
            this.tlZoomInButton.putClientProperty("JButton.segmentPosition", "first");
            this.tlZoomOutButton = (JComponent)this.threadsPanel.getZoomOut();
            this.tlZoomOutButton.putClientProperty("JButton.buttonType", "segmented");
            this.tlZoomOutButton.putClientProperty("JButton.segmentPosition", "middle");
            this.tlFitWidthButton = (JComponent)this.threadsPanel.getFitWidth();
            this.tlFitWidthButton.putClientProperty("JButton.buttonType", "segmented");
            this.tlFitWidthButton.putClientProperty("JButton.segmentPosition", "last");
            this.toolbar = ProfilerToolbar.create((boolean)true);
            this.toolbar.addSpace(5);
            this.toolbar.add((Component)this.shLabel);
            this.toolbar.addSpace(2);
            this.toolbar.add((Component)this.shFilter);
            this.toolbar.addSpace(2);
            this.toolbar.addSeparator();
            this.toolbar.addSpace(5);
            this.toolbar.add((Component)this.tlLabel);
            this.toolbar.addSpace(2);
            this.toolbar.add((Component)this.tlZoomInButton);
            this.toolbar.add((Component)this.tlZoomOutButton);
            this.toolbar.add((Component)this.tlFitWidthButton);
            this.add((Component)this.toolbar.getComponent(), "North");
            this.setFilter(ThreadsPanel.Filter.LIVE);
            this.add((Component)this.threadsPanel, "Center");
        }

        private void setSelectedFilter() {
            if (this.threadsPanel.hasSelectedThreads()) {
                this.setFilter(ThreadsPanel.Filter.SELECTED);
            } else {
                this.threadsPanel.showSelectedColumn();
                this.shFilter.selectAction(this.threadsPanel.getFilter().ordinal());
                ProfilerDialogs.displayWarning((String)Bundle.ThreadsFeatureUI_noThreadsMsg());
            }
        }

        private void setFilter(ThreadsPanel.Filter filter) {
            this.threadsPanel.setFilter(filter);
        }
    }

    private static class MasterViewSupport
    extends JPanel
    implements DataRemovedListener<Application>,
    PropertyChangeListener {
        private Application application;
        private HTMLTextArea area;
        private HTMLTextArea alertArea;
        private JButton threadDumpButton;
        private static final String LIVE_THRADS = NbBundle.getMessage(ApplicationThreadsView.class, (String)"LBL_Live_threads");
        private static final String DAEMON_THREADS = NbBundle.getMessage(ApplicationThreadsView.class, (String)"LBL_Daemon_threads");

        MasterViewSupport(DataSource dataSource, boolean takeThreadDumpSupported, VisualVMThreadsDataManager threadsManager) {
            if (dataSource instanceof Application) {
                this.application = (Application)dataSource;
            }
            this.initComponents(takeThreadDumpSupported);
            this.updateThreadsCounts(threadsManager);
        }

        DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(ApplicationThreadsView.class, (String)"LBL_Threads"), null, (JComponent)this);
        }

        public void dataRemoved(Application dataSource) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    threadDumpButton.setEnabled(false);
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.dataRemoved(this.application);
        }

        private void initComponents(boolean takeThreadDumpSupported) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea();
            this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)this.area, "West");
            this.alertArea = new HTMLTextArea();
            this.alertArea.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.alertArea.setForeground(Color.RED);
            this.add((Component)this.alertArea, "Center");
            this.threadDumpButton = new JButton(new AbstractAction(NbBundle.getMessage(ApplicationThreadsView.class, (String)"LBL_Thread_Dump")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ThreadDumpSupport.getInstance().takeThreadDump(application, (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
                }
            });
            this.threadDumpButton.setEnabled(takeThreadDumpSupported);
            JPanel buttonsArea = new JPanel(new BorderLayout());
            buttonsArea.setOpaque(false);
            JPanel buttonsContainer = new JPanel(new BorderLayout(3, 0));
            buttonsContainer.setBackground(this.area.getBackground());
            buttonsContainer.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            buttonsContainer.add((Component)this.threadDumpButton, "East");
            buttonsArea.add((Component)buttonsContainer, "North");
            this.add((Component)buttonsArea, "After");
            if (this.application != null) {
                this.application.notifyWhenRemoved((DataRemovedListener)this);
                this.application.addPropertyChangeListener("prop_state", WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.application));
            }
        }

        private void updateThreadsCounts(VisualVMThreadsDataManager threadsManager) {
            final int[] threads = new int[]{threadsManager.getThreadCount(), threadsManager.getDaemonThreadCount()};
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.updateThreadsCounts(threads[0], threads[1]);
                }
            });
        }

        private void setAlertText(String alert) {
            int selStart = this.alertArea.getSelectionStart();
            int selEnd = this.alertArea.getSelectionEnd();
            this.alertArea.setText("<center>" + alert + "</center>");
            this.alertArea.select(selStart, selEnd);
        }

        private void updateThreadsCounts(int liveThreads, int daemonThreads) {
            StringBuilder data = new StringBuilder();
            data.append("<b>" + LIVE_THRADS + ":</b> " + liveThreads + "<br>");
            data.append("<b>" + DAEMON_THREADS + ":</b> " + daemonThreads + "<br>");
            int selStart = this.area.getSelectionStart();
            int selEnd = this.area.getSelectionEnd();
            this.area.setText(data.toString());
            this.area.select(selStart, selEnd);
        }
    }
}

