/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.datasupport;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.DataChangeEvent;
import org.graalvm.visualvm.core.datasupport.DataChangeListener;

public final class DataChangeSupport<X> {
    private ChangeSupport<X> changeSupport = new ChangeSupport();

    public void addChangeListener(final DataChangeListener<X> listener) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            @Override
            public void run() {
                DataChangeSupport.this.changeSupport.addChangeListener(listener);
            }
        });
    }

    public void removeChangeListener(final DataChangeListener<X> listener) {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            @Override
            public void run() {
                DataChangeSupport.this.changeSupport.removeChangeListener(listener);
            }
        });
    }

    public void fireChange(Set<X> current, Set<X> added, Set<X> removed) {
        final HashSet<X> currentLocal = current != null ? new HashSet<X>(current) : null;
        final HashSet<X> addedLocal = added != null ? new HashSet<X>(added) : null;
        final HashSet<X> removedLocal = removed != null ? new HashSet<X>(removed) : null;
        DataSource.EVENT_QUEUE.post(new Runnable(){

            @Override
            public void run() {
                DataChangeSupport.this.changeSupport.fireChange(currentLocal, addedLocal, removedLocal);
            }
        });
    }

    private static class ChangeSupport<X> {
        private Set<DataChangeListener<X>> listeners = new HashSet<DataChangeListener<X>>();
        private Set<X> currentSet;

        private ChangeSupport() {
        }

        private void addChangeListener(DataChangeListener<X> listener) {
            if (!this.listeners.add(listener)) {
                throw new IllegalArgumentException("Listener " + listener + " already registed");
            }
            if (this.currentSet != null) {
                DataChangeEvent<X> event = new DataChangeEvent<X>(this.currentSet, this.currentSet, null);
                listener.dataChanged(event);
            }
        }

        private void removeChangeListener(DataChangeListener<X> listener) {
            if (!this.listeners.remove(listener)) {
                throw new IllegalArgumentException("Listener " + listener + " not registered");
            }
        }

        private void fireChange(Set<X> current, Set<X> added, Set<X> removed) {
            this.currentSet = current;
            if (this.listeners.isEmpty()) {
                return;
            }
            DataChangeEvent<X> event = new DataChangeEvent<X>(current, added, removed);
            Iterator<DataChangeListener<X>> it = this.listeners.iterator();
            while (it.hasNext()) {
                it.next().dataChanged(event);
            }
        }
    }
}

