/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.PskClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskClientKeyExchangeSerializer
extends HandshakeMessageSerializer<PskClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PskClientKeyExchangeMessage msg;

    public PskClientKeyExchangeSerializer(PskClientKeyExchangeMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing PSKClientKeyExchangeMessage");
        this.writePskIdentityLength(this.msg);
        this.writePskIdentity(this.msg);
        return this.getAlreadySerialized();
    }

    private void writePskIdentityLength(PskClientKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getIdentityLength().getValue(), 2);
        LOGGER.debug("PskIdentityLength: " + msg.getIdentityLength().getValue());
    }

    private void writePskIdentity(PskClientKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getIdentity().getValue());
        LOGGER.debug("PskIdentity: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getIdentity().getValue())));
    }
}

