/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.loaders.DataObject;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;

public abstract class LoaderTransfer {
    public static final int DND_NONE = 0;
    public static final int DND_COPY = 1;
    public static final int DND_MOVE = 2;
    public static final int DND_COPY_OR_MOVE = 3;
    public static final int DND_LINK = 0x40000000;
    public static final int DND_REFERENCE = 0x40000000;
    public static final int CLIPBOARD_COPY = 1;
    public static final int CLIPBOARD_CUT = 4;
    public static final int COPY = 1;
    public static final int MOVE = 6;
    private static MessageFormat dndMimeType = new MessageFormat("application/x-java-openide-dataobjectdnd;class=org.openide.loaders.DataObject;mask={0}");

    private LoaderTransfer() {
    }

    public static ExTransferable.Single transferable(final DataObject dataObject, int n) {
        return new ExTransferable.Single(LoaderTransfer.createDndFlavor(n)){

            public Object getData() {
                return dataObject;
            }
        };
    }

    public static DataObject getDataObject(Transferable transferable, int n) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        if (dataFlavorArray == null) {
            return null;
        }
        int n2 = dataFlavorArray.length;
        String string = "x-java-openide-dataobjectdnd";
        String string2 = "application";
        String string3 = "mask";
        for (int i = 0; i < n2; ++i) {
            DataFlavor dataFlavor = dataFlavorArray[i];
            if (!dataFlavor.getSubType().equals(string) || !dataFlavor.getPrimaryType().equals(string2)) continue;
            try {
                int n3 = Integer.valueOf(dataFlavor.getParameter(string3));
                if ((n3 & n) == 0) continue;
                DataObject dataObject = (DataObject)transferable.getTransferData(dataFlavor);
                if (dataObject.isValid()) {
                    return dataObject;
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                LoaderTransfer.maybeReportException(numberFormatException);
                continue;
            }
            catch (ClassCastException classCastException) {
                LoaderTransfer.maybeReportException(classCastException);
                continue;
            }
            catch (IOException iOException) {
                DataObject.LOG.fine("Object in clipboard refers to a non existing file. " + iOException.toString());
                continue;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                LoaderTransfer.maybeReportException(unsupportedFlavorException);
            }
        }
        return null;
    }

    public static DataObject[] getDataObjects(Transferable transferable, int n) {
        try {
            if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                int n2 = multiTransferObject.getCount();
                DataObject[] dataObjectArray = new DataObject[n2];
                boolean bl = true;
                for (int i = 0; i < n2; ++i) {
                    DataObject dataObject = LoaderTransfer.getDataObject(multiTransferObject.getTransferableAt(i), n);
                    if (dataObject == null) {
                        bl = false;
                        break;
                    }
                    dataObjectArray[i] = dataObject;
                }
                if (bl && n2 > 0) {
                    return dataObjectArray;
                }
            } else {
                DataObject dataObject = LoaderTransfer.getDataObject(transferable, n);
                if (dataObject != null) {
                    return new DataObject[]{dataObject};
                }
            }
        }
        catch (ClassCastException classCastException) {
            LoaderTransfer.maybeReportException(classCastException);
        }
        catch (IOException iOException) {
            LoaderTransfer.maybeReportException(iOException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            LoaderTransfer.maybeReportException(unsupportedFlavorException);
        }
        return null;
    }

    private static DataFlavor createDndFlavor(int n) {
        try {
            return new DataFlavor(dndMimeType.format(new Object[]{new Integer(n)}), null, DataObject.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
    }

    private static void maybeReportException(Exception exception) {
        Logger.getLogger(LoaderTransfer.class.getName()).log(Level.WARNING, null, exception);
    }
}

