/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;

public class PFont
implements PConstants {
    protected int glyphCount;
    protected Glyph[] glyphs;
    protected String name;
    protected String psname;
    protected int size;
    protected boolean smooth;
    protected int ascent;
    protected int descent;
    protected int[] ascii;
    protected boolean lazy;
    protected Font font;
    protected boolean stream;
    protected boolean subsetting;
    protected boolean fontSearched;
    protected static Font[] fonts;
    protected static HashMap<String, Font> fontDifferent;
    protected BufferedImage lazyImage;
    protected Graphics2D lazyGraphics;
    protected FontMetrics lazyMetrics;
    protected int[] lazySamples;
    protected HashMap<PGraphics, Object> cacheMap;
    static final char[] EXTRA_CHARS;
    public static char[] CHARSET;

    public PFont() {
    }

    public PFont(Font font, boolean bl) {
        this(font, bl, null);
    }

    public PFont(Font font, boolean bl, char[] cArray) {
        this.font = font;
        this.smooth = bl;
        this.name = font.getName();
        this.psname = font.getPSName();
        this.size = font.getSize();
        int n = 10;
        this.glyphs = new Glyph[n];
        this.ascii = new int[128];
        Arrays.fill(this.ascii, -1);
        int n2 = this.size * 3;
        this.lazyImage = new BufferedImage(n2, n2, 1);
        this.lazyGraphics = (Graphics2D)this.lazyImage.getGraphics();
        this.lazyGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.lazyGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, bl ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.lazyGraphics.setFont(font);
        this.lazyMetrics = this.lazyGraphics.getFontMetrics();
        this.lazySamples = new int[n2 * n2];
        if (cArray == null) {
            this.lazy = true;
        } else {
            Arrays.sort(cArray);
            this.glyphs = new Glyph[cArray.length];
            this.glyphCount = 0;
            for (char c : cArray) {
                if (!font.canDisplay(c)) continue;
                Glyph glyph = new Glyph(c);
                if (glyph.value < 128) {
                    this.ascii[glyph.value] = this.glyphCount;
                }
                glyph.index = this.glyphCount;
                this.glyphs[this.glyphCount++] = glyph;
            }
            if (this.glyphCount != cArray.length) {
                this.glyphs = (Glyph[])PApplet.subset(this.glyphs, 0, this.glyphCount);
            }
        }
        if (this.ascent == 0) {
            if (font.canDisplay('d')) {
                new Glyph('d');
            } else {
                this.ascent = this.lazyMetrics.getAscent();
            }
        }
        if (this.descent == 0) {
            if (font.canDisplay('p')) {
                new Glyph('p');
            } else {
                this.descent = this.lazyMetrics.getDescent();
            }
        }
    }

    public PFont(Font font, boolean bl, char[] cArray, boolean bl2) {
        this(font, bl, cArray);
        this.stream = bl2;
    }

    public PFont(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.glyphCount = dataInputStream.readInt();
        int n = dataInputStream.readInt();
        this.size = dataInputStream.readInt();
        dataInputStream.readInt();
        this.ascent = dataInputStream.readInt();
        this.descent = dataInputStream.readInt();
        this.glyphs = new Glyph[this.glyphCount];
        this.ascii = new int[128];
        Arrays.fill(this.ascii, -1);
        for (int i = 0; i < this.glyphCount; ++i) {
            Glyph glyph = new Glyph(dataInputStream);
            if (glyph.value < 128) {
                this.ascii[glyph.value] = i;
            }
            glyph.index = i;
            this.glyphs[i] = glyph;
        }
        if (this.ascent == 0 && this.descent == 0) {
            throw new RuntimeException("Please use \"Create Font\" to re-create this font.");
        }
        for (Glyph glyph : this.glyphs) {
            glyph.readBitmap(dataInputStream);
        }
        if (n >= 10) {
            this.name = dataInputStream.readUTF();
            this.psname = dataInputStream.readUTF();
        }
        if (n == 11) {
            this.smooth = dataInputStream.readBoolean();
        }
        this.findFont();
    }

    void delete() {
        Set<PGraphics> set;
        if (this.cacheMap != null && !(set = this.cacheMap.keySet()).isEmpty()) {
            Object[] objectArray = set.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = this.getCache((PGraphics)objectArray[i]);
                Method method = null;
                try {
                    Class<?> clazz = object.getClass();
                    method = clazz.getMethod("delete", new Class[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (method == null) continue;
                try {
                    method.invoke(object, new Object[0]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        int n;
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(this.glyphCount);
        if (this.name == null || this.psname == null) {
            this.name = "";
            this.psname = "";
        }
        dataOutputStream.writeInt(11);
        dataOutputStream.writeInt(this.size);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(this.ascent);
        dataOutputStream.writeInt(this.descent);
        for (n = 0; n < this.glyphCount; ++n) {
            this.glyphs[n].writeHeader(dataOutputStream);
        }
        for (n = 0; n < this.glyphCount; ++n) {
            this.glyphs[n].writeBitmap(dataOutputStream);
        }
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeUTF(this.psname);
        dataOutputStream.writeBoolean(this.smooth);
        dataOutputStream.flush();
    }

    protected void addGlyph(char c) {
        block4: {
            Glyph glyph;
            block5: {
                block3: {
                    glyph = new Glyph(c);
                    if (this.glyphCount == this.glyphs.length) {
                        this.glyphs = (Glyph[])PApplet.expand(this.glyphs);
                    }
                    if (this.glyphCount != 0) break block3;
                    glyph.index = 0;
                    this.glyphs[this.glyphCount] = glyph;
                    if (glyph.value >= 128) break block4;
                    this.ascii[glyph.value] = 0;
                    break block4;
                }
                if (this.glyphs[this.glyphCount - 1].value >= glyph.value) break block5;
                this.glyphs[this.glyphCount] = glyph;
                if (glyph.value >= 128) break block4;
                this.ascii[glyph.value] = this.glyphCount;
                break block4;
            }
            for (int i = 0; i < this.glyphCount; ++i) {
                if (this.glyphs[i].value <= c) continue;
                for (int j = this.glyphCount; j > i; --j) {
                    this.glyphs[j] = this.glyphs[j - 1];
                    if (this.glyphs[j].value >= 128) continue;
                    this.ascii[this.glyphs[j].value] = j;
                }
                glyph.index = i;
                this.glyphs[i] = glyph;
                if (c >= '\u0080') break;
                this.ascii[c] = i;
                break;
            }
        }
        ++this.glyphCount;
    }

    public String getName() {
        return this.name;
    }

    public String getPostScriptName() {
        return this.psname;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        if (this.subsetting) {
            return null;
        }
        return this.font;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setSubsetting() {
        this.subsetting = true;
    }

    public Font findFont() {
        if (this.font == null && !this.fontSearched) {
            this.font = new Font(this.name, 0, this.size);
            if (!this.font.getPSName().equals(this.psname)) {
                this.font = new Font(this.psname, 0, this.size);
            }
            if (!this.font.getPSName().equals(this.psname)) {
                this.font = null;
            }
            this.fontSearched = true;
        }
        return this.font;
    }

    public Glyph getGlyph(char c) {
        int n = this.index(c);
        return n == -1 ? null : this.glyphs[n];
    }

    protected int index(char c) {
        if (this.lazy) {
            int n = this.indexActual(c);
            if (n != -1) {
                return n;
            }
            if (this.font != null && this.font.canDisplay(c)) {
                this.addGlyph(c);
                return this.indexActual(c);
            }
            return -1;
        }
        return this.indexActual(c);
    }

    protected int indexActual(char c) {
        if (this.glyphCount == 0) {
            return -1;
        }
        if (c < '\u0080') {
            return this.ascii[c];
        }
        return this.indexHunt(c, 0, this.glyphCount - 1);
    }

    protected int indexHunt(int n, int n2, int n3) {
        int n4 = (n2 + n3) / 2;
        if (n == this.glyphs[n4].value) {
            return n4;
        }
        if (n2 >= n3) {
            return -1;
        }
        if (n < this.glyphs[n4].value) {
            return this.indexHunt(n, n2, n4 - 1);
        }
        return this.indexHunt(n, n4 + 1, n3);
    }

    public float kern(char c, char c2) {
        return 0.0f;
    }

    public float ascent() {
        return (float)this.ascent / (float)this.size;
    }

    public float descent() {
        return (float)this.descent / (float)this.size;
    }

    public float width(char c) {
        if (c == ' ') {
            return this.width('i');
        }
        int n = this.index(c);
        if (n == -1) {
            return 0.0f;
        }
        return (float)this.glyphs[n].setWidth / (float)this.size;
    }

    public void setCache(PGraphics pGraphics, Object object) {
        if (this.cacheMap == null) {
            this.cacheMap = new HashMap();
        }
        this.cacheMap.put(pGraphics, object);
    }

    public Object getCache(PGraphics pGraphics) {
        if (this.cacheMap == null) {
            return null;
        }
        return this.cacheMap.get(pGraphics);
    }

    public void removeCache(PGraphics pGraphics) {
        if (this.cacheMap != null) {
            this.cacheMap.remove(pGraphics);
        }
    }

    public int getGlyphCount() {
        return this.glyphCount;
    }

    public Glyph getGlyph(int n) {
        return this.glyphs[n];
    }

    public static String[] list() {
        PFont.loadFonts();
        String[] stringArray = new String[fonts.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = fonts[i].getName();
        }
        return stringArray;
    }

    public static void loadFonts() {
        if (fonts == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            fonts = graphicsEnvironment.getAllFonts();
            if (PApplet.platform == 2) {
                fontDifferent = new HashMap();
                for (Font font : fonts) {
                    fontDifferent.put(font.getName(), font);
                }
            }
        }
    }

    public static Font findFont(String string) {
        Font font;
        PFont.loadFonts();
        if (PApplet.platform == 2 && (font = fontDifferent.get(string)) != null) {
            return font;
        }
        return new Font(string, 0, 1);
    }

    static {
        int n;
        EXTRA_CHARS = new char[]{'\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00ba', '\u00bb', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00ff', '\u0102', '\u0103', '\u0104', '\u0105', '\u0106', '\u0107', '\u010c', '\u010d', '\u010e', '\u010f', '\u0110', '\u0111', '\u0118', '\u0119', '\u011a', '\u011b', '\u0131', '\u0139', '\u013a', '\u013d', '\u013e', '\u0141', '\u0142', '\u0143', '\u0144', '\u0147', '\u0148', '\u0150', '\u0151', '\u0152', '\u0153', '\u0154', '\u0155', '\u0158', '\u0159', '\u015a', '\u015b', '\u015e', '\u015f', '\u0160', '\u0161', '\u0162', '\u0163', '\u0164', '\u0165', '\u016e', '\u016f', '\u0170', '\u0171', '\u0178', '\u0179', '\u017a', '\u017b', '\u017c', '\u017d', '\u017e', '\u0192', '\u02c6', '\u02c7', '\u02d8', '\u02d9', '\u02da', '\u02db', '\u02dc', '\u02dd', '\u03a9', '\u03c0', '\u2013', '\u2014', '\u2018', '\u2019', '\u201a', '\u201c', '\u201d', '\u201e', '\u2020', '\u2021', '\u2022', '\u2026', '\u2030', '\u2039', '\u203a', '\u2044', '\u20ac', '\u2122', '\u2202', '\u2206', '\u220f', '\u2211', '\u221a', '\u221e', '\u222b', '\u2248', '\u2260', '\u2264', '\u2265', '\u25ca', '\uf8ff', '\ufb01', '\ufb02'};
        CHARSET = new char[94 + EXTRA_CHARS.length];
        int n2 = 0;
        for (n = 33; n <= 126; ++n) {
            PFont.CHARSET[n2++] = (char)n;
        }
        for (n = 0; n < EXTRA_CHARS.length; ++n) {
            PFont.CHARSET[n2++] = EXTRA_CHARS[n];
        }
    }

    public class Glyph {
        public PImage image;
        public int value;
        public int height;
        public int width;
        public int index;
        public int setWidth;
        public int topExtent;
        public int leftExtent;

        public Glyph() {
            this.index = -1;
        }

        public Glyph(DataInputStream dataInputStream) throws IOException {
            this.index = -1;
            this.readHeader(dataInputStream);
        }

        protected void readHeader(DataInputStream dataInputStream) throws IOException {
            this.value = dataInputStream.readInt();
            this.height = dataInputStream.readInt();
            this.width = dataInputStream.readInt();
            this.setWidth = dataInputStream.readInt();
            this.topExtent = dataInputStream.readInt();
            this.leftExtent = dataInputStream.readInt();
            dataInputStream.readInt();
            if (this.value == 100 && PFont.this.ascent == 0) {
                PFont.this.ascent = this.topExtent;
            }
            if (this.value == 112 && PFont.this.descent == 0) {
                PFont.this.descent = -this.topExtent + this.height;
            }
        }

        protected void writeHeader(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(this.value);
            dataOutputStream.writeInt(this.height);
            dataOutputStream.writeInt(this.width);
            dataOutputStream.writeInt(this.setWidth);
            dataOutputStream.writeInt(this.topExtent);
            dataOutputStream.writeInt(this.leftExtent);
            dataOutputStream.writeInt(0);
        }

        protected void readBitmap(DataInputStream dataInputStream) throws IOException {
            this.image = new PImage(this.width, this.height, 4);
            int n = this.width * this.height;
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            int n2 = this.width;
            int n3 = this.height;
            int[] nArray = this.image.pixels;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    nArray[i * this.width + j] = byArray[i * n2 + j] & 0xFF;
                }
            }
        }

        protected void writeBitmap(DataOutputStream dataOutputStream) throws IOException {
            int[] nArray = this.image.pixels;
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    dataOutputStream.write(nArray[i * this.width + j] & 0xFF);
                }
            }
        }

        protected Glyph(char c) {
            int n;
            int n2;
            int n3 = PFont.this.size * 3;
            PFont.this.lazyGraphics.setColor(Color.white);
            PFont.this.lazyGraphics.fillRect(0, 0, n3, n3);
            PFont.this.lazyGraphics.setColor(Color.black);
            PFont.this.lazyGraphics.drawString(String.valueOf(c), PFont.this.size, PFont.this.size * 2);
            WritableRaster writableRaster = PFont.this.lazyImage.getRaster();
            writableRaster.getDataElements(0, 0, n3, n3, PFont.this.lazySamples);
            int n4 = 1000;
            int n5 = 0;
            int n6 = 1000;
            int n7 = 0;
            boolean bl = false;
            for (int i = 0; i < n3; ++i) {
                for (n2 = 0; n2 < n3; ++n2) {
                    n = PFont.this.lazySamples[i * n3 + n2] & 0xFF;
                    if (n == 255) continue;
                    if (n2 < n4) {
                        n4 = n2;
                    }
                    if (i < n6) {
                        n6 = i;
                    }
                    if (n2 > n5) {
                        n5 = n2;
                    }
                    if (i > n7) {
                        n7 = i;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                n6 = 0;
                n4 = 0;
                n7 = 0;
                n5 = 0;
            }
            this.value = c;
            this.height = n7 - n6 + 1;
            this.width = n5 - n4 + 1;
            this.setWidth = PFont.this.lazyMetrics.charWidth(c);
            this.topExtent = PFont.this.size * 2 - n6;
            this.leftExtent = n4 - PFont.this.size;
            this.image = new PImage(this.width, this.height, 4);
            int[] nArray = this.image.pixels;
            for (n2 = n6; n2 <= n7; ++n2) {
                for (n = n4; n <= n5; ++n) {
                    int n8 = 255 - (PFont.this.lazySamples[n2 * n3 + n] & 0xFF);
                    int n9 = (n2 - n6) * this.width + (n - n4);
                    nArray[n9] = n8;
                }
            }
            if (this.value == 100 && PFont.this.ascent == 0) {
                PFont.this.ascent = this.topExtent;
            }
            if (this.value == 112 && PFont.this.descent == 0) {
                PFont.this.descent = -this.topExtent + this.height;
            }
        }
    }
}

