/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.CXString;
import org.lwjgl.llvm.CXVersion;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXPlatformAvailability
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PLATFORM;
    public static final int INTRODUCED;
    public static final int DEPRECATED;
    public static final int OBSOLETED;
    public static final int UNAVAILABLE;
    public static final int MESSAGE;

    public CXPlatformAvailability(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXPlatformAvailability.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public CXString Platform() {
        return CXPlatformAvailability.nPlatform(this.address());
    }

    public CXVersion Introduced() {
        return CXPlatformAvailability.nIntroduced(this.address());
    }

    public CXVersion Deprecated() {
        return CXPlatformAvailability.nDeprecated(this.address());
    }

    public CXVersion Obsoleted() {
        return CXPlatformAvailability.nObsoleted(this.address());
    }

    public int Unavailable() {
        return CXPlatformAvailability.nUnavailable(this.address());
    }

    public CXString Message() {
        return CXPlatformAvailability.nMessage(this.address());
    }

    public static CXPlatformAvailability malloc() {
        return (CXPlatformAvailability)CXPlatformAvailability.wrap(CXPlatformAvailability.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXPlatformAvailability calloc() {
        return (CXPlatformAvailability)CXPlatformAvailability.wrap(CXPlatformAvailability.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXPlatformAvailability create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXPlatformAvailability)CXPlatformAvailability.wrap(CXPlatformAvailability.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXPlatformAvailability create(long address) {
        return (CXPlatformAvailability)CXPlatformAvailability.wrap(CXPlatformAvailability.class, (long)address);
    }

    @Nullable
    public static CXPlatformAvailability createSafe(long address) {
        return address == 0L ? null : (CXPlatformAvailability)CXPlatformAvailability.wrap(CXPlatformAvailability.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXPlatformAvailability.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXPlatformAvailability.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXPlatformAvailability.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXPlatformAvailability.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXPlatformAvailability.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXPlatformAvailability.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXPlatformAvailability.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static CXPlatformAvailability mallocStack() {
        return CXPlatformAvailability.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXPlatformAvailability callocStack() {
        return CXPlatformAvailability.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXPlatformAvailability mallocStack(MemoryStack stack) {
        return CXPlatformAvailability.malloc(stack);
    }

    @Deprecated
    public static CXPlatformAvailability callocStack(MemoryStack stack) {
        return CXPlatformAvailability.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXPlatformAvailability.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXPlatformAvailability.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXPlatformAvailability.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXPlatformAvailability.calloc(capacity, stack);
    }

    public static CXPlatformAvailability malloc(MemoryStack stack) {
        return (CXPlatformAvailability)CXPlatformAvailability.wrap(CXPlatformAvailability.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXPlatformAvailability calloc(MemoryStack stack) {
        return (CXPlatformAvailability)CXPlatformAvailability.wrap(CXPlatformAvailability.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CXPlatformAvailability.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CXPlatformAvailability.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static CXString nPlatform(long struct) {
        return CXString.create(struct + (long)PLATFORM);
    }

    public static CXVersion nIntroduced(long struct) {
        return CXVersion.create(struct + (long)INTRODUCED);
    }

    public static CXVersion nDeprecated(long struct) {
        return CXVersion.create(struct + (long)DEPRECATED);
    }

    public static CXVersion nObsoleted(long struct) {
        return CXVersion.create(struct + (long)OBSOLETED);
    }

    public static int nUnavailable(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNAVAILABLE);
    }

    public static CXString nMessage(long struct) {
        return CXString.create(struct + (long)MESSAGE);
    }

    static {
        Struct.Layout layout = CXPlatformAvailability.__struct((Struct.Member[])new Struct.Member[]{CXPlatformAvailability.__member((int)CXString.SIZEOF, (int)CXString.ALIGNOF), CXPlatformAvailability.__member((int)CXVersion.SIZEOF, (int)CXVersion.ALIGNOF), CXPlatformAvailability.__member((int)CXVersion.SIZEOF, (int)CXVersion.ALIGNOF), CXPlatformAvailability.__member((int)CXVersion.SIZEOF, (int)CXVersion.ALIGNOF), CXPlatformAvailability.__member((int)4), CXPlatformAvailability.__member((int)CXString.SIZEOF, (int)CXString.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PLATFORM = layout.offsetof(0);
        INTRODUCED = layout.offsetof(1);
        DEPRECATED = layout.offsetof(2);
        OBSOLETED = layout.offsetof(3);
        UNAVAILABLE = layout.offsetof(4);
        MESSAGE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<CXPlatformAvailability, Buffer>
    implements NativeResource {
        private static final CXPlatformAvailability ELEMENT_FACTORY = CXPlatformAvailability.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXPlatformAvailability getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public CXString Platform() {
            return CXPlatformAvailability.nPlatform(this.address());
        }

        public CXVersion Introduced() {
            return CXPlatformAvailability.nIntroduced(this.address());
        }

        public CXVersion Deprecated() {
            return CXPlatformAvailability.nDeprecated(this.address());
        }

        public CXVersion Obsoleted() {
            return CXPlatformAvailability.nObsoleted(this.address());
        }

        public int Unavailable() {
            return CXPlatformAvailability.nUnavailable(this.address());
        }

        public CXString Message() {
            return CXPlatformAvailability.nMessage(this.address());
        }
    }
}

