/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientConfig;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.CachedOauthTokenRetriever;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.OauthTokenCache;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpAccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.LoginAccessTokenValidator;

public class SaslOauthCredentialProvider
implements BearerAuthCredentialProvider {
    public static final String SASL_IDENTITY_POOL_CONFIG = "extension_identityPoolId";
    private CachedOauthTokenRetriever tokenRetriever;
    private String targetSchemaRegistry;
    private String targetIdentityPoolId;

    @Override
    public String alias() {
        return "SASL_OAUTHBEARER_INHERIT";
    }

    @Override
    public String getBearerToken(URL url) {
        return this.tokenRetriever.getToken();
    }

    @Override
    public String getTargetSchemaRegistry() {
        return this.targetSchemaRegistry;
    }

    @Override
    public String getTargetIdentityPoolId() {
        return this.targetIdentityPoolId;
    }

    public void configure(Map<String, ?> configs) {
        Map<String, Object> updatedConfigs = this.getConfigsForJaasUtil(configs);
        JaasContext jaasContext = JaasContext.loadClientContext(updatedConfigs);
        List appConfigurationEntries = jaasContext.configurationEntries();
        if (Objects.requireNonNull(appConfigurationEntries).size() != 1 || appConfigurationEntries.get(0) == null) {
            throw new ConfigException(String.format("Must supply exactly 1 non-null JAAS mechanism configuration (size was %d)", appConfigurationEntries.size()));
        }
        Map<String, ?> jaasconfig = Collections.unmodifiableMap(((AppConfigurationEntry)appConfigurationEntries.get(0)).getOptions());
        ConfigurationUtils cu = new ConfigurationUtils(configs);
        JaasOptionsUtils jou = new JaasOptionsUtils(jaasconfig);
        this.targetSchemaRegistry = cu.validateString("bearer.auth.logical.cluster");
        this.targetIdentityPoolId = cu.get("bearer.auth.identity.pool.id") != null ? cu.validateString("bearer.auth.identity.pool.id") : jou.validateString(SASL_IDENTITY_POOL_CONFIG);
        this.tokenRetriever = new CachedOauthTokenRetriever();
        this.tokenRetriever.configure(this.getTokenRetriever(cu, jou), this.getTokenValidator(cu, configs), this.getOauthTokenCache(configs));
    }

    private OauthTokenCache getOauthTokenCache(Map<String, ?> map) {
        short cacheExpiryBufferSeconds = SchemaRegistryClientConfig.getBearerAuthCacheExpiryBufferSeconds(map);
        return new OauthTokenCache(cacheExpiryBufferSeconds);
    }

    private AccessTokenRetriever getTokenRetriever(ConfigurationUtils cu, JaasOptionsUtils jou) {
        URL url;
        String clientId = cu.get("bearer.auth.client.id") != null ? cu.validateString("bearer.auth.client.id") : jou.validateString("clientId");
        String clientSecret = cu.get("bearer.auth.client.secret") != null ? cu.validateString("bearer.auth.client.secret") : jou.validateString("clientSecret");
        String scope = cu.get("bearer.auth.scope") != null ? cu.validateString("bearer.auth.scope") : jou.validateString("scope", false);
        Long retryBackoffMs = 100L;
        Long retryBackoffMaxMs = 10000L;
        Integer loginConnectTimeoutMs = null;
        Integer loginReadTimeoutMs = null;
        SSLSocketFactory sslSocketFactory = null;
        URL uRL = url = cu.get("bearer.auth.issuer.endpoint.url") != null ? cu.validateUrl("bearer.auth.issuer.endpoint.url") : cu.validateUrl("sasl.oauthbearer.token.endpoint.url");
        if (jou.shouldCreateSSLSocketFactory(url)) {
            sslSocketFactory = jou.createSSLSocketFactory();
        }
        return new HttpAccessTokenRetriever(clientId, clientSecret, scope, sslSocketFactory, url.toString(), retryBackoffMs.longValue(), retryBackoffMaxMs.longValue(), loginConnectTimeoutMs, loginReadTimeoutMs);
    }

    private AccessTokenValidator getTokenValidator(ConfigurationUtils cu, Map<String, ?> configs) {
        String scopeClaimName = cu.get("sasl.oauthbearer.scope.claim.name") != null ? cu.validateString("sasl.oauthbearer.scope.claim.name") : SchemaRegistryClientConfig.getBearerAuthScopeClaimName(configs);
        String subClaimName = cu.get("sasl.oauthbearer.sub.claim.name") != null ? cu.validateString("sasl.oauthbearer.sub.claim.name") : SchemaRegistryClientConfig.getBearerAuthSubClaimName(configs);
        return new LoginAccessTokenValidator(scopeClaimName, subClaimName);
    }

    Map<String, Object> getConfigsForJaasUtil(Map<String, ?> configs) {
        Object saslJaasConfig;
        HashMap<String, Object> updatedConfigs = new HashMap<String, Object>(configs);
        if (updatedConfigs.containsKey("sasl.jaas.config") && (saslJaasConfig = updatedConfigs.get("sasl.jaas.config")) instanceof String) {
            updatedConfigs.put("sasl.jaas.config", new Password((String)saslJaasConfig));
        }
        return updatedConfigs;
    }
}

