/*
 * Decompiled with CFR 0.152.
 */
package org.nio4r;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.OpenFile;
import org.nio4r.Monitor;
import org.nio4r.Nio4r;

public class Selector
extends RubyObject {
    private static final long serialVersionUID = -14562818539414873L;
    private transient java.nio.channels.Selector selector;
    private HashMap<SelectableChannel, SelectionKey> cancelledKeys;
    private volatile boolean wakeupFired;

    public Selector(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject backends(ThreadContext threadContext, IRubyObject iRubyObject) {
        return threadContext.runtime.newArray((IRubyObject)threadContext.runtime.newSymbol("java"));
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext threadContext) {
        this.initialize(threadContext, (IRubyObject)threadContext.runtime.newSymbol("java"));
        return threadContext.nil;
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject != threadContext.runtime.newSymbol("java") && !iRubyObject.isNil()) {
            throw threadContext.runtime.newArgumentError(":java is the only supported backend");
        }
        this.cancelledKeys = new HashMap();
        this.wakeupFired = false;
        try {
            this.selector = java.nio.channels.Selector.open();
        }
        catch (IOException iOException) {
            throw threadContext.runtime.newIOError(iOException.getLocalizedMessage());
        }
        return threadContext.nil;
    }

    @JRubyMethod
    public IRubyObject backend(ThreadContext threadContext) {
        return threadContext.runtime.newSymbol("java");
    }

    @JRubyMethod
    public IRubyObject close(ThreadContext threadContext) {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            throw threadContext.runtime.newIOError(iOException.getLocalizedMessage());
        }
        return threadContext.nil;
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject isClosed(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        return this.selector.isOpen() ? ruby.getFalse() : ruby.getTrue();
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject isEmpty(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        return this.selector.keys().isEmpty() ? ruby.getTrue() : ruby.getFalse();
    }

    @JRubyMethod
    public IRubyObject register(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        Channel channel = RubyIO.convertToIO((ThreadContext)threadContext, (IRubyObject)iRubyObject).getChannel();
        if (!this.selector.isOpen()) {
            throw threadContext.getRuntime().newIOError("selector is closed");
        }
        if (!(channel instanceof SelectableChannel)) {
            throw ruby.newArgumentError("not a selectable IO object");
        }
        SelectableChannel selectableChannel = (SelectableChannel)channel;
        try {
            selectableChannel.configureBlocking(false);
        }
        catch (IOException iOException) {
            throw ruby.newIOError(iOException.getLocalizedMessage());
        }
        int n = Nio4r.symbolToInterestOps(ruby, selectableChannel, iRubyObject2);
        SelectionKey selectionKey = this.cancelledKeys.remove(selectableChannel);
        if (selectionKey != null) {
            selectionKey.interestOps(n);
        } else {
            try {
                selectionKey = selectableChannel.register(this.selector, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ruby.newArgumentError("mode not supported for this object: " + String.valueOf(iRubyObject2));
            }
            catch (ClosedChannelException closedChannelException) {
                throw threadContext.runtime.newIOError(closedChannelException.getLocalizedMessage());
            }
        }
        RubyClass rubyClass = ruby.getModule("NIO").getClass("Monitor");
        Monitor monitor = (Monitor)rubyClass.newInstance(threadContext, iRubyObject, iRubyObject2, (IRubyObject)this, null);
        monitor.setSelectionKey(selectionKey);
        return monitor;
    }

    @JRubyMethod
    public IRubyObject deregister(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        OpenFile openFile = RubyIO.convertToIO((ThreadContext)threadContext, (IRubyObject)iRubyObject).getOpenFileInitialized();
        if (openFile.fd() == null) {
            return threadContext.nil;
        }
        Channel channel = openFile.channel();
        if (!(channel instanceof SelectableChannel)) {
            throw ruby.newArgumentError("not a selectable IO object");
        }
        SelectableChannel selectableChannel = (SelectableChannel)channel;
        SelectionKey selectionKey = selectableChannel.keyFor(this.selector);
        if (selectionKey == null) {
            return threadContext.nil;
        }
        Monitor monitor = (Monitor)((Object)selectionKey.attachment());
        monitor.close(threadContext, (IRubyObject)ruby.getFalse());
        this.cancelledKeys.put(selectableChannel, selectionKey);
        return monitor;
    }

    @JRubyMethod(name={"registered?"})
    public IRubyObject isRegistered(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        Channel channel = RubyIO.convertToIO((ThreadContext)threadContext, (IRubyObject)iRubyObject).getChannel();
        if (!(channel instanceof SelectableChannel)) {
            throw ruby.newArgumentError("not a selectable IO object");
        }
        SelectableChannel selectableChannel = (SelectableChannel)channel;
        SelectionKey selectionKey = selectableChannel.keyFor(this.selector);
        if (selectionKey == null) {
            return threadContext.nil;
        }
        if (((Monitor)((Object)selectionKey.attachment())).isClosed(threadContext) == ruby.getTrue()) {
            return ruby.getFalse();
        }
        return ruby.getTrue();
    }

    @JRubyMethod
    public synchronized IRubyObject select(ThreadContext threadContext, Block block) {
        return this.select(threadContext, threadContext.nil, block);
    }

    @JRubyMethod
    public synchronized IRubyObject select(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Ruby ruby = threadContext.getRuntime();
        if (!this.selector.isOpen()) {
            throw threadContext.getRuntime().newIOError("selector is closed");
        }
        this.wakeupFired = false;
        int n = this.doSelect(ruby, threadContext, iRubyObject);
        if (n <= 0 && !this.wakeupFired) {
            return threadContext.nil;
        }
        RubyArray rubyArray = null;
        if (!block.isGiven()) {
            rubyArray = ruby.newArray(this.selector.selectedKeys().size());
        }
        Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
        while (iterator.hasNext()) {
            SelectionKey selectionKey = iterator.next();
            this.processKey(selectionKey);
            iterator.remove();
            if (block.isGiven()) {
                block.call(threadContext, (IRubyObject)selectionKey.attachment());
                continue;
            }
            rubyArray.add(selectionKey.attachment());
        }
        if (block.isGiven()) {
            return RubyNumeric.int2fix((Ruby)ruby, (long)n);
        }
        return rubyArray;
    }

    private int doSelect(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject) {
        this.cancelKeys();
        try {
            int n;
            threadContext.getThread().beforeBlockingCall(threadContext);
            if (iRubyObject.isNil()) {
                n = this.selector.select();
            } else {
                double d = RubyNumeric.num2dbl((IRubyObject)iRubyObject);
                if (d == 0.0) {
                    n = this.selector.selectNow();
                } else {
                    if (d < 0.0) {
                        throw ruby.newArgumentError("time interval must be positive");
                    }
                    long l = (long)(d * 1000.0);
                    n = l == 0L ? this.selector.selectNow() : this.selector.select(l);
                }
            }
            threadContext.getThread().afterBlockingCall();
            return n;
        }
        catch (IOException iOException) {
            throw ruby.newIOError(iOException.getLocalizedMessage());
        }
    }

    private void cancelKeys() {
        Iterator<Map.Entry<SelectableChannel, SelectionKey>> iterator = this.cancelledKeys.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<SelectableChannel, SelectionKey> entry = iterator.next();
            SelectionKey selectionKey = entry.getValue();
            selectionKey.cancel();
            iterator.remove();
        }
    }

    private void processKey(SelectionKey selectionKey) {
        if (selectionKey.isValid() && (selectionKey.readyOps() & 8) != 0) {
            int n = selectionKey.interestOps();
            n &= 0xFFFFFFF7;
            selectionKey.interestOps(n |= 4);
        }
    }

    @JRubyMethod
    public IRubyObject wakeup(ThreadContext threadContext) {
        if (!this.selector.isOpen()) {
            throw threadContext.getRuntime().newIOError("selector is closed");
        }
        this.wakeupFired = true;
        this.selector.wakeup();
        return threadContext.nil;
    }
}

