/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.impl.store.raw.data.ByteHolder;
import org.apache.derby.impl.store.raw.data.ByteHolderInputStream;
import org.apache.derby.shared.common.sanity.SanityManager;

public class RememberBytesInputStream
extends FilterInputStream {
    ByteHolder bh;
    boolean recording = true;
    boolean streamClosed = false;

    public RememberBytesInputStream(InputStream in, ByteHolder bh) {
        super(in);
        SanityManager.ASSERT((boolean)bh.writingMode());
        this.bh = bh;
    }

    @Override
    public int read() throws IOException {
        SanityManager.ASSERT((boolean)this.recording, (String)"Must be in record mode to perform a read.");
        int value = -1;
        if (!this.streamClosed) {
            value = super.read();
            if (value != -1) {
                this.bh.write(value);
            } else {
                this.streamClosed = true;
            }
        }
        return value;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        SanityManager.ASSERT((boolean)this.recording, (String)"Must be in record mode to perform a read.");
        if (!this.streamClosed) {
            if (len + off > b.length) {
                len = b.length - off;
            }
            if ((len = super.read(b, off, len)) > 0) {
                this.bh.write(b, off, len);
            } else {
                this.streamClosed = true;
            }
        } else {
            return -1;
        }
        return len;
    }

    public long fillBuf(int len) throws IOException {
        long val = 0L;
        if (!this.streamClosed && (val = this.bh.write(this.in, len)) < (long)len) {
            this.streamClosed = true;
        }
        return val;
    }

    public int putBuf(OutputStream out, int len) throws IOException {
        this.bh.startReading();
        return this.bh.read(out, len);
    }

    @Override
    public long skip(long count) throws IOException {
        SanityManager.ASSERT((boolean)this.recording, (String)"Must be in record mode to perform a read.");
        return this.bh.write(this.in, count);
    }

    public InputStream getReplayStream() throws IOException {
        this.bh.startReading();
        this.recording = false;
        return new ByteHolderInputStream(this.bh);
    }

    public ByteHolder getByteHolder() throws IOException {
        return this.bh;
    }

    public void clear() throws IOException {
        this.bh.clear();
        this.recording = true;
    }

    public void setInput(InputStream in) {
        this.in = in;
        this.streamClosed = false;
    }

    public boolean recording() {
        return this.recording;
    }

    @Override
    public int available() throws IOException {
        int remainingBytes = this.bh.available();
        remainingBytes = remainingBytes > 0 ? remainingBytes : -1 * remainingBytes;
        return remainingBytes;
    }

    public int numBytesSaved() throws IOException {
        return this.bh.numBytesSaved();
    }

    public int shiftToFront() throws IOException {
        int bytesShifted = this.bh.shiftToFront();
        return bytesShifted;
    }

    public String toString() {
        return "RememberBytesInputStream:  recording: " + this.recording + " " + this.bh;
    }
}

