/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.util.InterruptDetectedException;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.RAFContainer;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class RAFContainer4
extends RAFContainer {
    private FileChannel ourChannel = null;
    private final Object channelCleanupMonitor = new Object();
    private volatile int threadsInPageIO = 0;
    private volatile boolean restoreChannelInProgress = false;
    private boolean giveUpIO = false;
    private final Object giveUpIOm = new Object();
    private int iosInProgress = 0;
    private ContainerKey currentIdentity;

    public RAFContainer4(BaseDataFileFactory factory) {
        super(factory);
    }

    private FileChannel getChannel(StorageRandomAccessFile file) {
        if (file instanceof RandomAccessFile) {
            return ((RandomAccessFile)((Object)file)).getChannel();
        }
        return null;
    }

    private FileChannel getChannel() {
        if (this.ourChannel == null) {
            this.ourChannel = this.getChannel(this.fileData);
        }
        return this.ourChannel;
    }

    @Override
    synchronized boolean openContainer(ContainerKey newIdentity) throws StandardException {
        SanityManager.ASSERT((this.iosInProgress == 0 ? 1 : 0) != 0, (String)"Container opened while IO operations are in progress. This should not happen.");
        SanityManager.ASSERT((this.fileData == null ? 1 : 0) != 0, (String)"fileData isn't null");
        SanityManager.ASSERT((this.ourChannel == null ? 1 : 0) != 0, (String)"ourChannel isn't null");
        this.currentIdentity = newIdentity;
        return super.openContainer(newIdentity);
    }

    @Override
    synchronized void createContainer(ContainerKey newIdentity) throws StandardException {
        SanityManager.ASSERT((this.iosInProgress == 0 ? 1 : 0) != 0, (String)"Container created while IO operations are in progress. This should not happen.");
        SanityManager.ASSERT((this.fileData == null ? 1 : 0) != 0, (String)"fileData isn't null");
        SanityManager.ASSERT((this.ourChannel == null ? 1 : 0) != 0, (String)"ourChannel isn't null");
        this.currentIdentity = newIdentity;
        super.createContainer(newIdentity);
    }

    private void reopen() throws StandardException {
        SanityManager.ASSERT((!this.ourChannel.isOpen() ? 1 : 0) != 0);
        this.ourChannel = null;
        this.reopenContainer(this.currentIdentity);
    }

    @Override
    synchronized void closeContainer() {
        SanityManager.ASSERT((this.iosInProgress == 0 || this.getCommittedDropState() ? 1 : 0) != 0, (String)"Container closed while IO operations are in progress.  This should not happen.");
        if (this.ourChannel != null) {
            try {
                this.ourChannel.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.ourChannel = null;
            }
        }
        super.closeContainer();
    }

    @Override
    protected void readPage(long pageNumber, byte[] pageData) throws IOException, StandardException {
        this.readPage(pageNumber, pageData, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPage(long pageNumber, byte[] pageData, long offset) throws IOException, StandardException {
        int retries;
        boolean stealthMode;
        boolean holdsThis = Thread.holdsLock(this);
        boolean holdsAllocCache = Thread.holdsLock(this.allocCache);
        boolean bl = stealthMode = holdsThis || holdsAllocCache;
        if (pageNumber == -1L) {
            if (!holdsThis) {
                new Throwable().printStackTrace(SanityManager.GET_DEBUG_STREAM());
            }
            SanityManager.ASSERT((boolean)holdsThis);
        }
        if (holdsThis) {
            SanityManager.ASSERT((pageNumber == -1L ? 1 : 0) != 0);
        }
        if (!stealthMode) {
            Object object = this.channelCleanupMonitor;
            synchronized (object) {
                retries = 120;
                while (this.restoreChannelInProgress) {
                    if (retries-- == 0) {
                        throw StandardException.newException((String)"XSDG9.D", (Object[])new Object[0]);
                    }
                    try {
                        this.channelCleanupMonitor.wait(500L);
                    }
                    catch (InterruptedException e) {
                        InterruptStatus.setInterrupted();
                    }
                }
                ++this.threadsInPageIO;
            }
        }
        boolean success = false;
        retries = 120;
        try {
            while (!success) {
                try {
                    if (pageNumber == 0L) {
                        RAFContainer4 e = this;
                        synchronized (e) {
                            this.readPage0(pageNumber, pageData, offset);
                        }
                    } else {
                        this.readPage0(pageNumber, pageData, offset);
                    }
                    success = true;
                }
                catch (ClosedChannelException e) {
                    this.handleClosedChannel(e, stealthMode, retries--);
                }
            }
        }
        finally {
            if (!stealthMode) {
                Object object = this.channelCleanupMonitor;
                synchronized (object) {
                    --this.threadsInPageIO;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPage0(long pageNumber, byte[] pageData, long offset) throws IOException, StandardException {
        FileChannel ioChannel;
        RAFContainer4 rAFContainer4 = this;
        synchronized (rAFContainer4) {
            if (pageNumber != -1L) {
                SanityManager.ASSERT((!this.getCommittedDropState() ? 1 : 0) != 0);
            }
            ioChannel = this.getChannel();
        }
        if (pageNumber == -1L || pageNumber == 0L) {
            SanityManager.ASSERT((boolean)Thread.holdsLock(this));
        } else {
            SanityManager.ASSERT((!Thread.holdsLock(this) ? 1 : 0) != 0);
        }
        if (ioChannel != null) {
            RAFContainer4 rAFContainer42;
            long pageOffset = pageNumber * (long)this.pageSize;
            ByteBuffer pageBuf = ByteBuffer.wrap(pageData);
            try {
                rAFContainer42 = this;
                synchronized (rAFContainer42) {
                    ++this.iosInProgress;
                }
                if (offset == -1L) {
                    this.readFull(pageBuf, ioChannel, pageOffset);
                } else {
                    SanityManager.ASSERT((pageNumber == -1L ? 1 : 0) != 0);
                    this.readFull(pageBuf, ioChannel, offset);
                }
            }
            finally {
                rAFContainer42 = this;
                synchronized (rAFContainer42) {
                    --this.iosInProgress;
                }
            }
            if (this.dataFactory.databaseEncrypted() && pageNumber != 0L && pageNumber != -1L) {
                this.decryptPage(pageData, this.pageSize);
            }
        } else {
            super.readPage(pageNumber, pageData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writePage(long pageNumber, byte[] pageData, boolean syncPage) throws IOException, StandardException {
        int retries;
        boolean stealthMode = Thread.holdsLock(this.allocCache);
        SanityManager.ASSERT((!Thread.holdsLock(this) ? 1 : 0) != 0);
        if (!stealthMode) {
            Object object = this.channelCleanupMonitor;
            synchronized (object) {
                retries = 120;
                while (this.restoreChannelInProgress) {
                    if (retries-- == 0) {
                        throw StandardException.newException((String)"XSDG9.D", (Object[])new Object[0]);
                    }
                    try {
                        this.channelCleanupMonitor.wait(500L);
                    }
                    catch (InterruptedException e) {
                        InterruptStatus.setInterrupted();
                    }
                }
                ++this.threadsInPageIO;
            }
        }
        boolean success = false;
        retries = 120;
        try {
            while (!success) {
                try {
                    if (pageNumber == 0L) {
                        RAFContainer4 e = this;
                        synchronized (e) {
                            this.writePage0(pageNumber, pageData, syncPage);
                        }
                    } else {
                        this.writePage0(pageNumber, pageData, syncPage);
                    }
                    success = true;
                }
                catch (ClosedChannelException e) {
                    this.handleClosedChannel(e, stealthMode, retries--);
                }
            }
        }
        finally {
            if (!stealthMode) {
                Object object = this.channelCleanupMonitor;
                synchronized (object) {
                    --this.threadsInPageIO;
                }
            }
        }
    }

    private void handleClosedChannel(ClosedChannelException e, boolean stealthMode, int retries) throws StandardException {
        if (e instanceof AsynchronousCloseException) {
            if (Thread.currentThread().isInterrupted() && this.recoverContainerAfterInterrupt(e.toString(), stealthMode)) {
                return;
            }
            this.awaitRestoreChannel(e, stealthMode);
        } else {
            InterruptStatus.noteAndClearInterrupt("ClosedChannelException", this.threadsInPageIO, this.hashCode());
            this.awaitRestoreChannel(e, stealthMode);
            if (retries == 0) {
                throw StandardException.newException((String)"XSDG9.D", (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitRestoreChannel(Exception e, boolean stealthMode) throws StandardException {
        if (stealthMode) {
            RAFContainer4.debugTrace("thread does stealth mode retry");
            Object object = this.giveUpIOm;
            synchronized (object) {
                if (this.giveUpIO) {
                    RAFContainer4.debugTrace("giving up retry, another thread gave up resurrecting container ");
                    throw StandardException.newException((String)"XSDG9.D", (Object[])new Object[0]);
                }
            }
            throw new InterruptDetectedException();
        }
        Object object = this.channelCleanupMonitor;
        synchronized (object) {
            --this.threadsInPageIO;
        }
        int timesWaited = -1;
        Object object2 = this.channelCleanupMonitor;
        synchronized (object2) {
            while (this.restoreChannelInProgress) {
                RAFContainer4.debugTrace("thread needs to wait for container recovery: already waited " + ++timesWaited + " times");
                if (timesWaited > 120) {
                    throw StandardException.newException((String)"XSDG9.D", (Throwable)e, (Object[])new Object[0]);
                }
                try {
                    this.channelCleanupMonitor.wait(500L);
                }
                catch (InterruptedException we) {
                    InterruptStatus.setInterrupted();
                }
            }
            ++this.threadsInPageIO;
        }
        object2 = this.giveUpIOm;
        synchronized (object2) {
            if (this.giveUpIO) {
                RAFContainer4.debugTrace("giving up retry, another thread gave up resurrecting container ");
                --this.threadsInPageIO;
                throw StandardException.newException((String)"XSDG9.D", (Object[])new Object[0]);
            }
        }
        if (timesWaited == -1) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException we) {
                InterruptStatus.setInterrupted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recoverContainerAfterInterrupt(String whence, boolean stealthMode) throws StandardException {
        Object object;
        if (stealthMode && this.restoreChannelInProgress) {
            InterruptStatus.noteAndClearInterrupt(whence, this.threadsInPageIO, this.hashCode());
            return false;
        }
        Object object2 = this.channelCleanupMonitor;
        synchronized (object2) {
            if (this.restoreChannelInProgress) {
                InterruptStatus.noteAndClearInterrupt(whence, this.threadsInPageIO, this.hashCode());
                return false;
            }
            if (!stealthMode) {
                --this.threadsInPageIO;
            }
            this.restoreChannelInProgress = true;
        }
        int retries = 120;
        while (true) {
            object = this.channelCleanupMonitor;
            synchronized (object) {
                if (this.threadsInPageIO == 0) {
                    break;
                }
                if (retries-- == 0) {
                    this.restoreChannelInProgress = false;
                    this.channelCleanupMonitor.notifyAll();
                    throw StandardException.newException((String)"XSDG9.D", (Object[])new Object[0]);
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException te) {
                InterruptStatus.setInterrupted();
            }
        }
        object = this.channelCleanupMonitor;
        synchronized (object) {
            try {
                InterruptStatus.noteAndClearInterrupt(whence, this.threadsInPageIO, this.hashCode());
                RAFContainer4 rAFContainer4 = this;
                synchronized (rAFContainer4) {
                    SanityManager.ASSERT((this.ourChannel != null ? 1 : 0) != 0, (String)"ourChannel is null");
                    SanityManager.ASSERT((!this.ourChannel.isOpen() ? 1 : 0) != 0, (String)"ourChannel is open");
                }
                rAFContainer4 = this;
                synchronized (rAFContainer4) {
                    try {
                        this.reopen();
                    }
                    catch (Exception newE) {
                        Object object3 = this.giveUpIOm;
                        synchronized (object3) {
                            this.giveUpIO = true;
                            RAFContainer4.debugTrace("can't resurrect container: " + newE);
                            throw StandardException.newException((String)"XSDG9.D", (Throwable)newE, (Object[])new Object[0]);
                        }
                    }
                }
                if (stealthMode) {
                } else {
                    ++this.threadsInPageIO;
                }
            }
            finally {
                this.restoreChannelInProgress = false;
                this.channelCleanupMonitor.notifyAll();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writePage0(long pageNumber, byte[] pageData, boolean syncPage) throws IOException, StandardException {
        FileChannel ioChannel;
        RAFContainer4 rAFContainer4 = this;
        synchronized (rAFContainer4) {
            if (this.getCommittedDropState()) {
                return;
            }
            ioChannel = this.getChannel();
        }
        if (pageNumber == 0L) {
            SanityManager.ASSERT((boolean)Thread.holdsLock(this));
        } else {
            SanityManager.ASSERT((!Thread.holdsLock(this) ? 1 : 0) != 0);
        }
        if (ioChannel != null) {
            RAFContainer4 rAFContainer42;
            byte[] dataToWrite;
            long pageOffset = pageNumber * (long)this.pageSize;
            byte[] encryptionBuf = null;
            if (this.dataFactory.databaseEncrypted()) {
                encryptionBuf = new byte[this.pageSize];
            }
            SanityManager.ASSERT(((dataToWrite = this.updatePageArray(pageNumber, pageData, encryptionBuf, false)) != null ? 1 : 0) != 0, (String)"RAFContainer4: dataToWrite is null after updatePageArray()");
            ByteBuffer writeBuffer = ByteBuffer.wrap(dataToWrite);
            this.dataFactory.writeInProgress();
            try {
                rAFContainer42 = this;
                synchronized (rAFContainer42) {
                    ++this.iosInProgress;
                }
                this.writeFull(writeBuffer, ioChannel, pageOffset);
            }
            catch (ClosedChannelException ioe) {
                RAFContainer4 rAFContainer43 = this;
                synchronized (rAFContainer43) {
                    block47: {
                        if (!this.getCommittedDropState()) break block47;
                        RAFContainer4.debugTrace("write to a dropped and closed container discarded.");
                        return;
                    }
                    throw ioe;
                }
            }
            finally {
                RAFContainer4 rAFContainer44 = this;
                synchronized (rAFContainer44) {
                    --this.iosInProgress;
                }
                this.dataFactory.writeFinished();
            }
            if (syncPage) {
                this.dataFactory.writeInProgress();
                try {
                    rAFContainer42 = this;
                    synchronized (rAFContainer42) {
                        ++this.iosInProgress;
                    }
                    if (this.dataFactory.dataNotSyncedAtAllocation) return;
                    ioChannel.force(false);
                    return;
                }
                finally {
                    rAFContainer42 = this;
                    synchronized (rAFContainer42) {
                        --this.iosInProgress;
                    }
                    this.dataFactory.writeFinished();
                }
            }
            rAFContainer42 = this;
            synchronized (rAFContainer42) {
                this.needsSync = true;
                return;
            }
        }
        super.writePage(pageNumber, pageData, syncPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void writeAtOffset(StorageRandomAccessFile file, byte[] bytes, long offset) throws IOException, StandardException {
        FileChannel ioChannel = this.getChannel(file);
        if (ioChannel == null) {
            super.writeAtOffset(file, bytes, offset);
            return;
        }
        this.ourChannel = ioChannel;
        boolean success = false;
        boolean stealthMode = true;
        while (!success) {
            RAFContainer4 rAFContainer4 = this;
            synchronized (rAFContainer4) {
                ioChannel = this.getChannel();
            }
            try {
                this.writeFull(ByteBuffer.wrap(bytes), ioChannel, offset);
                success = true;
            }
            catch (ClosedChannelException e) {
                this.handleClosedChannel(e, true, -1);
            }
        }
    }

    @Override
    byte[] getEmbryonicPage(StorageRandomAccessFile file, long offset) throws IOException, StandardException {
        FileChannel ioChannel = this.getChannel(file);
        if (ioChannel != null) {
            byte[] buffer = new byte[204];
            this.readPage(-1L, buffer, offset);
            return buffer;
        }
        return super.getEmbryonicPage(file, offset);
    }

    private void readFull(ByteBuffer dstBuffer, FileChannel srcChannel, long position) throws IOException, StandardException {
        while (dstBuffer.remaining() > 0) {
            if (srcChannel.read(dstBuffer, position + (long)dstBuffer.position()) == -1) {
                throw new EOFException("Reached end of file while attempting to read a whole page.");
            }
            if (!Thread.currentThread().isInterrupted() || srcChannel.isOpen()) continue;
            throw new ClosedByInterruptException();
        }
    }

    private void writeFull(ByteBuffer srcBuffer, FileChannel dstChannel, long position) throws IOException {
        while (srcBuffer.remaining() > 0) {
            dstChannel.write(srcBuffer, position + (long)srcBuffer.position());
            if (!Thread.currentThread().isInterrupted() || dstChannel.isOpen()) continue;
            throw new ClosedByInterruptException();
        }
    }

    private static void debugTrace(String msg) {
        if (SanityManager.DEBUG_ON((String)"RAF4")) {
            SanityManager.DEBUG_PRINT((String)"RAF4", (String)(Thread.currentThread().getName() + " " + msg));
        }
    }
}

