/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.monitor.DerbyObservable;
import org.apache.derby.iapi.services.monitor.DerbyObserver;
import org.apache.derby.iapi.store.access.SpaceInfo;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.AllocationActions;
import org.apache.derby.impl.store.raw.data.BaseContainer;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.DropOnCommit;
import org.apache.derby.impl.store.raw.data.PageActions;
import org.apache.derby.impl.store.raw.data.RecordId;
import org.apache.derby.impl.store.raw.data.SyncOnCommit;
import org.apache.derby.impl.store.raw.data.TruncateOnCommit;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class BaseContainerHandle
extends DerbyObservable
implements RawContainerHandle,
DerbyObserver {
    private ContainerKey identity;
    private boolean active;
    protected BaseContainer container;
    private LockingPolicy locking;
    private RawTransaction xact;
    private boolean forUpdate;
    private int mode;
    private PageActions actionsSet;
    private AllocationActions allocActionsSet;

    public BaseContainerHandle(UUID rawStoreId, RawTransaction xact, ContainerKey identity, LockingPolicy locking, int mode) {
        this.identity = identity;
        this.xact = xact;
        this.locking = locking;
        this.mode = mode;
        this.forUpdate = (mode & 4) == 4;
    }

    public BaseContainerHandle(UUID rawStoreId, RawTransaction xact, PageActions actionsSet, AllocationActions allocActionsSet, LockingPolicy locking, BaseContainer container, int mode) {
        this(rawStoreId, xact, (ContainerKey)container.getIdentity(), locking, mode);
        this.actionsSet = actionsSet;
        this.allocActionsSet = allocActionsSet;
        this.container = container;
    }

    @Override
    public Page addPage() throws StandardException {
        this.checkUpdateOpen();
        Page page = this.container.addPage(this, false);
        return page;
    }

    @Override
    public void compressContainer() throws StandardException {
        this.checkUpdateOpen();
        this.container.compressContainer(this);
    }

    @Override
    public long getReusableRecordIdSequenceNumber() throws StandardException {
        this.checkOpen();
        return this.container.getReusableRecordIdSequenceNumber();
    }

    @Override
    public Page addPage(int flag) throws StandardException {
        if ((flag & 2) != 0 && this.active && this.forUpdate) {
            this.container.clearPreallocThreshold();
        }
        return this.addPage();
    }

    @Override
    public void preAllocate(int numPage) {
        if (numPage > 0 && this.active && this.forUpdate) {
            this.container.prepareForBulkLoad(this, numPage);
        }
    }

    @Override
    public void getContainerProperties(Properties prop) throws StandardException {
        this.checkOpen();
        this.container.getContainerProperties(prop);
    }

    @Override
    public void removePage(Page page) throws StandardException {
        if (!this.active) {
            if (page != null) {
                page.unlatch();
            }
            throw StandardException.newException((String)"40XD0", (Object[])new Object[0]);
        }
        if (!this.forUpdate) {
            if (page != null) {
                page.unlatch();
            }
            throw StandardException.newException((String)"40XD1", (Object[])new Object[0]);
        }
        this.container.removePage(this, (BasePage)page);
    }

    @Override
    public Page getPage(long pageNumber) throws StandardException {
        this.checkOpen();
        return this.container.getPage(this, pageNumber, true);
    }

    public Page getAllocPage(long pageNumber) throws StandardException {
        this.checkOpen();
        return this.container.getAllocPage(this, pageNumber, true);
    }

    @Override
    public Page getUserPageNoWait(long pageNumber) throws StandardException {
        this.checkOpen();
        return this.container.getHeadPage(this, pageNumber, false);
    }

    @Override
    public Page getUserPageWait(long pageNumber) throws StandardException {
        this.checkOpen();
        return this.container.getHeadPage(this, pageNumber, true);
    }

    @Override
    public Page getPageNoWait(long pageNumber) throws StandardException {
        this.checkOpen();
        return this.container.getPage(this, pageNumber, false);
    }

    @Override
    public Page getFirstPage() throws StandardException {
        this.checkOpen();
        return this.container.getFirstPage(this);
    }

    @Override
    public Page getNextPage(long pageNumber) throws StandardException {
        this.checkOpen();
        return this.container.getNextPage(this, pageNumber);
    }

    @Override
    public Page getPageForInsert(int flag) throws StandardException {
        this.checkUpdateOpen();
        return this.container.getPageForInsert(this, flag);
    }

    @Override
    public Page getPageForCompress(int flag, long pageno) throws StandardException {
        this.checkUpdateOpen();
        return this.container.getPageForCompress(this, flag, pageno);
    }

    @Override
    public final boolean isReadOnly() {
        return !this.forUpdate;
    }

    @Override
    public synchronized void close() {
        if (this.xact == null) {
            return;
        }
        this.informObservers();
        this.active = false;
        this.getLockingPolicy().unlockContainer(this.xact, this);
        if (this.container != null) {
            this.container.letGo(this);
            this.container = null;
        }
        this.xact.deleteObserver(this);
        this.xact = null;
    }

    @Override
    public long getEstimatedRowCount(int flag) throws StandardException {
        this.checkOpen();
        return this.container.getEstimatedRowCount(flag);
    }

    @Override
    public void setEstimatedRowCount(long count, int flag) throws StandardException {
        this.checkOpen();
        this.container.setEstimatedRowCount(count, flag);
    }

    @Override
    public long getEstimatedPageCount(int flag) throws StandardException {
        this.checkOpen();
        return this.container.getEstimatedPageCount(this, flag);
    }

    @Override
    public void flushContainer() throws StandardException {
        this.checkUpdateOpen();
        this.container.flushAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compactRecord(RecordHandle record) throws StandardException {
        if (!this.forUpdate) {
            throw StandardException.newException((String)"40XD1", (Object[])new Object[0]);
        }
        PageKey pkey = (PageKey)record.getPageId();
        BasePage headPage = (BasePage)this.getPage(pkey.getPageNumber());
        if (headPage != null) {
            try {
                headPage.compactRecord(record);
            }
            finally {
                headPage.unlatch();
            }
        }
    }

    @Override
    public int getContainerStatus() throws StandardException {
        this.checkOpen();
        return this.container.getContainerStatus();
    }

    @Override
    public void removeContainer(LogInstant instant) throws StandardException {
        this.checkUpdateOpen();
        this.container.removeContainer(instant, true);
    }

    @Override
    public ContainerKey getId() {
        return this.identity;
    }

    @Override
    public Object getUniqueId() {
        return this;
    }

    @Override
    public void dropContainer(LogInstant instant, boolean drop) throws StandardException {
        this.checkUpdateOpen();
        this.container.dropContainer(instant, drop);
    }

    @Override
    public long getContainerVersion() throws StandardException {
        this.checkOpen();
        return this.container.getContainerVersion();
    }

    @Override
    public Page getAnyPage(long pageNumber) throws StandardException {
        this.checkOpen();
        return this.container.getAnyPage(this, pageNumber, true);
    }

    @Override
    public Page reCreatePageForRedoRecovery(int pageFormat, long pageNumber, long pageOffset) throws StandardException {
        this.checkUpdateOpen();
        return this.container.reCreatePageForRedoRecovery(this, pageFormat, pageNumber, pageOffset);
    }

    @Override
    public ByteArray logCreateContainerInfo() throws StandardException {
        this.checkUpdateOpen();
        return this.container.logCreateContainerInfo();
    }

    @Override
    public RecordHandle makeRecordHandle(long pageNumber, int recordId) throws StandardException {
        return new RecordId(this.identity, pageNumber, recordId);
    }

    @Override
    public void update(DerbyObservable obj, Object arg) {
        if (arg == null) {
            SanityManager.THROWASSERT((String)("still on observr list " + this));
        }
        if (this.xact == null) {
            return;
        }
        if (obj != this.xact) {
            SanityManager.THROWASSERT((String)("Observable passed to update is incorrect expected " + this.xact + " got " + obj));
        }
        if (arg.equals(RawTransaction.COMMIT) || arg.equals(RawTransaction.ABORT) || arg.equals(this.identity)) {
            this.close();
            return;
        }
        if (arg.equals(RawTransaction.SAVEPOINT_ROLLBACK)) {
            this.informObservers();
            return;
        }
        if (arg.equals(RawTransaction.LOCK_ESCALATE)) {
            if (this.getLockingPolicy().getMode() != 1) {
                return;
            }
            try {
                this.getLockingPolicy().lockContainer(this.getTransaction(), this, false, this.forUpdate);
            }
            catch (StandardException se) {
                this.xact.setObserverException(se);
            }
        }
    }

    public PageActions getActionSet() {
        return this.actionsSet;
    }

    public AllocationActions getAllocationActionSet() {
        return this.allocActionsSet;
    }

    public boolean useContainer(boolean droppedOK, boolean waitForLock) throws StandardException {
        SanityManager.ASSERT((!this.active ? 1 : 0) != 0);
        boolean gotLock = this.getLockingPolicy().lockContainer(this.getTransaction(), this, waitForLock, this.forUpdate);
        if (!gotLock) {
            SanityManager.ASSERT((!waitForLock ? 1 : 0) != 0, (String)"lockContainer wait returns false");
            this.container = null;
            throw StandardException.newException((String)"40XL1", (Object[])new Object[0]);
        }
        if ((this.mode & 0x40) == 0) {
            SanityManager.ASSERT((this.container != null ? 1 : 0) != 0);
            if (!this.container.use(this, this.forUpdate, droppedOK)) {
                this.getLockingPolicy().unlockContainer(this.xact, this);
                this.container = null;
                return false;
            }
            this.active = true;
        } else if (this.getLockingPolicy().getMode() != 1) {
            return true;
        }
        this.xact.addObserver(this);
        if ((this.mode & 0x408) == 0) {
            if ((this.mode & 0x10) == 16) {
                this.xact.addObserver(new TruncateOnCommit(this.identity, true));
            } else if ((this.mode & 0x100) == 256) {
                this.xact.addObserver(new TruncateOnCommit(this.identity, false));
            }
            if ((this.mode & 0x20) == 32) {
                this.xact.addObserver(new DropOnCommit(this.identity));
            }
            if ((this.mode & 0x200) == 512) {
                this.xact.addObserver(new SyncOnCommit(this.identity));
            }
        }
        return true;
    }

    public final RawTransaction getTransaction() {
        return this.xact;
    }

    @Override
    public final LockingPolicy getLockingPolicy() {
        SanityManager.ASSERT((this.locking != null ? 1 : 0) != 0);
        return this.locking;
    }

    @Override
    public final void setLockingPolicy(LockingPolicy newLockingPolicy) {
        this.locking = newLockingPolicy;
    }

    public final boolean updateOK() {
        return this.forUpdate;
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public void preDirty(boolean preDirtyOn) throws StandardException {
        this.checkUpdateOpen();
        this.container.preDirty(preDirtyOn);
    }

    @Override
    public boolean isTemporaryContainer() throws StandardException {
        this.checkOpen();
        return this.identity != null && this.identity.getSegmentId() == -1L;
    }

    protected void checkOpen() throws StandardException {
        if (!this.active) {
            throw StandardException.newException((String)"40XD0", (Object[])new Object[0]);
        }
    }

    private void checkUpdateOpen() throws StandardException {
        if (!this.active) {
            throw StandardException.newException((String)"40XD0", (Object[])new Object[0]);
        }
        if (!this.forUpdate) {
            throw StandardException.newException((String)"40XD1", (Object[])new Object[0]);
        }
    }

    protected void informObservers() {
        if (this.countObservers() != 0) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    @Override
    public SpaceInfo getSpaceInfo() throws StandardException {
        return this.container.getSpaceInfo(this);
    }

    @Override
    public void backupContainer(String backupContainerPath) throws StandardException {
        this.checkOpen();
        this.container.backupContainer(this, backupContainerPath);
    }

    @Override
    public void encryptOrDecryptContainer(String newFilePath, boolean doEncrypt) throws StandardException {
        this.checkOpen();
        this.container.encryptOrDecryptContainer(this, newFilePath, doEncrypt);
    }

    public String toString() {
        String str = "BaseContainerHandle:(" + this.identity.toString() + ")";
        return str;
    }
}

