/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedByteCode;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.Row;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.SQLSessionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.ResultSetFactory;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.DMLWriteGeneratedColumnsResultSet;
import org.apache.derby.impl.sql.execute.RowResultSet;
import org.apache.derby.impl.sql.execute.UnionResultSet;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.util.ArrayUtil;

public abstract class BaseActivation
implements CursorActivation,
GeneratedByteCode {
    private LanguageConnectionContext lcc;
    protected ContextManager cm;
    protected ExecPreparedStatement preStmt;
    protected ResultSet resultSet;
    protected ResultDescription resultDescription;
    protected boolean closed;
    private String cursorName;
    protected int numSubqueries;
    private boolean singleExecution;
    private volatile boolean inUse;
    private java.sql.ResultSet targetVTI;
    private SQLWarning warnings;
    private GeneratedClass gc;
    private boolean checkRowCounts;
    private HashSet<Integer> rowCountsCheckedThisExecution = new HashSet(4, 0.9f);
    private static final long MAX_SQRT = (long)Math.sqrt(9.223372036854776E18);
    private static final int TEN_PERCENT_THRESHOLD = 400;
    private ConglomerateController updateHeapCC;
    private ScanController indexSC;
    private long indexConglomerateNumber = -1L;
    private TableDescriptor ddlTableDescriptor;
    private long maxRows = -1L;
    private boolean forCreateTable;
    private boolean scrollable;
    private boolean resultSetHoldability;
    private CursorResultSet forUpdateIndexScan;
    private boolean autoGeneratedKeysResultSetMode;
    private int[] autoGeneratedKeysColumnIndexes;
    private String[] autoGeneratedKeysColumnNames;
    private boolean isValid;
    protected String UUIDString;
    protected UUID UUIDValue;
    private Activation parentActivation;
    private SQLSessionContext sqlSessionContextForChildren;
    private Stack<ConstantAction> constantActionStack = new Stack();
    protected int indexOfSessionTableNamesInSavedObjects = -1;
    protected ExecRow[] row;
    protected ParameterValueSet pvs;
    protected CursorResultSet[] raParentResultSets;
    protected Hashtable<String, Vector<TemporaryRowHolder>> parentResultSets;
    private Calendar cal;

    protected BaseActivation() {
    }

    @Override
    public final void initFromContext(Context context) throws StandardException {
        SanityManager.ASSERT((context != null ? 1 : 0) != 0, (String)"NULL context passed to BaseActivation.initFromContext");
        this.cm = context.getContextManager();
        this.lcc = (LanguageConnectionContext)this.cm.getContext("LanguageConnectionContext");
        if (this.lcc == null) {
            SanityManager.THROWASSERT((String)("lcc is null in activation type " + this.getClass()));
        }
        this.inUse = true;
        this.lcc.addActivation(this);
        this.isValid = true;
        UUIDFactory uuidFactory = BaseActivation.getMonitor().getUUIDFactory();
        this.UUIDValue = uuidFactory.createUUID();
        this.UUIDString = this.UUIDValue.toString();
    }

    @Override
    public final ResultSet execute() throws StandardException {
        this.throwIfClosed("execute");
        this.checkRowCounts = this.shouldWeCheckRowCounts();
        if (this.checkRowCounts) {
            this.rowCountsCheckedThisExecution.clear();
        }
        this.reinit();
        if (this.resultSet == null) {
            this.resultSet = this.decorateResultSet();
        }
        return this.resultSet;
    }

    ResultSet decorateResultSet() throws StandardException {
        return this.createResultSet();
    }

    protected abstract ResultSet createResultSet() throws StandardException;

    protected void reinit() throws StandardException {
    }

    @Override
    public final ExecPreparedStatement getPreparedStatement() {
        return this.preStmt;
    }

    @Override
    public ConstantAction pushConstantAction(ConstantAction newConstantAction) {
        return this.constantActionStack.push(newConstantAction);
    }

    @Override
    public ConstantAction popConstantAction() {
        return this.constantActionStack.pop();
    }

    @Override
    public ConstantAction getConstantAction() {
        if (this.constantActionStack.size() > 0) {
            return this.constantActionStack.peek();
        }
        return this.preStmt.getConstantAction();
    }

    @Override
    public final void checkStatementValidity() throws StandardException {
        if (this.preStmt == null || this.preStmt.upToDate(this.gc)) {
            return;
        }
        StandardException se = StandardException.newException((String)"XCL32.S", (Object[])new Object[0]);
        se.setReport(1);
        throw se;
    }

    public final void setupActivation(ExecPreparedStatement ps, boolean scrollable) throws StandardException {
        this.preStmt = ps;
        if (ps != null) {
            this.resultDescription = ps.getResultDescription();
            this.scrollable = scrollable;
            if (this.pvs != null && this.pvs.getParameterCount() != 0) {
                this.pvs.initialize(ps.getParameterTypes());
            }
        } else {
            this.resultDescription = null;
            this.scrollable = false;
        }
    }

    @Override
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public RowLocation getRowLocationTemplate(int itemNumber) {
        RowLocation rl;
        DataValueDescriptor rlClone;
        SanityManager.ASSERT((itemNumber >= 0 ? 1 : 0) != 0, (String)"itemNumber expected to be >= 0");
        if (!(this.getPreparedStatement().getSavedObject(itemNumber) instanceof RowLocation)) {
            SanityManager.THROWASSERT((String)("getPreparedStatement().getSavedObject(itemNumber) expected to be instance of RowLocation, not " + this.getPreparedStatement().getSavedObject(itemNumber).getClass().getName() + ", query is " + this.getPreparedStatement().getSource()));
        }
        if (!((rlClone = (rl = (RowLocation)this.getPreparedStatement().getSavedObject(itemNumber)).cloneValue(false)) instanceof RowLocation)) {
            SanityManager.THROWASSERT((String)("rl.getClone() expected to be instance of RowLocation, not " + rlClone.getClass().getName() + ", query is " + this.getPreparedStatement().getSource()));
        }
        return (RowLocation)rlClone;
    }

    @Override
    public ResultDescription getResultDescription() {
        SanityManager.ASSERT((this.resultDescription != null ? 1 : 0) != 0, (String)"Must have a result description");
        return this.resultDescription;
    }

    @Override
    public void reset() throws StandardException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        this.updateHeapCC = null;
        if (!this.isSingleExecution()) {
            this.clearWarnings();
        }
    }

    @Override
    public final void close() throws StandardException {
        if (!this.closed) {
            this.reset();
            if (this.resultSet != null) {
                this.resultSet.finish();
                this.resultSet = null;
            }
            this.closed = true;
            DependencyManager dm = this.lcc.getDataDictionary().getDependencyManager();
            dm.clearDependencies(this.lcc, this);
            this.lcc.removeActivation(this);
            if (this.preStmt != null) {
                this.preStmt.finish(this.lcc);
                this.preStmt = null;
            }
            try {
                this.closeActivationAction();
            }
            catch (Throwable e) {
                throw StandardException.plainWrapException((Throwable)e);
            }
        }
    }

    protected void closeActivationAction() throws Exception {
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setSingleExecution() {
        this.singleExecution = true;
    }

    @Override
    public boolean isSingleExecution() {
        return this.singleExecution;
    }

    @Override
    public int getNumSubqueries() {
        return this.numSubqueries;
    }

    @Override
    public boolean isCursorActivation() {
        return false;
    }

    @Override
    public final void setGC(GeneratedClass gc) {
        this.gc = gc;
    }

    @Override
    public final GeneratedClass getGC() {
        if (this.gc == null) {
            SanityManager.THROWASSERT((String)"move code requiring GC to postConstructor() method!!");
        }
        return this.gc;
    }

    @Override
    public final GeneratedMethod getMethod(String methodName) throws StandardException {
        return this.getGC().getMethod(methodName);
    }

    @Override
    public Object e0() throws StandardException {
        return null;
    }

    @Override
    public Object e1() throws StandardException {
        return null;
    }

    @Override
    public Object e2() throws StandardException {
        return null;
    }

    @Override
    public Object e3() throws StandardException {
        return null;
    }

    @Override
    public Object e4() throws StandardException {
        return null;
    }

    @Override
    public Object e5() throws StandardException {
        return null;
    }

    @Override
    public Object e6() throws StandardException {
        return null;
    }

    @Override
    public Object e7() throws StandardException {
        return null;
    }

    @Override
    public Object e8() throws StandardException {
        return null;
    }

    @Override
    public Object e9() throws StandardException {
        return null;
    }

    @Override
    public boolean checkIfThisActivationHasHoldCursor(String tableName) {
        if (!this.inUse) {
            return false;
        }
        if (!this.resultSetHoldability) {
            return false;
        }
        if (this.indexOfSessionTableNamesInSavedObjects == -1) {
            return false;
        }
        if (this.resultSet != null && !this.resultSet.isClosed() && this.resultSet.returnsRows()) {
            return ((ArrayList)this.getPreparedStatement().getSavedObject(this.indexOfSessionTableNamesInSavedObjects)).contains(tableName);
        }
        return false;
    }

    @Override
    public void setCursorName(String cursorName) {
        if (this.isCursorActivation()) {
            this.cursorName = cursorName;
        }
    }

    @Override
    public String getCursorName() {
        return this.isCursorActivation() ? this.cursorName : null;
    }

    @Override
    public void setResultSetHoldability(boolean resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public boolean getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    @Override
    public void setAutoGeneratedKeysResultsetInfo(int[] columnIndexes, String[] columnNames) {
        this.autoGeneratedKeysResultSetMode = true;
        this.autoGeneratedKeysColumnIndexes = ArrayUtil.copy((int[])columnIndexes);
        this.autoGeneratedKeysColumnNames = (String[])ArrayUtil.copy((Object[])columnNames);
    }

    @Override
    public boolean getAutoGeneratedKeysResultsetMode() {
        return this.autoGeneratedKeysResultSetMode;
    }

    @Override
    public int[] getAutoGeneratedKeysColumnIndexes() {
        return ArrayUtil.copy((int[])this.autoGeneratedKeysColumnIndexes);
    }

    @Override
    public String[] getAutoGeneratedKeysColumnNames() {
        return (String[])ArrayUtil.copy((Object[])this.autoGeneratedKeysColumnNames);
    }

    public final ResultSetFactory getResultSetFactory() {
        return this.getExecutionFactory().getResultSetFactory();
    }

    @Override
    public final ExecutionFactory getExecutionFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
    }

    @Override
    public CursorResultSet getTargetResultSet() {
        SanityManager.THROWASSERT((String)"Must be overridden to be used.");
        return null;
    }

    protected DataValueDescriptor getSetAutoincrementValue(int columnPosition, long increment) throws StandardException {
        NumberDataValue l = ((DMLWriteGeneratedColumnsResultSet)this.resultSet).getSetAutoincrementValue(columnPosition, increment);
        return l;
    }

    @Override
    public NumberDataValue getCurrentValueAndAdvance(String sequenceUUIDstring, int typeFormatID) throws StandardException {
        NumberDataValue ndv = (NumberDataValue)this.getDataValueFactory().getNull(typeFormatID, 0);
        this.lcc.getDataDictionary().getCurrentValueAndAdvance(sequenceUUIDstring, ndv);
        return ndv;
    }

    @Override
    public CursorResultSet getCursorResultSet() {
        SanityManager.THROWASSERT((String)"Must be overridden to be used.");
        return null;
    }

    public void throwIfClosed(String op) throws StandardException {
        if (this.closed) {
            throw StandardException.newException((String)"XCL05.S", (Object[])new Object[]{op});
        }
    }

    public static void setColumnPosition(int[] columnPositions, int positionToSet, int column) {
        columnPositions[positionToSet] = column;
    }

    public static void allocateQualArray(Qualifier[][] qualifiers, int position, int length) {
        qualifiers[position] = new Qualifier[length];
    }

    public static void setQualifier(Qualifier[][] qualifiers, Qualifier qualifier, int position_1, int position_2) {
        qualifiers[position_1][position_2] = qualifier;
    }

    public static void reinitializeQualifiers(Qualifier[][] qualifiers) {
        if (qualifiers != null) {
            for (int term = 0; term < qualifiers.length; ++term) {
                for (int i = 0; i < qualifiers[term].length; ++i) {
                    qualifiers[term][i].reinitialize();
                }
            }
        }
    }

    @Override
    public final void markUnused() {
        if (this.isInUse()) {
            this.inUse = false;
            this.lcc.notifyUnusedActivation();
        }
    }

    @Override
    public final boolean isInUse() {
        return this.inUse;
    }

    @Override
    public void addWarning(SQLWarning w) {
        if (this.warnings == null) {
            this.warnings = w;
        } else {
            this.warnings.setNextWarning(w);
        }
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    protected static void nullToPrimitiveTest(DataValueDescriptor dvd, String primitiveType) throws StandardException {
        if (dvd.isNull()) {
            throw StandardException.newException((String)"39004", (Object[])new Object[]{primitiveType});
        }
    }

    @Override
    public void informOfRowCount(NoPutResultSet resultSet, long currentRowCount) throws StandardException {
        if (this.checkRowCounts) {
            long n1;
            boolean significantChange = false;
            int resultSetNumber = resultSet.resultSetNumber();
            if (this.rowCountsCheckedThisExecution.add(resultSetNumber) && currentRowCount != (n1 = this.getPreparedStatement().getInitialRowCount(resultSetNumber, currentRowCount))) {
                if (n1 >= 400L) {
                    long changeFactor = n1 / (currentRowCount - n1);
                    if (Math.abs(changeFactor) <= 10L) {
                        significantChange = true;
                    }
                } else {
                    long changediff = currentRowCount - n1;
                    if (Math.abs(changediff) <= MAX_SQRT && changediff * changediff > Math.abs(4L * n1)) {
                        significantChange = true;
                    }
                }
            }
            if (significantChange) {
                this.preStmt.makeInvalid(23, this.lcc);
            }
        }
    }

    @Override
    public ConglomerateController getHeapConglomerateController() {
        return this.updateHeapCC;
    }

    @Override
    public void setHeapConglomerateController(ConglomerateController updateHeapCC) {
        this.updateHeapCC = updateHeapCC;
    }

    @Override
    public void clearHeapConglomerateController() {
        this.updateHeapCC = null;
    }

    @Override
    public ScanController getIndexScanController() {
        return this.indexSC;
    }

    @Override
    public void setIndexScanController(ScanController indexSC) {
        this.indexSC = indexSC;
    }

    @Override
    public long getIndexConglomerateNumber() {
        return this.indexConglomerateNumber;
    }

    @Override
    public void setIndexConglomerateNumber(long indexConglomerateNumber) {
        this.indexConglomerateNumber = indexConglomerateNumber;
    }

    @Override
    public void clearIndexScanInfo() {
        this.indexSC = null;
        this.indexConglomerateNumber = -1L;
    }

    @Override
    public void setForCreateTable() {
        this.forCreateTable = true;
    }

    @Override
    public boolean getForCreateTable() {
        return this.forCreateTable;
    }

    @Override
    public void setDDLTableDescriptor(TableDescriptor td) {
        this.ddlTableDescriptor = td;
    }

    @Override
    public TableDescriptor getDDLTableDescriptor() {
        return this.ddlTableDescriptor;
    }

    @Override
    public void setMaxRows(long maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public long getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setTargetVTI(java.sql.ResultSet targetVTI) {
        this.targetVTI = targetVTI;
    }

    @Override
    public java.sql.ResultSet getTargetVTI() {
        return this.targetVTI;
    }

    protected boolean shouldWeCheckRowCounts() throws StandardException {
        ExecPreparedStatement ps = this.getPreparedStatement();
        int executionCount = ps.incrementExecutionCount();
        if (executionCount == 1) {
            return true;
        }
        if (executionCount < 5) {
            return false;
        }
        int stalePlanCheckInterval = ps.getStalePlanCheckInterval();
        if (stalePlanCheckInterval == 0) {
            TransactionController tc = this.getTransactionController();
            stalePlanCheckInterval = PropertyUtil.getServiceInt(tc, "derby.language.stalePlanCheckInterval", 5, Integer.MAX_VALUE, 100);
            ps.setStalePlanCheckInterval(stalePlanCheckInterval);
        }
        return executionCount % stalePlanCheckInterval == 1;
    }

    public final boolean getScrollable() {
        return this.scrollable;
    }

    protected final void setParameterValueSet(int paramCount, boolean hasReturnParam) {
        this.pvs = this.lcc.getLanguageFactory().newParameterValueSet(this.lcc.getLanguageConnectionFactory().getClassFactory().getClassInspector(), paramCount, hasReturnParam);
    }

    protected final DataValueDescriptor getParameter(int position) throws StandardException {
        return this.pvs.getParameter(position);
    }

    @Override
    public ParameterValueSet getParameterValueSet() {
        if (this.pvs == null) {
            this.setParameterValueSet(0, false);
        }
        return this.pvs;
    }

    @Override
    public void setParameters(ParameterValueSet parameterValues, DataTypeDescriptor[] parameterTypes) throws StandardException {
        if (!this.isClosed()) {
            if (this.pvs == null || parameterTypes == null) {
                this.pvs = parameterValues;
                return;
            }
            DataTypeDescriptor[] newParamTypes = this.preStmt.getParameterTypes();
            boolean match = false;
            if (newParamTypes != null && newParamTypes.length == parameterTypes.length) {
                match = true;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    DataTypeDescriptor oldType = parameterTypes[i];
                    DataTypeDescriptor newType = newParamTypes[i];
                    if (!oldType.isExactTypeAndLengthMatch(newType)) {
                        match = false;
                        break;
                    }
                    if (oldType.isNullable() == newType.isNullable()) continue;
                    match = false;
                    break;
                }
            }
            if (!match) {
                throw StandardException.newException((String)"XCL10.S", (Object[])new Object[0]);
            }
            parameterValues.transferDataValues(this.pvs);
        } else {
            SanityManager.THROWASSERT((String)"isClosed() is expected to return false");
        }
    }

    public void throwIfMissingParms() throws StandardException {
        if (this.pvs != null && !this.pvs.allAreSet()) {
            throw StandardException.newException((String)"07000", (Object[])new Object[0]);
        }
    }

    @Override
    public void setCurrentRow(ExecRow currentRow, int resultSetNumber) {
        SanityManager.ASSERT((!this.isClosed() ? 1 : 0) != 0, (String)"closed");
        if (this.row != null && (resultSetNumber < 0 || resultSetNumber >= this.row.length)) {
            SanityManager.THROWASSERT((String)("resultSetNumber = " + resultSetNumber + ", expected to be between 0 and " + this.row.length));
        }
        if (this.row != null) {
            this.row[resultSetNumber] = currentRow;
        }
    }

    @Override
    public void clearCurrentRow(int resultSetNumber) {
        if (this.row != null && (resultSetNumber < 0 || resultSetNumber >= this.row.length)) {
            SanityManager.THROWASSERT((String)("resultSetNumber = " + resultSetNumber + ", expected to be between 0 and " + this.row.length));
        }
        if (this.row != null) {
            this.row[resultSetNumber] = null;
        }
    }

    @Override
    public Row getCurrentRow(int resultSetNumber) {
        return this.row[resultSetNumber];
    }

    @Override
    public SQLSessionContext getSQLSessionContextForChildren() {
        return this.sqlSessionContextForChildren;
    }

    @Override
    public SQLSessionContext setupSQLSessionContextForChildren(boolean push) {
        this.sqlSessionContextForChildren = push ? this.lcc.createSQLSessionContext() : (this.parentActivation != null ? this.parentActivation.getSQLSessionContextForChildren() : this.lcc.getTopLevelSQLSessionContext());
        return this.sqlSessionContextForChildren;
    }

    @Override
    public void setParentActivation(Activation a) {
        this.parentActivation = a;
    }

    @Override
    public Activation getParentActivation() {
        return this.parentActivation;
    }

    protected final DataValueDescriptor getColumnFromRow(int rsNumber, int colId) throws StandardException {
        if (this.row[rsNumber] == null) {
            return null;
        }
        return this.row[rsNumber].getColumn(colId);
    }

    protected void checkPositionedStatement(String cursorName, String psName) throws StandardException {
        ExecPreparedStatement ps = this.getPreparedStatement();
        if (ps == null) {
            return;
        }
        CursorActivation cursorActivation = this.lcc.lookupCursorActivation(cursorName);
        if (cursorActivation != null && !psName.equals(cursorActivation.getPreparedStatement().getObjectName())) {
            ps.makeInvalid(5, this.lcc);
        }
    }

    public NoPutResultSet materializeResultSetIfPossible(NoPutResultSet rs) throws StandardException {
        rs.openCore();
        Vector<ExecRow> rowCache = new Vector<ExecRow>();
        int cacheSize = 0;
        FormatableBitSet toClone = null;
        int maxMemoryPerTable = this.getLanguageConnectionContext().getOptimizerFactory().getMaxMemoryPerTable();
        ExecRow aRow = rs.getNextRowCore();
        if (aRow != null) {
            toClone = new FormatableBitSet(aRow.nColumns() + 1);
            toClone.set(1);
        }
        while (aRow != null && (cacheSize += aRow.getColumn(1).getLength()) <= maxMemoryPerTable && rowCache.size() <= 512) {
            rowCache.addElement(aRow.getClone(toClone));
            aRow = rs.getNextRowCore();
        }
        rs.close();
        if (aRow == null) {
            int rsNum = rs.resultSetNumber();
            int numRows = rowCache.size();
            if (numRows == 0) {
                return new RowResultSet((Activation)this, (ExecRow)null, true, rsNum, 0.0, 0.0);
            }
            RowResultSet[] rrs = new RowResultSet[numRows];
            UnionResultSet[] urs = new UnionResultSet[numRows - 1];
            for (int i = 0; i < numRows; ++i) {
                rrs[i] = new RowResultSet((Activation)this, (ExecRow)rowCache.elementAt(i), true, rsNum, 1.0, 0.0);
                if (i <= 0) continue;
                urs[i - 1] = new UnionResultSet(i > 1 ? urs[i - 2] : rrs[0], rrs[i], this, rsNum, i + 1, 0.0);
            }
            rs.finish();
            if (numRows == 1) {
                return rrs[0];
            }
            return urs[urs.length - 1];
        }
        return rs;
    }

    @Override
    public void setParentResultSet(TemporaryRowHolder rs, String resultSetId) {
        Vector<TemporaryRowHolder> rsVector;
        if (this.parentResultSets == null) {
            this.parentResultSets = new Hashtable();
        }
        if ((rsVector = this.parentResultSets.get(resultSetId)) == null) {
            rsVector = new Vector();
            rsVector.addElement(rs);
        } else {
            rsVector.addElement(rs);
        }
        this.parentResultSets.put(resultSetId, rsVector);
    }

    @Override
    public Vector<TemporaryRowHolder> getParentResultSet(String resultSetId) {
        return this.parentResultSets.get(resultSetId);
    }

    @Override
    public Enumeration<String> getParentResultSetKeys() {
        return this.parentResultSets.keys();
    }

    @Override
    public void clearParentResultSets() {
        if (this.parentResultSets != null) {
            this.parentResultSets.clear();
        }
    }

    @Override
    public void setForUpdateIndexScan(CursorResultSet forUpdateIndexScan) {
        this.forUpdateIndexScan = forUpdateIndexScan;
    }

    @Override
    public CursorResultSet getForUpdateIndexScan() {
        return this.forUpdateIndexScan;
    }

    protected Calendar getCalendar() {
        if (this.cal == null) {
            this.cal = new GregorianCalendar();
        }
        return this.cal;
    }

    @Override
    public final LanguageConnectionContext getLanguageConnectionContext() {
        return this.lcc;
    }

    @Override
    public final TransactionController getTransactionController() {
        return this.lcc.getTransactionExecute();
    }

    public ContextManager getContextManager() {
        return this.cm;
    }

    @Override
    public DataValueFactory getDataValueFactory() {
        return this.getLanguageConnectionContext().getDataValueFactory();
    }

    public Connection getCurrentConnection() throws SQLException {
        ConnectionContext cc = (ConnectionContext)((Object)this.getContextManager().getContext("JDBC_ConnectionContext"));
        return cc.getNestedConnection(true);
    }

    @Override
    public java.sql.ResultSet[][] getDynamicResults() {
        return null;
    }

    @Override
    public int getMaxDynamicResults() {
        return 0;
    }

    public NumberDataValue getDB2Length(DataValueDescriptor value, int constantLength, NumberDataValue reUse) throws StandardException {
        if (reUse == null) {
            reUse = this.getDataValueFactory().getNullInteger(null);
        }
        if (value.isNull()) {
            reUse.setToNull();
        } else if (constantLength >= 0) {
            reUse.setValue(constantLength);
        } else {
            reUse.setValue(value.getLength());
        }
        return reUse;
    }

    @Override
    public DependableFinder getDependableFinder() {
        return null;
    }

    @Override
    public String getObjectName() {
        return this.UUIDString;
    }

    @Override
    public UUID getObjectID() {
        return this.UUIDValue;
    }

    @Override
    public String getClassType() {
        return "Activation";
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 48: {
                this.isValid = false;
                DependencyManager dm = lcc.getDataDictionary().getDependencyManager();
                dm.clearDependencies(lcc, this);
                break;
            }
            case 47: {
                break;
            }
            case 23: {
                break;
            }
            default: {
                SanityManager.DEBUG_PRINT((String)"BaseActivation", (String)("action=" + action));
                SanityManager.NOTREACHED();
            }
        }
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
    }

    static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

