/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public final class RowCountNode
extends SingleChildResultSetNode {
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;

    RowCountNode(ResultSetNode childResult, ResultColumnList rcl, ValueNode offset, ValueNode fetchFirst, boolean hasJDBClimitClause, ContextManager cm) throws StandardException {
        super(childResult, null, cm);
        this.setResultColumns(rcl);
        this.offset = offset;
        this.fetchFirst = fetchFirst;
        this.hasJDBClimitClause = hasJDBClimitClause;
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.assignResultSetNumber();
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        acb.pushGetResultSetFactoryExpression(mb);
        this.childResult.generate(acb, mb);
        acb.pushThisAsActivation(mb);
        mb.push(this.getResultSetNumber());
        boolean dynamicOffset = false;
        boolean dynamicFetchFirst = false;
        if (this.offset != null) {
            this.generateExprFun(acb, mb, this.offset);
        } else {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
        if (this.fetchFirst != null) {
            this.generateExprFun(acb, mb, this.fetchFirst);
        } else {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
        mb.push(this.hasJDBClimitClause);
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.callMethod((short)185, null, "getRowCountResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 8);
    }

    private void generateExprFun(ExpressionClassBuilder ecb, MethodBuilder mb, ValueNode vn) throws StandardException {
        MethodBuilder exprFun = ecb.newExprFun();
        vn.generateExpression(ecb, exprFun);
        exprFun.methodReturn();
        exprFun.complete();
        ecb.pushMethodReference(mb, exprFun);
    }

    @Override
    public String toString() {
        return "offset: " + this.offset + "\nfetchFirst:" + this.fetchFirst + "\n" + super.toString();
    }
}

