/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class ResultColumn
extends ValueNode
implements ResultColumnDescriptor,
Comparable<ResultColumn> {
    private String _underlyingName;
    private String _derivedColumnName;
    private String _unqualifiedTableName;
    private String _unqualifiedSourceTableName;
    private String _sourceSchemaName;
    private ValueNode _expression;
    private ColumnDescriptor _columnDescriptor;
    private boolean _isGenerated;
    private boolean _isGeneratedForUnmatchedColumnInInsert;
    private boolean _isGroupingColumn;
    private boolean _isReferenced;
    private boolean _isRedundant;
    private boolean _isNameGenerated;
    private boolean _updated;
    private boolean _updatableByCursor;
    private boolean defaultColumn;
    private boolean wasDefault;
    private boolean rightOuterJoinUsingClause;
    private JoinNode joinResultSet = null;
    private boolean _autoincrementGenerated;
    private boolean _autoincrement;
    private int resultSetNumber = -1;
    private ColumnReference _reference;
    private int virtualColumnId;

    ResultColumn(ContextManager cm) {
        super(cm);
    }

    ResultColumn(String underlyingName, ValueNode expression, ContextManager cm) throws StandardException {
        super(cm);
        this.setTypeExpressionAndDefault(expression);
        this._derivedColumnName = this._underlyingName = underlyingName;
    }

    ResultColumn(ColumnReference cr, ValueNode expression, ContextManager cm) throws StandardException {
        super(cm);
        this.setTypeExpressionAndDefault(expression);
        this._underlyingName = cr.getColumnName();
        this._derivedColumnName = cr.getColumnName();
        this._reference = cr;
    }

    ResultColumn(ColumnDescriptor cd, ValueNode expression, ContextManager cm) throws StandardException {
        super(cm);
        this.setTypeExpressionAndDefault(expression);
        this._derivedColumnName = this._underlyingName = cd.getColumnName();
        this.setType(cd.getType());
        this._columnDescriptor = cd;
        this._autoincrement = cd.isAutoincrement();
    }

    ResultColumn(DataTypeDescriptor dtd, ValueNode expression, ContextManager cm) throws StandardException {
        super(cm);
        this.setTypeExpressionAndDefault(expression);
        this.setType(dtd);
        if (this._expression instanceof ColumnReference) {
            this._reference = (ColumnReference)expression;
        }
    }

    private void setTypeExpressionAndDefault(ValueNode expression) {
        this.setExpression(expression);
        if (expression != null && expression instanceof DefaultNode) {
            this.defaultColumn = true;
        }
    }

    boolean isRightOuterJoinUsingClause() {
        return this.rightOuterJoinUsingClause;
    }

    void setRightOuterJoinUsingClause(boolean value) {
        this.rightOuterJoinUsingClause = value;
    }

    JoinNode getJoinResultSet() {
        return this.joinResultSet;
    }

    void setJoinResultset(JoinNode resultSet) {
        this.joinResultSet = resultSet;
    }

    boolean isDefaultColumn() {
        return this.defaultColumn;
    }

    void setDefaultColumn(boolean value) {
        this.defaultColumn = value;
    }

    boolean wasDefaultColumn() {
        return this.wasDefault;
    }

    void setWasDefaultColumn(boolean value) {
        this.wasDefault = value;
    }

    boolean columnNameMatches(String columnName) {
        return columnName.equals(this._derivedColumnName) || columnName.equals(this._underlyingName) || columnName.equals(this.getSourceColumnName());
    }

    String getUnderlyingOrAliasName() {
        if (this.getSourceColumnName() != null) {
            return this.getSourceColumnName();
        }
        if (this._underlyingName != null) {
            return this._underlyingName;
        }
        return this._derivedColumnName;
    }

    boolean isUpdatable() {
        return this._derivedColumnName == null || this._underlyingName.equals(this._derivedColumnName);
    }

    String getSourceColumnName() {
        if (this._expression instanceof ColumnReference) {
            return ((ColumnReference)this._expression).getColumnName();
        }
        return null;
    }

    @Override
    public String getName() {
        return this._derivedColumnName;
    }

    @Override
    String getSchemaName() throws StandardException {
        if (this._columnDescriptor != null && this._columnDescriptor.getTableDescriptor() != null) {
            return this._columnDescriptor.getTableDescriptor().getSchemaName();
        }
        if (this._expression != null) {
            return this._expression.getSchemaName();
        }
        return null;
    }

    @Override
    String getTableName() {
        if (this._unqualifiedTableName != null) {
            return this._unqualifiedTableName;
        }
        if (this._columnDescriptor != null && this._columnDescriptor.getTableDescriptor() != null) {
            return this._columnDescriptor.getTableDescriptor().getName();
        }
        return this._expression.getTableName();
    }

    @Override
    public String getSourceTableName() {
        return this._unqualifiedSourceTableName;
    }

    @Override
    public String getSourceSchemaName() {
        return this._sourceSchemaName;
    }

    void clearTableName() {
        if (this._expression instanceof ColumnReference) {
            ((ColumnReference)this._expression).setQualifiedTableName(null);
        }
    }

    @Override
    public DataTypeDescriptor getType() {
        return this.getTypeServices();
    }

    @Override
    public int getColumnPosition() {
        if (this._columnDescriptor != null) {
            return this._columnDescriptor.getPosition();
        }
        return this.virtualColumnId;
    }

    void setExpression(ValueNode expression) {
        this._expression = expression;
    }

    ValueNode getExpression() {
        return this._expression;
    }

    void setExpressionToNullNode() throws StandardException {
        this.setExpression(this.getNullNode(this.getTypeServices()));
    }

    void setName(String name) {
        if (this._underlyingName == null) {
            this._underlyingName = name;
        } else {
            SanityManager.ASSERT((this._reference == null || name.equals(this._reference.getColumnName()) ? 1 : 0) != 0, (String)"don't change name from reference name");
        }
        this._derivedColumnName = name;
    }

    boolean isNameGenerated() {
        return this._isNameGenerated;
    }

    void setNameGenerated(boolean value) {
        this._isNameGenerated = value;
    }

    void setResultSetNumber(int resultSetNumber) {
        this.resultSetNumber = resultSetNumber;
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    void adjustVirtualColumnId(int adjust) {
        this.virtualColumnId += adjust;
    }

    void setVirtualColumnId(int id) {
        this.virtualColumnId = id;
    }

    int getVirtualColumnId() {
        return this.virtualColumnId;
    }

    void collapseVirtualColumnIdGap(int removedColumnId) {
        if (this._columnDescriptor == null && this.virtualColumnId > removedColumnId) {
            --this.virtualColumnId;
        }
    }

    void guaranteeColumnName() throws StandardException {
        if (this._derivedColumnName == null) {
            this._derivedColumnName = "SQLCol" + this.getCompilerContext().getNextColumnNumber();
            this._isNameGenerated = true;
        }
    }

    @Override
    public String toString() {
        return "derivedColumnName: " + this._derivedColumnName + "\nunderlyingName: " + this._underlyingName + "\ntableName: " + this._unqualifiedTableName + "\nisDefaultColumn: " + this.defaultColumn + "\nwasDefaultColumn: " + this.wasDefault + "\nisNameGenerated: " + this._isNameGenerated + "\nsourceTableName: " + this._unqualifiedSourceTableName + "\ntype: " + this.getTypeServices() + "\ncolumnDescriptor: " + this._columnDescriptor + "\nisGenerated: " + this._isGenerated + "\nautoincrementGenerated: " + this._autoincrementGenerated + "\nisGeneratedForUnmatchedColumnInInsert: " + this._isGeneratedForUnmatchedColumnInInsert + "\nisGroupingColumn: " + this._isGroupingColumn + "\nisReferenced: " + this._isReferenced + "\nisRedundant: " + this._isRedundant + "\nrightOuterJoinUsingClause: " + this.rightOuterJoinUsingClause + "\njoinResultSet: " + this.joinResultSet + "\nvirtualColumnId: " + this.virtualColumnId + "\nresultSetNumber: " + this.resultSetNumber + "\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this._expression != null) {
            this.printLabel(depth, "expression: ");
            this._expression.treePrint(depth + 1);
        }
        if (this._reference != null) {
            this.printLabel(depth, "reference: ");
            this._reference.treePrint(depth + 1);
        }
    }

    @Override
    ResultColumn bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        if (this._expression.requiresTypeFromContext() && this.getTypeServices() != null) {
            this._expression.setType(this.getTypeServices());
        }
        if (this._expression.getTableName() == null) {
            fromList.isJoinColumnForRightOuterJoin(this);
        }
        this.setExpression(this._expression.bindExpression(fromList, subqueryList, aggregates));
        if (this._expression instanceof ColumnReference) {
            this._autoincrement = ((ColumnReference)this._expression).getSource().isAutoincrement();
        }
        return this;
    }

    void bindResultColumnByPosition(TableDescriptor tableDescriptor, int columnId) throws StandardException {
        ColumnDescriptor colDesc = tableDescriptor.getColumnDescriptor(columnId);
        if (colDesc == null) {
            Object errorString = "";
            String schemaName = tableDescriptor.getSchemaName();
            if (schemaName != null) {
                errorString = (String)errorString + schemaName + ".";
            }
            errorString = (String)errorString + tableDescriptor.getName();
            throw StandardException.newException((String)"42X06", (Object[])new Object[]{errorString});
        }
        this.setColumnDescriptor(tableDescriptor, colDesc);
        this.setVirtualColumnId(columnId);
    }

    void bindResultColumnByName(TableDescriptor tableDescriptor, int columnId) throws StandardException {
        ColumnDescriptor colDesc = tableDescriptor.getColumnDescriptor(this._derivedColumnName);
        if (colDesc == null) {
            Object errorString = "";
            String schemaName = tableDescriptor.getSchemaName();
            if (schemaName != null) {
                errorString = (String)errorString + schemaName + ".";
            }
            errorString = (String)errorString + tableDescriptor.getName();
            throw StandardException.newException((String)"42X14", (Object[])new Object[]{this._derivedColumnName, errorString});
        }
        this.setColumnDescriptor(tableDescriptor, colDesc);
        this.setVirtualColumnId(columnId);
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().addRequiredColumnPriv(colDesc);
        }
    }

    void typeUntypedNullExpression(ResultColumn bindingRC) throws StandardException {
        TypeId typeId = bindingRC.getTypeId();
        if (typeId == null) {
            throw StandardException.newException((String)"42X07", (Object[])new Object[0]);
        }
        if (this._expression instanceof UntypedNullConstantNode) {
            this.setExpression(this.getNullNode(bindingRC.getTypeServices()));
        } else if (this._expression instanceof ColumnReference && this._expression.getTypeServices() == null) {
            this._expression.setType(bindingRC.getType());
        }
    }

    void setColumnDescriptor(TableDescriptor tableDescriptor, ColumnDescriptor columnDescriptor) throws StandardException {
        if (columnDescriptor != null) {
            this.setType(columnDescriptor.getType());
        }
        this._columnDescriptor = columnDescriptor;
        if (this._reference != null && this._reference.getTableName() != null && this._reference.getMergeTableID() == 0 && tableDescriptor != null && !tableDescriptor.getName().equals(this._reference.getTableName())) {
            String realName = tableDescriptor.getName();
            String refName = this._reference.getTableName();
            throw StandardException.newException((String)"42X55", (Object[])new Object[]{realName, refName});
        }
    }

    void bindResultColumnToExpression() throws StandardException {
        this.setType(this._expression.getTypeServices());
        if (this._expression instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)this._expression;
            this._unqualifiedTableName = cr.getTableName();
            this._unqualifiedSourceTableName = cr.getSourceTableName();
            this._sourceSchemaName = cr.getSourceSchemaName();
        }
    }

    void setSourceTableName(String t) {
        this._unqualifiedSourceTableName = t;
    }

    void setSourceSchemaName(String s) {
        this._sourceSchemaName = s;
    }

    @Override
    ResultColumn preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        if (this._expression == null) {
            return this;
        }
        this.setExpression(this._expression.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList));
        return this;
    }

    void checkStorableExpression(ResultColumn toStore) throws StandardException {
        this.checkStorableExpression((ValueNode)toStore);
    }

    private void checkStorableExpression(ValueNode source) throws StandardException {
        TypeId toStoreTypeId = source.getTypeId();
        if (!this.getTypeCompiler().storable(toStoreTypeId, this.getClassFactory())) {
            throw StandardException.newException((String)"42821", (Object[])new Object[]{this.getTypeId().getSQLTypeName(), toStoreTypeId.getSQLTypeName()});
        }
    }

    void checkStorableExpression() throws StandardException {
        this.checkStorableExpression(this.getExpression());
    }

    @Override
    void generateExpression(ExpressionClassBuilder ecb, MethodBuilder mb) throws StandardException {
        this._expression.generateExpression(ecb, mb);
    }

    boolean columnTypeAndLengthMatch() throws StandardException {
        if (this.getExpression().requiresTypeFromContext()) {
            return false;
        }
        if (this.getTypeId().isXMLTypeId()) {
            return false;
        }
        DataTypeDescriptor expressionType = this.getExpression().getTypeServices();
        if (!this.getTypeServices().isExactTypeAndLengthMatch(expressionType)) {
            return false;
        }
        return this.getTypeServices().isNullable() || !expressionType.isNullable();
    }

    boolean columnTypeAndLengthMatch(ResultColumn otherColumn) throws StandardException {
        ValueNode otherExpression = otherColumn.getExpression();
        DataTypeDescriptor resultColumnType = this.getTypeServices();
        DataTypeDescriptor otherResultColumnType = otherColumn.getTypeServices();
        SanityManager.ASSERT((resultColumnType != null ? 1 : 0) != 0, (String)("Type is null for column " + this));
        SanityManager.ASSERT((otherResultColumnType != null ? 1 : 0) != 0, (String)("Type is null for column " + otherColumn));
        if (otherExpression != null && otherExpression.requiresTypeFromContext() || this._expression.requiresTypeFromContext()) {
            return false;
        }
        if (resultColumnType.getTypeId().isXMLTypeId()) {
            return false;
        }
        if (!resultColumnType.getTypeId().equals(otherResultColumnType.getTypeId())) {
            if (otherExpression instanceof ConstantNode) {
                DataValueDescriptor newValue;
                ConstantNode constant = (ConstantNode)otherColumn.getExpression();
                DataValueDescriptor oldValue = constant.getValue();
                if (oldValue != (newValue = this.convertConstant(resultColumnType.getTypeId(), resultColumnType.getMaximumWidth(), oldValue)) && oldValue instanceof StringDataValue == newValue instanceof StringDataValue) {
                    constant.setValue(newValue);
                    constant.setType(this.getTypeServices());
                    otherColumn.bindResultColumnToExpression();
                    otherResultColumnType = otherColumn.getType();
                }
                if (newValue instanceof StringDataValue) {
                    constant.setCollationInfo(resultColumnType);
                    DataValueFactory dvf = this.getDataValueFactory();
                    newValue = ((StringDataValue)newValue).getValue(dvf.getCharacterCollator(constant.getTypeServices().getCollationType()));
                    constant.setValue(newValue);
                }
            }
            if (!resultColumnType.getTypeId().equals(otherResultColumnType.getTypeId())) {
                return false;
            }
        }
        if (resultColumnType.getPrecision() != otherResultColumnType.getPrecision()) {
            return false;
        }
        if (resultColumnType.getScale() != otherResultColumnType.getScale()) {
            return false;
        }
        if (resultColumnType.getMaximumWidth() != otherResultColumnType.getMaximumWidth()) {
            return false;
        }
        return resultColumnType.isNullable() || !otherResultColumnType.isNullable() && !otherColumn.isGeneratedForUnmatchedColumnInInsert();
    }

    boolean isGenerated() {
        return this._isGenerated;
    }

    boolean isGeneratedForUnmatchedColumnInInsert() {
        return this._isGeneratedForUnmatchedColumnInInsert;
    }

    void markGenerated() {
        this._isGenerated = true;
        this._isReferenced = true;
    }

    void markGeneratedForUnmatchedColumnInInsert() {
        this._isGeneratedForUnmatchedColumnInInsert = true;
        this._isReferenced = true;
    }

    boolean isReferenced() {
        return this._isReferenced;
    }

    void setReferenced() {
        this._isReferenced = true;
    }

    void pullVirtualIsReferenced() {
        if (this.isReferenced()) {
            return;
        }
        ValueNode expr = this._expression;
        while (expr != null && expr instanceof VirtualColumnNode) {
            VirtualColumnNode vcn = (VirtualColumnNode)expr;
            ResultColumn src = vcn.getSourceColumn();
            if (src.isReferenced()) {
                this.setReferenced();
                return;
            }
            expr = src.getExpression();
        }
    }

    void setUnreferenced() {
        this._isReferenced = false;
    }

    void markAllRCsInChainReferenced() {
        this.setReferenced();
        ValueNode vn = this._expression;
        while (vn instanceof VirtualColumnNode) {
            VirtualColumnNode vcn = (VirtualColumnNode)vn;
            ResultColumn rc = vcn.getSourceColumn();
            rc.setReferenced();
            vn = rc.getExpression();
        }
    }

    boolean isRedundant() {
        return this._isRedundant;
    }

    void setRedundant() {
        this._isRedundant = true;
    }

    void markAsGroupingColumn() {
        this._isGroupingColumn = true;
    }

    void rejectParameter() throws StandardException {
        if (this._expression != null && this._expression.isParameterNode()) {
            throw StandardException.newException((String)"42X34", (Object[])new Object[0]);
        }
    }

    @Override
    public int compareTo(ResultColumn other) {
        ResultColumn otherResultColumn = other;
        return this.getColumnPosition() - otherResultColumn.getColumnPosition();
    }

    void markUpdated() {
        this._updated = true;
    }

    void markUpdatableByCursor() {
        this._updatableByCursor = true;
    }

    boolean updated() {
        return this._updated;
    }

    @Override
    public boolean updatableByCursor() {
        return this._updatableByCursor;
    }

    ResultColumn cloneMe() throws StandardException {
        ResultColumn newResultColumn;
        ValueNode cloneExpr = this._expression instanceof ColumnReference ? ((ColumnReference)this._expression).getClone() : this._expression;
        if (this._columnDescriptor != null) {
            newResultColumn = new ResultColumn(this._columnDescriptor, this._expression, this.getContextManager());
            newResultColumn.setExpression(cloneExpr);
        } else {
            newResultColumn = new ResultColumn(this.getName(), cloneExpr, this.getContextManager());
        }
        newResultColumn.setVirtualColumnId(this.getVirtualColumnId());
        newResultColumn.setName(this.getName());
        newResultColumn.setType(this.getTypeServices());
        newResultColumn.setNameGenerated(this.isNameGenerated());
        newResultColumn.setSourceTableName(this.getSourceTableName());
        newResultColumn.setSourceSchemaName(this.getSourceSchemaName());
        if (this.isGeneratedForUnmatchedColumnInInsert()) {
            newResultColumn.markGeneratedForUnmatchedColumnInInsert();
        }
        if (this.isReferenced()) {
            newResultColumn.setReferenced();
        }
        if (this.updated()) {
            newResultColumn.markUpdated();
        }
        if (this.updatableByCursor()) {
            newResultColumn.markUpdatableByCursor();
        }
        if (this.isAutoincrementGenerated()) {
            newResultColumn.setAutoincrementGenerated();
        }
        if (this.isAutoincrement()) {
            newResultColumn.setAutoincrement();
        }
        if (this.isGroupingColumn()) {
            newResultColumn.markAsGroupingColumn();
        }
        if (this.isRightOuterJoinUsingClause()) {
            newResultColumn.setRightOuterJoinUsingClause(true);
        }
        if (this.getJoinResultSet() != null) {
            newResultColumn.setJoinResultset(this.getJoinResultSet());
        }
        if (this.isGenerated()) {
            newResultColumn.markGenerated();
        }
        newResultColumn.copyTagsFrom(this);
        return newResultColumn;
    }

    int getMaximumColumnSize() {
        return this.getTypeServices().getTypeId().getApproximateLengthInBytes(this.getTypeServices());
    }

    @Override
    public DataTypeDescriptor getTypeServices() {
        DataTypeDescriptor type = super.getTypeServices();
        if (type != null) {
            return type;
        }
        if (this.getExpression() != null) {
            return this.getExpression().getTypeServices();
        }
        return null;
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        int expType = this.isAutoincrementGenerated() ? 0 : (this._expression != null ? this._expression.getOrderableVariantType() : 3);
        switch (expType) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return 1;
            }
        }
        return 3;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this._expression != null) {
            this.setExpression((ValueNode)this._expression.accept(v));
        }
    }

    void verifyOrderable() throws StandardException {
        if (!this.getTypeId().orderable(this.getClassFactory())) {
            throw StandardException.newException((String)"X0X67.S", (Object[])new Object[]{this.getTypeId().getSQLTypeName()});
        }
    }

    ColumnDescriptor getTableColumnDescriptor() {
        return this._columnDescriptor;
    }

    boolean isAutoincrementGenerated() {
        return this._autoincrementGenerated;
    }

    void setAutoincrementGenerated() {
        this._autoincrementGenerated = true;
    }

    void resetAutoincrementGenerated() {
        this._autoincrementGenerated = false;
    }

    @Override
    public boolean isAutoincrement() {
        return this._autoincrement;
    }

    void setAutoincrement() {
        this._autoincrement = true;
    }

    public boolean isGroupingColumn() {
        return this._isGroupingColumn;
    }

    private DataValueDescriptor convertConstant(TypeId toTypeId, int maxWidth, DataValueDescriptor constantValue) throws StandardException {
        int formatId = toTypeId.getTypeFormatId();
        DataValueFactory dvf = this.getDataValueFactory();
        switch (formatId) {
            default: {
                return constantValue;
            }
            case 13: {
                String sourceValue = constantValue.getString();
                int sourceWidth = sourceValue.length();
                if (sourceWidth <= maxWidth && formatId == 13) {
                    return dvf.getVarcharDataValue(sourceValue);
                }
                for (int posn = maxWidth; posn < sourceWidth; ++posn) {
                    if (sourceValue.charAt(posn) == ' ') continue;
                    String typeName = null;
                    if (formatId == 13) {
                        typeName = "VARCHAR";
                    }
                    throw StandardException.newException((String)"22001", (Object[])new Object[]{typeName, StringUtil.formatForPrint(sourceValue), String.valueOf(maxWidth)});
                }
                if (formatId != 13) break;
                return dvf.getVarcharDataValue(sourceValue.substring(0, maxWidth));
            }
            case 230: 
        }
        return dvf.getLongvarcharDataValue(constantValue.getString());
    }

    public TableName getTableNameObject() {
        return null;
    }

    public ColumnReference getReference() {
        return this._reference;
    }

    ColumnDescriptor getColumnDescriptor() {
        return this._columnDescriptor;
    }

    BaseColumnNode getBaseColumnNode() {
        ValueNode vn = this._expression;
        while (true) {
            if (vn instanceof ResultColumn) {
                vn = ((ResultColumn)vn)._expression;
                continue;
            }
            if (vn instanceof ColumnReference) {
                vn = ((ColumnReference)vn).getSource();
                continue;
            }
            if (!(vn instanceof VirtualColumnNode)) break;
            vn = ((VirtualColumnNode)vn).getSourceColumn();
        }
        if (vn instanceof BaseColumnNode) {
            return (BaseColumnNode)vn;
        }
        return null;
    }

    int getTableNumber() throws StandardException {
        if (this._expression instanceof ColumnReference) {
            return ((ColumnReference)this._expression).getTableNumber();
        }
        if (this._expression instanceof VirtualColumnNode) {
            VirtualColumnNode vcn = (VirtualColumnNode)this._expression;
            if (vcn.getSourceResultSet() instanceof FromBaseTable) {
                return ((FromBaseTable)vcn.getSourceResultSet()).getTableNumber();
            }
            return vcn.getSourceColumn().getTableNumber();
        }
        return -1;
    }

    @Override
    boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeKind(o)) {
            ResultColumn other = (ResultColumn)o;
            if (this._expression != null) {
                return this._expression.isEquivalent(other._expression);
            }
        }
        return false;
    }

    @Override
    public boolean hasGenerationClause() {
        return this._columnDescriptor != null && this._columnDescriptor.hasGenerationClause();
    }
}

