/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.impl.sql.GenericParameterValueSet;
import org.apache.derby.impl.sql.GenericResultDescription;
import org.apache.derby.impl.sql.LanguageDbPropertySetter;
import org.apache.derby.shared.common.error.StandardException;

public class GenericLanguageFactory
implements LanguageFactory,
ModuleControl {
    private GenericParameterValueSet emptySet;

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        LanguageConnectionFactory lcf = (LanguageConnectionFactory)GenericLanguageFactory.findServiceModule(this, "org.apache.derby.iapi.sql.conn.LanguageConnectionFactory");
        PropertyFactory pf = lcf.getPropertyFactory();
        if (pf != null) {
            pf.addPropertySetNotification(new LanguageDbPropertySetter());
        }
        this.emptySet = new GenericParameterValueSet(null, 0, false);
    }

    @Override
    public void stop() {
    }

    @Override
    public ParameterValueSet newParameterValueSet(ClassInspector ci, int numParms, boolean hasReturnParam) {
        if (numParms == 0) {
            return this.emptySet;
        }
        return new GenericParameterValueSet(ci, numParms, hasReturnParam);
    }

    @Override
    public ResultDescription getResultDescription(ResultDescription inputResultDescription, int[] theCols) {
        return new GenericResultDescription(inputResultDescription, theCols);
    }

    @Override
    public ResultDescription getResultDescription(ResultColumnDescriptor[] cols, String type) {
        return new GenericResultDescription(cols, type);
    }

    private static Object findServiceModule(final Object serviceModule, final String factoryInterface) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(serviceModule, factoryInterface);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException((Throwable)pae);
        }
    }
}

