/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class SQLLongint
extends NumberDataType {
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLLongint.class);
    private long value;
    private boolean isnull;

    @Override
    public int getInt() throws StandardException {
        if (this.value > Integer.MAX_VALUE || this.value < Integer.MIN_VALUE) {
            throw StandardException.newException((String)"22003", (Object[])new Object[]{"INTEGER"});
        }
        return (int)this.value;
    }

    @Override
    public byte getByte() throws StandardException {
        if (this.value > 127L || this.value < -128L) {
            throw StandardException.newException((String)"22003", (Object[])new Object[]{"TINYINT"});
        }
        return (byte)this.value;
    }

    @Override
    public short getShort() throws StandardException {
        if (this.value > 32767L || this.value < -32768L) {
            throw StandardException.newException((String)"22003", (Object[])new Object[]{"SMALLINT"});
        }
        return (short)this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public boolean getBoolean() {
        return this.value != 0L;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Long.toString(this.value);
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public String getTypeName() {
        return "BIGINT";
    }

    @Override
    public int getTypeFormatId() {
        return 84;
    }

    @Override
    public boolean isNull() {
        return this.isnull;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0);
        out.writeLong(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.value = in.readLong();
        this.isnull = false;
    }

    @Override
    public void restoreToNull() {
        this.value = 0L;
        this.isnull = true;
    }

    @Override
    protected int typeCompare(DataValueDescriptor arg) throws StandardException {
        long otherValue;
        long thisValue = this.getLong();
        if (thisValue == (otherValue = arg.getLong())) {
            return 0;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return -1;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        return new SQLLongint(this.value, this.isnull);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLLongint();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getLong(colNumber);
        this.isnull = this.value == 0L ? isNullable && resultSet.wasNull() : false;
    }

    @Override
    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, -5);
            return;
        }
        ps.setLong(position, this.value);
    }

    @Override
    public final void setInto(ResultSet rs, int position) throws SQLException {
        rs.updateLong(position, this.value);
    }

    public SQLLongint() {
        this.isnull = true;
    }

    public SQLLongint(long val) {
        this.value = val;
    }

    private SQLLongint(long val, boolean isnull) {
        this.value = val;
        this.isnull = isnull;
    }

    public SQLLongint(Long obj) {
        this.isnull = obj == null;
        if (!this.isnull) {
            this.value = obj;
        }
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        if (theValue == null) {
            this.value = 0L;
            this.isnull = true;
        } else {
            try {
                this.value = Long.valueOf(theValue.trim());
            }
            catch (NumberFormatException nfe) {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    @Override
    public final void setValue(Number theValue) {
        if (this.objectNull(theValue)) {
            return;
        }
        if (!(theValue instanceof Long)) {
            SanityManager.THROWASSERT((String)("SQLLongint.setValue(Number) passed a " + theValue.getClass()));
        }
        this.setValue(theValue.longValue());
    }

    @Override
    public void setValue(long theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(int theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        if ((theValue = NumberDataType.normalizeREAL(theValue)) > 9.223372E18f || theValue < -9.223372E18f) {
            throw StandardException.newException((String)"22003", (Object[])new Object[]{"BIGINT"});
        }
        float floorValue = (float)Math.floor(theValue);
        this.value = (long)floorValue;
        this.isnull = false;
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        if ((theValue = NumberDataType.normalizeDOUBLE(theValue)) > 9.223372036854776E18 || theValue < -9.223372036854776E18) {
            throw StandardException.newException((String)"22003", (Object[])new Object[]{"BIGINT"});
        }
        double floorValue = Math.floor(theValue);
        this.value = (long)floorValue;
        this.isnull = false;
    }

    @Override
    public void setValue(boolean theValue) {
        this.value = theValue ? 1L : 0L;
        this.isnull = false;
    }

    @Override
    void setObject(Object theValue) {
        this.setValue((Long)theValue);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getLong());
    }

    @Override
    public int typePrecedence() {
        return 60;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() == right.getLong());
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() != right.getLong());
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() < right.getLong());
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() > right.getLong());
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() <= right.getLong());
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() >= right.getLong());
    }

    @Override
    public NumberDataValue plus(NumberDataValue addend1, NumberDataValue addend2, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (addend1.isNull() || addend2.isNull()) {
            result.setToNull();
            return result;
        }
        long addend1Long = addend1.getLong();
        long addend2Long = addend2.getLong();
        long resultValue = addend1Long + addend2Long;
        if (addend1Long < 0L == addend2Long < 0L && addend1Long < 0L != resultValue < 0L) {
            throw StandardException.newException((String)"22003", (Object[])new Object[]{"BIGINT"});
        }
        result.setValue(resultValue);
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        long diff = left.getLong() - right.getLong();
        if (left.getLong() < 0L != right.getLong() < 0L && left.getLong() < 0L != diff < 0L) {
            throw StandardException.newException((String)"22003", (Object[])new Object[]{"BIGINT"});
        }
        result.setValue(diff);
        return result;
    }

    @Override
    public NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        long tempResult = left.getLong() * right.getLong();
        if (right.getLong() != 0L && left.getLong() != tempResult / right.getLong()) {
            throw StandardException.newException((String)"22003", (Object[])new Object[]{"BIGINT"});
        }
        result.setValue(tempResult);
        return result;
    }

    @Override
    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        long longDivisor = divisor.getLong();
        if (longDivisor == 0L) {
            throw StandardException.newException((String)"22012", (Object[])new Object[0]);
        }
        result.setValue(dividend.getLong() / longDivisor);
        return result;
    }

    @Override
    public NumberDataValue mod(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        long longDivisor = divisor.getLong();
        if (longDivisor == 0L) {
            throw StandardException.newException((String)"22012", (Object[])new Object[0]);
        }
        result.setValue(dividend.getLong() % longDivisor);
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        long operandValue = this.getLong();
        if (operandValue == Long.MIN_VALUE) {
            throw StandardException.newException((String)"22003", (Object[])new Object[]{"BIGINT"});
        }
        result.setValue(-operandValue);
        return result;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.value < 0L;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Long.toString(this.value);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }
}

